#include "__openglsource.h"

#include "wiregl/include/wireGL.h"
#include "wiregl/include/wiregl_protocol.h"
#include "wiregl/include/wiregl_client.h"
#include "wiregl/include/wiregl_common.h"

#if COLOR_COMPRESSION

#include <limits.h>

OPENGL_DECL void OPENGL_APIENTRY WIREGL_FUNCTION( glColor3d )( GLdouble red, GLdouble green, GLdouble blue )
{
	unsigned char *data_ptr;
	GET_BUFFERED_POINTER( 3 );
	WRITE_DATA( 0, GLubyte, (GLubyte)(red * UCHAR_MAX) );
	WRITE_DATA( 1, GLubyte, (GLubyte)(green * UCHAR_MAX) );
	WRITE_DATA( 2, GLubyte, (GLubyte)(blue * UCHAR_MAX) );
	WRITE_OPCODE( WIREGL_GLCOLOR3UB_OPCODE );
}

OPENGL_DECL void OPENGL_APIENTRY WIREGL_FUNCTION( glColor3dv )( const GLdouble *v )
{
	unsigned char *data_ptr;
	GET_BUFFERED_POINTER( 3 );
	WRITE_DATA( 0, GLubyte, (GLubyte)(v[0] * UCHAR_MAX) );
	WRITE_DATA( 1, GLubyte, (GLubyte)(v[1] * UCHAR_MAX) );
	WRITE_DATA( 2, GLubyte, (GLubyte)(v[2] * UCHAR_MAX) );
	WRITE_OPCODE( WIREGL_GLCOLOR3UB_OPCODE );
}

OPENGL_DECL void OPENGL_APIENTRY WIREGL_FUNCTION( glColor3f )( GLfloat red, GLfloat green, GLfloat blue )
{
	unsigned char *data_ptr;
	GET_BUFFERED_POINTER( 3 );
	WRITE_DATA( 0, GLubyte, (GLubyte)(red * UCHAR_MAX) );
	WRITE_DATA( 1, GLubyte, (GLubyte)(green * UCHAR_MAX) );
	WRITE_DATA( 2, GLubyte, (GLubyte)(blue * UCHAR_MAX) );
	WRITE_OPCODE( WIREGL_GLCOLOR3UB_OPCODE );
}

OPENGL_DECL void OPENGL_APIENTRY WIREGL_FUNCTION( glColor3fv )( const GLfloat *v )
{
	unsigned char *data_ptr;
	GET_BUFFERED_POINTER( 3 );
	WRITE_DATA( 0, GLubyte, (GLubyte)(v[0] * UCHAR_MAX) );
	WRITE_DATA( 1, GLubyte, (GLubyte)(v[1] * UCHAR_MAX) );
	WRITE_DATA( 2, GLubyte, (GLubyte)(v[2] * UCHAR_MAX) );
	WRITE_OPCODE( WIREGL_GLCOLOR3UB_OPCODE );
}

OPENGL_DECL void OPENGL_APIENTRY WIREGL_FUNCTION( glColor3i )( GLint red, GLint green, GLint blue )
{
	unsigned char *data_ptr;
	GET_BUFFERED_POINTER( 3 );
	WRITE_DATA( 0, GLubyte, (GLubyte)(red >> 24) );
	WRITE_DATA( 1, GLubyte, (GLubyte)(green >> 24) );
	WRITE_DATA( 2, GLubyte, (GLubyte)(blue >> 24) );
	WRITE_OPCODE( WIREGL_GLCOLOR3UB_OPCODE );
}

OPENGL_DECL void OPENGL_APIENTRY WIREGL_FUNCTION( glColor3iv )( const GLint *v )
{
	unsigned char *data_ptr;
	GET_BUFFERED_POINTER( 3 );
	WRITE_DATA( 0, GLubyte, (GLubyte)(v[0] >> 24) );
	WRITE_DATA( 1, GLubyte, (GLubyte)(v[1] >> 24) );
	WRITE_DATA( 2, GLubyte, (GLubyte)(v[2] >> 24) );
	WRITE_OPCODE( WIREGL_GLCOLOR3UB_OPCODE );
}

OPENGL_DECL void OPENGL_APIENTRY WIREGL_FUNCTION( glColor3s )( GLshort red, GLshort green, GLshort blue )
{
	unsigned char *data_ptr;
	GET_BUFFERED_POINTER( 3 );
	WRITE_DATA( 0, GLubyte, (GLubyte)(red >> 8) );
	WRITE_DATA( 1, GLubyte, (GLubyte)(green >> 8) );
	WRITE_DATA( 2, GLubyte, (GLubyte)(blue >> 8) );
	WRITE_OPCODE( WIREGL_GLCOLOR3UB_OPCODE );
}

OPENGL_DECL void OPENGL_APIENTRY WIREGL_FUNCTION( glColor3sv )( const GLshort *v )
{
	unsigned char *data_ptr;
	GET_BUFFERED_POINTER( 3 );
	WRITE_DATA( 0, GLubyte, (GLubyte)(v[0] >> 8) );
	WRITE_DATA( 1, GLubyte, (GLubyte)(v[1] >> 8) );
	WRITE_DATA( 2, GLubyte, (GLubyte)(v[2] >> 8) );
	WRITE_OPCODE( WIREGL_GLCOLOR3UB_OPCODE );
}

OPENGL_DECL void OPENGL_APIENTRY WIREGL_FUNCTION( glColor3ui )( GLuint red, GLuint green, GLuint blue )
{
	unsigned char *data_ptr;
	GET_BUFFERED_POINTER( 3 );
	WRITE_DATA( 0, GLubyte, (GLubyte)(red >> 24) );
	WRITE_DATA( 1, GLubyte, (GLubyte)(green >> 24) );
	WRITE_DATA( 2, GLubyte, (GLubyte)(blue >> 24) );
	WRITE_OPCODE( WIREGL_GLCOLOR3UB_OPCODE );
}

OPENGL_DECL void OPENGL_APIENTRY WIREGL_FUNCTION( glColor3uiv )( const GLuint *v )
{
	unsigned char *data_ptr;
	GET_BUFFERED_POINTER( 3 );
	WRITE_DATA( 0, GLubyte, (GLubyte)(v[0] >> 24) );
	WRITE_DATA( 1, GLubyte, (GLubyte)(v[1] >> 24) );
	WRITE_DATA( 2, GLubyte, (GLubyte)(v[2] >> 24) );
	WRITE_OPCODE( WIREGL_GLCOLOR3UB_OPCODE );
}

OPENGL_DECL void OPENGL_APIENTRY WIREGL_FUNCTION( glColor3us )( GLushort red, GLushort green, GLushort blue )
{
	unsigned char *data_ptr;
	GET_BUFFERED_POINTER( 3 );
	WRITE_DATA( 0, GLubyte, (GLubyte)(red >> 8) );
	WRITE_DATA( 1, GLubyte, (GLubyte)(green >> 8) );
	WRITE_DATA( 2, GLubyte, (GLubyte)(blue >> 8) );
	WRITE_OPCODE( WIREGL_GLCOLOR3UB_OPCODE );
}

OPENGL_DECL void OPENGL_APIENTRY WIREGL_FUNCTION( glColor3usv )( const GLushort *v )
{
	unsigned char *data_ptr;
	GET_BUFFERED_POINTER( 3 );
	WRITE_DATA( 0, GLubyte, (GLubyte)(v[0] >> 8) );
	WRITE_DATA( 1, GLubyte, (GLubyte)(v[1] >> 8) );
	WRITE_DATA( 2, GLubyte, (GLubyte)(v[2] >> 8) );
	WRITE_OPCODE( WIREGL_GLCOLOR3UB_OPCODE );
}

OPENGL_DECL void OPENGL_APIENTRY WIREGL_FUNCTION( glColor4d )( GLdouble red, GLdouble green, GLdouble blue, GLdouble alpha )
{
	unsigned char *data_ptr;
	GET_BUFFERED_POINTER( 4 );
	WRITE_DATA( 0, GLubyte, (GLubyte)(red * UCHAR_MAX) );
	WRITE_DATA( 1, GLubyte, (GLubyte)(green * UCHAR_MAX) );
	WRITE_DATA( 2, GLubyte, (GLubyte)(blue * UCHAR_MAX) );
	WRITE_DATA( 3, GLubyte, (GLubyte)(alpha * UCHAR_MAX) );
	WRITE_OPCODE( WIREGL_GLCOLOR4UB_OPCODE );
}

OPENGL_DECL void OPENGL_APIENTRY WIREGL_FUNCTION( glColor4dv )( const GLdouble *v )
{
	unsigned char *data_ptr;
	GET_BUFFERED_POINTER( 4 );
	WRITE_DATA( 0, GLubyte, (GLubyte)(v[0] * UCHAR_MAX) );
	WRITE_DATA( 1, GLubyte, (GLubyte)(v[1] * UCHAR_MAX) );
	WRITE_DATA( 2, GLubyte, (GLubyte)(v[2] * UCHAR_MAX) );
	WRITE_DATA( 3, GLubyte, (GLubyte)(v[3] * UCHAR_MAX) );
	WRITE_OPCODE( WIREGL_GLCOLOR4UB_OPCODE );
}

OPENGL_DECL void OPENGL_APIENTRY WIREGL_FUNCTION( glColor4f )( GLfloat red, GLfloat green, GLfloat blue, GLfloat alpha )
{
	unsigned char *data_ptr;
	GET_BUFFERED_POINTER( 4 );
	WRITE_DATA( 0, GLubyte, (GLubyte)(red * UCHAR_MAX) );
	WRITE_DATA( 1, GLubyte, (GLubyte)(green * UCHAR_MAX) );
	WRITE_DATA( 2, GLubyte, (GLubyte)(blue * UCHAR_MAX) );
	WRITE_DATA( 3, GLubyte, (GLubyte)(alpha * UCHAR_MAX) );
	WRITE_OPCODE( WIREGL_GLCOLOR4UB_OPCODE );
}

OPENGL_DECL void OPENGL_APIENTRY WIREGL_FUNCTION( glColor4fv )( const GLfloat *v )
{
	unsigned char *data_ptr;
	GET_BUFFERED_POINTER( 4 );
	WRITE_DATA( 0, GLubyte, (GLubyte)(v[0] * UCHAR_MAX) );
	WRITE_DATA( 1, GLubyte, (GLubyte)(v[1] * UCHAR_MAX) );
	WRITE_DATA( 2, GLubyte, (GLubyte)(v[2] * UCHAR_MAX) );
	WRITE_DATA( 3, GLubyte, (GLubyte)(v[3] * UCHAR_MAX) );
	WRITE_OPCODE( WIREGL_GLCOLOR4UB_OPCODE );
}

OPENGL_DECL void OPENGL_APIENTRY WIREGL_FUNCTION( glColor4i )( GLint red, GLint green, GLint blue, GLint alpha )
{
	unsigned char *data_ptr;
	GET_BUFFERED_POINTER( 4 );
	WRITE_DATA( 0, GLubyte, (GLubyte)(red >> 24) );
	WRITE_DATA( 1, GLubyte, (GLubyte)(green >> 24) );
	WRITE_DATA( 2, GLubyte, (GLubyte)(blue >> 24) );
	WRITE_DATA( 3, GLubyte, (GLubyte)(alpha >> 24) );
	WRITE_OPCODE( WIREGL_GLCOLOR4UB_OPCODE );
}

OPENGL_DECL void OPENGL_APIENTRY WIREGL_FUNCTION( glColor4iv )( const GLint *v )
{
	unsigned char *data_ptr;
	GET_BUFFERED_POINTER( 4 );
	WRITE_DATA( 0, GLubyte, (GLubyte)(v[0] >> 24) );
	WRITE_DATA( 1, GLubyte, (GLubyte)(v[1] >> 24) );
	WRITE_DATA( 2, GLubyte, (GLubyte)(v[2] >> 24) );
	WRITE_DATA( 3, GLubyte, (GLubyte)(v[3] >> 24) );
	WRITE_OPCODE( WIREGL_GLCOLOR4UB_OPCODE );
}

OPENGL_DECL void OPENGL_APIENTRY WIREGL_FUNCTION( glColor4s )( GLshort red, GLshort green, GLshort blue, GLshort alpha )
{
	unsigned char *data_ptr;
	GET_BUFFERED_POINTER( 4 );
	WRITE_DATA( 0, GLubyte, (GLubyte)(red >> 8) );
	WRITE_DATA( 1, GLubyte, (GLubyte)(green >> 8) );
	WRITE_DATA( 2, GLubyte, (GLubyte)(blue >> 8) );
	WRITE_DATA( 3, GLubyte, (GLubyte)(alpha >> 8) );
	WRITE_OPCODE( WIREGL_GLCOLOR4UB_OPCODE );
}

OPENGL_DECL void OPENGL_APIENTRY WIREGL_FUNCTION( glColor4sv )( const GLshort *v )
{
	unsigned char *data_ptr;
	GET_BUFFERED_POINTER( 4 );
	WRITE_DATA( 0, GLubyte, (GLubyte)(v[0] >> 8) );
	WRITE_DATA( 1, GLubyte, (GLubyte)(v[1] >> 8) );
	WRITE_DATA( 2, GLubyte, (GLubyte)(v[2] >> 8) );
	WRITE_DATA( 3, GLubyte, (GLubyte)(v[3] >> 8) );
	WRITE_OPCODE( WIREGL_GLCOLOR4UB_OPCODE );
}

OPENGL_DECL void OPENGL_APIENTRY WIREGL_FUNCTION( glColor4ui )( GLuint red, GLuint green, GLuint blue, GLuint alpha )
{
	unsigned char *data_ptr;
	GET_BUFFERED_POINTER( 4 );
	WRITE_DATA( 0, GLubyte, (GLubyte)(red >> 24) );
	WRITE_DATA( 1, GLubyte, (GLubyte)(green >> 24) );
	WRITE_DATA( 2, GLubyte, (GLubyte)(blue >> 24) );
	WRITE_DATA( 3, GLubyte, (GLubyte)(alpha >> 24) );
	WRITE_OPCODE( WIREGL_GLCOLOR4UB_OPCODE );
}

OPENGL_DECL void OPENGL_APIENTRY WIREGL_FUNCTION( glColor4uiv )( const GLuint *v )
{
	unsigned char *data_ptr;
	GET_BUFFERED_POINTER( 4 );
	WRITE_DATA( 0, GLubyte, (GLubyte)(v[0] >> 24) );
	WRITE_DATA( 1, GLubyte, (GLubyte)(v[1] >> 24) );
	WRITE_DATA( 2, GLubyte, (GLubyte)(v[2] >> 24) );
	WRITE_DATA( 3, GLubyte, (GLubyte)(v[3] >> 24) );
	WRITE_OPCODE( WIREGL_GLCOLOR4UB_OPCODE );
}

OPENGL_DECL void OPENGL_APIENTRY WIREGL_FUNCTION( glColor4us )( GLushort red, GLushort green, GLushort blue, GLushort alpha )
{
	unsigned char *data_ptr;
	GET_BUFFERED_POINTER( 4 );
	WRITE_DATA( 0, GLubyte, (GLubyte)(red >> 8) );
	WRITE_DATA( 1, GLubyte, (GLubyte)(green >> 8) );
	WRITE_DATA( 2, GLubyte, (GLubyte)(blue >> 8) );
	WRITE_DATA( 3, GLubyte, (GLubyte)(alpha >> 8) );
	WRITE_OPCODE( WIREGL_GLCOLOR4UB_OPCODE );
}

OPENGL_DECL void OPENGL_APIENTRY WIREGL_FUNCTION( glColor4usv )( const GLushort *v )
{
	unsigned char *data_ptr;
	GET_BUFFERED_POINTER( 4 );
	WRITE_DATA( 0, GLubyte, (GLubyte)(v[0] >> 8) );
	WRITE_DATA( 1, GLubyte, (GLubyte)(v[1] >> 8) );
	WRITE_DATA( 2, GLubyte, (GLubyte)(v[2] >> 8) );
	WRITE_DATA( 3, GLubyte, (GLubyte)(v[3] >> 8) );
	WRITE_OPCODE( WIREGL_GLCOLOR4UB_OPCODE );
}

#else

OPENGL_DECL void OPENGL_APIENTRY WIREGL_FUNCTION( glColor3d )( GLdouble red, GLdouble green, GLdouble blue )
{
	unsigned char *data_ptr;
	GET_BUFFERED_POINTER( 24 );
	WRITE_DOUBLE( 0, red );
	WRITE_DOUBLE( 8, green );
	WRITE_DOUBLE( 16, blue );
	WRITE_OPCODE( WIREGL_GLCOLOR3D_OPCODE );
}

OPENGL_DECL void OPENGL_APIENTRY WIREGL_FUNCTION( glColor3dv )( const GLdouble *v )
{
	unsigned char *data_ptr;
	GET_BUFFERED_POINTER( 24 );
	WRITE_DOUBLE( 0, v[0] );
	WRITE_DOUBLE( 8, v[1] );
	WRITE_DOUBLE( 16, v[2] );
	WRITE_OPCODE( WIREGL_GLCOLOR3D_OPCODE );
}

OPENGL_DECL void OPENGL_APIENTRY WIREGL_FUNCTION( glColor3f )( GLfloat red, GLfloat green, GLfloat blue )
{
	unsigned char *data_ptr;
	GET_BUFFERED_POINTER( 12 );
	WRITE_DATA( 0, GLfloat, red );
	WRITE_DATA( 4, GLfloat, green );
	WRITE_DATA( 8, GLfloat, blue );
	WRITE_OPCODE( WIREGL_GLCOLOR3F_OPCODE );
}

OPENGL_DECL void OPENGL_APIENTRY WIREGL_FUNCTION( glColor3fv )( const GLfloat *v )
{
	unsigned char *data_ptr;
	GET_BUFFERED_POINTER( 12 );
	WRITE_DATA( 0, GLfloat, v[0] );
	WRITE_DATA( 4, GLfloat, v[1] );
	WRITE_DATA( 8, GLfloat, v[2] );
	WRITE_OPCODE( WIREGL_GLCOLOR3F_OPCODE );
}

OPENGL_DECL void OPENGL_APIENTRY WIREGL_FUNCTION( glColor3i )( GLint red, GLint green, GLint blue )
{
	unsigned char *data_ptr;
	GET_BUFFERED_POINTER( 12 );
	WRITE_DATA( 0, GLint, red );
	WRITE_DATA( 4, GLint, green );
	WRITE_DATA( 8, GLint, blue );
	WRITE_OPCODE( WIREGL_GLCOLOR3I_OPCODE );
}

OPENGL_DECL void OPENGL_APIENTRY WIREGL_FUNCTION( glColor3iv )( const GLint *v )
{
	unsigned char *data_ptr;
	GET_BUFFERED_POINTER( 12 );
	WRITE_DATA( 0, GLint, v[0] );
	WRITE_DATA( 4, GLint, v[1] );
	WRITE_DATA( 8, GLint, v[2] );
	WRITE_OPCODE( WIREGL_GLCOLOR3I_OPCODE );
}

OPENGL_DECL void OPENGL_APIENTRY WIREGL_FUNCTION( glColor3s )( GLshort red, GLshort green, GLshort blue )
{
	unsigned char *data_ptr;
	GET_BUFFERED_POINTER( 6 );
	WRITE_DATA( 0, GLshort, red );
	WRITE_DATA( 2, GLshort, green );
	WRITE_DATA( 4, GLshort, blue );
	WRITE_OPCODE( WIREGL_GLCOLOR3S_OPCODE );
}

OPENGL_DECL void OPENGL_APIENTRY WIREGL_FUNCTION( glColor3sv )( const GLshort *v )
{
	unsigned char *data_ptr;
	GET_BUFFERED_POINTER( 6 );
	WRITE_DATA( 0, GLshort, v[0] );
	WRITE_DATA( 2, GLshort, v[1] );
	WRITE_DATA( 4, GLshort, v[2] );
	WRITE_OPCODE( WIREGL_GLCOLOR3S_OPCODE );
}

OPENGL_DECL void OPENGL_APIENTRY WIREGL_FUNCTION( glColor3ui )( GLuint red, GLuint green, GLuint blue )
{
	unsigned char *data_ptr;
	GET_BUFFERED_POINTER( 12 );
	WRITE_DATA( 0, GLuint, red );
	WRITE_DATA( 4, GLuint, green );
	WRITE_DATA( 8, GLuint, blue );
	WRITE_OPCODE( WIREGL_GLCOLOR3UI_OPCODE );
}

OPENGL_DECL void OPENGL_APIENTRY WIREGL_FUNCTION( glColor3uiv )( const GLuint *v )
{
	unsigned char *data_ptr;
	GET_BUFFERED_POINTER( 12 );
	WRITE_DATA( 0, GLuint, v[0] );
	WRITE_DATA( 4, GLuint, v[1] );
	WRITE_DATA( 8, GLuint, v[2] );
	WRITE_OPCODE( WIREGL_GLCOLOR3UI_OPCODE );
}

OPENGL_DECL void OPENGL_APIENTRY WIREGL_FUNCTION( glColor3us )( GLushort red, GLushort green, GLushort blue )
{
	unsigned char *data_ptr;
	GET_BUFFERED_POINTER( 6 );
	WRITE_DATA( 0, GLushort, red );
	WRITE_DATA( 2, GLushort, green );
	WRITE_DATA( 4, GLushort, blue );
	WRITE_OPCODE( WIREGL_GLCOLOR3US_OPCODE );
}

OPENGL_DECL void OPENGL_APIENTRY WIREGL_FUNCTION( glColor3usv )( const GLushort *v )
{
	unsigned char *data_ptr;
	GET_BUFFERED_POINTER( 6 );
	WRITE_DATA( 0, GLushort, v[0] );
	WRITE_DATA( 2, GLushort, v[1] );
	WRITE_DATA( 4, GLushort, v[2] );
	WRITE_OPCODE( WIREGL_GLCOLOR3US_OPCODE );
}

OPENGL_DECL void OPENGL_APIENTRY WIREGL_FUNCTION( glColor4d )( GLdouble red, GLdouble green, GLdouble blue, GLdouble alpha )
{
	unsigned char *data_ptr;
	GET_BUFFERED_POINTER( 32 );
	WRITE_DOUBLE( 0, red );
	WRITE_DOUBLE( 8, green );
	WRITE_DOUBLE( 16, blue );
	WRITE_DOUBLE( 24, alpha );
	WRITE_OPCODE( WIREGL_GLCOLOR4D_OPCODE );
}

OPENGL_DECL void OPENGL_APIENTRY WIREGL_FUNCTION( glColor4dv )( const GLdouble *v )
{
	unsigned char *data_ptr;
	GET_BUFFERED_POINTER( 32 );
	WRITE_DOUBLE( 0, v[0] );
	WRITE_DOUBLE( 8, v[1] );
	WRITE_DOUBLE( 16, v[2] );
	WRITE_DOUBLE( 24, v[3] );
	WRITE_OPCODE( WIREGL_GLCOLOR4D_OPCODE );
}

OPENGL_DECL void OPENGL_APIENTRY WIREGL_FUNCTION( glColor4f )( GLfloat red, GLfloat green, GLfloat blue, GLfloat alpha )
{
	unsigned char *data_ptr;
	GET_BUFFERED_POINTER( 16 );
	WRITE_DATA( 0, GLfloat, red );
	WRITE_DATA( 4, GLfloat, green );
	WRITE_DATA( 8, GLfloat, blue );
	WRITE_DATA( 12, GLfloat, alpha );
	WRITE_OPCODE( WIREGL_GLCOLOR4F_OPCODE );
}

OPENGL_DECL void OPENGL_APIENTRY WIREGL_FUNCTION( glColor4fv )( const GLfloat *v )
{
	unsigned char *data_ptr;
	GET_BUFFERED_POINTER( 16 );
	WRITE_DATA( 0, GLfloat, v[0] );
	WRITE_DATA( 4, GLfloat, v[1] );
	WRITE_DATA( 8, GLfloat, v[2] );
	WRITE_DATA( 12, GLfloat, v[3] );
	WRITE_OPCODE( WIREGL_GLCOLOR4F_OPCODE );
}

OPENGL_DECL void OPENGL_APIENTRY WIREGL_FUNCTION( glColor4i )( GLint red, GLint green, GLint blue, GLint alpha )
{
	unsigned char *data_ptr;
	GET_BUFFERED_POINTER( 16 );
	WRITE_DATA( 0, GLint, red );
	WRITE_DATA( 4, GLint, green );
	WRITE_DATA( 8, GLint, blue );
	WRITE_DATA( 12, GLint, alpha );
	WRITE_OPCODE( WIREGL_GLCOLOR4I_OPCODE );
}

OPENGL_DECL void OPENGL_APIENTRY WIREGL_FUNCTION( glColor4iv )( const GLint *v )
{
	unsigned char *data_ptr;
	GET_BUFFERED_POINTER( 16 );
	WRITE_DATA( 0, GLint, v[0] );
	WRITE_DATA( 4, GLint, v[1] );
	WRITE_DATA( 8, GLint, v[2] );
	WRITE_DATA( 12, GLint, v[3] );
	WRITE_OPCODE( WIREGL_GLCOLOR4I_OPCODE );
}

OPENGL_DECL void OPENGL_APIENTRY WIREGL_FUNCTION( glColor4s )( GLshort red, GLshort green, GLshort blue, GLshort alpha )
{
	unsigned char *data_ptr;
	GET_BUFFERED_POINTER( 8 );
	WRITE_DATA( 0, GLshort, red );
	WRITE_DATA( 2, GLshort, green );
	WRITE_DATA( 4, GLshort, blue );
	WRITE_DATA( 6, GLshort, alpha );
	WRITE_OPCODE( WIREGL_GLCOLOR4S_OPCODE );
}

OPENGL_DECL void OPENGL_APIENTRY WIREGL_FUNCTION( glColor4sv )( const GLshort *v )
{
	unsigned char *data_ptr;
	GET_BUFFERED_POINTER( 8 );
	WRITE_DATA( 0, GLshort, v[0] );
	WRITE_DATA( 2, GLshort, v[1] );
	WRITE_DATA( 4, GLshort, v[2] );
	WRITE_DATA( 6, GLshort, v[3] );
	WRITE_OPCODE( WIREGL_GLCOLOR4S_OPCODE );
}

OPENGL_DECL void OPENGL_APIENTRY WIREGL_FUNCTION( glColor4ui )( GLuint red, GLuint green, GLuint blue, GLuint alpha )
{
	unsigned char *data_ptr;
	GET_BUFFERED_POINTER( 16 );
	WRITE_DATA( 0, GLuint, red );
	WRITE_DATA( 4, GLuint, green );
	WRITE_DATA( 8, GLuint, blue );
	WRITE_DATA( 12, GLuint, alpha );
	WRITE_OPCODE( WIREGL_GLCOLOR4UI_OPCODE );
}

OPENGL_DECL void OPENGL_APIENTRY WIREGL_FUNCTION( glColor4uiv )( const GLuint *v )
{
	unsigned char *data_ptr;
	GET_BUFFERED_POINTER( 16 );
	WRITE_DATA( 0, GLuint, v[0] );
	WRITE_DATA( 4, GLuint, v[1] );
	WRITE_DATA( 8, GLuint, v[2] );
	WRITE_DATA( 12, GLuint, v[3] );
	WRITE_OPCODE( WIREGL_GLCOLOR4UI_OPCODE );
}

OPENGL_DECL void OPENGL_APIENTRY WIREGL_FUNCTION( glColor4us )( GLushort red, GLushort green, GLushort blue, GLushort alpha )
{
	unsigned char *data_ptr;
	GET_BUFFERED_POINTER( 8 );
	WRITE_DATA( 0, GLushort, red );
	WRITE_DATA( 2, GLushort, green );
	WRITE_DATA( 4, GLushort, blue );
	WRITE_DATA( 6, GLushort, alpha );
	WRITE_OPCODE( WIREGL_GLCOLOR4US_OPCODE );
}

OPENGL_DECL void OPENGL_APIENTRY WIREGL_FUNCTION( glColor4usv )( const GLushort *v )
{
	unsigned char *data_ptr;
	GET_BUFFERED_POINTER( 8 );
	WRITE_DATA( 0, GLushort, v[0] );
	WRITE_DATA( 2, GLushort, v[1] );
	WRITE_DATA( 4, GLushort, v[2] );
	WRITE_DATA( 6, GLushort, v[3] );
	WRITE_OPCODE( WIREGL_GLCOLOR4US_OPCODE );
}

#endif