#include <stdlib.h>

typedef struct
{
	unsigned char curData[12];
	int curByte;
	int curBit;
} BitFieldT;

static __inline void InitBitField(BitFieldT *bitField)
{
	bitField->curByte = 0;
	bitField->curBit = 0;
	memset(bitField->curData, 0, 12);
}

static __inline void AddBitsToByte(BitFieldT *bitField, unsigned char *inData, int startBit, int numBits)
{
	unsigned char mask, data;

	data = *inData;
	mask = 0xFF << (8 - numBits);
	mask >>= (8 - numBits - startBit);
	data &= mask;
	if(bitField->curBit > startBit)
		data <<= bitField->curBit - startBit;
	else
		data >>= startBit - bitField->curBit;
	bitField->curData[bitField->curByte] |= data;
	bitField->curBit += numBits;
	if(bitField->curBit >= 8)
	{
		bitField->curByte++;
		bitField->curBit-=8;
	}
}

static __inline int MyMin( int a, int b )
{
	return (a < b) ? a : b;
}

static __inline void AddBitsToBitField(BitFieldT *bitField, unsigned char data[], int numBits)
{
	int curNumBits = MyMin(numBits, 8 - bitField->curBit), doneBits = 0;
	AddBitsToByte(bitField, data, 0, curNumBits);

	numBits -= curNumBits;
	doneBits += curNumBits;

	while(numBits > 0)
	{
		if(doneBits >= 8)
		{
			data++;
			doneBits -= 8;
		}
		curNumBits = MyMin(numBits, 8 - doneBits);
		AddBitsToByte(bitField, data, doneBits, curNumBits);

		numBits -= curNumBits;
		doneBits += curNumBits;
	}
}
