/*
** 3/06/2001
** http://graphics.stanford.edu/software/wiregl
**
** Copyright 2001
** The Board of Trustees of The Leland Stanford Junior University.
** All rights reserved.
**
** Except for commercial resale, lease, license or other commercial
** transactions, permission is hereby given to use, copy, and/or
** modify this software, provided that the above copyright notice and
** this permission notice appear in all copies of this software.  No
** part of this software or any derivatives thereof may be used in
** graphics systems for resale or for use in a commercial product.
**
** This software is provided "as is" and without warranty of any kind,
** express, implied or otherwise, including without limitation, any
** warranty of merchantability or fitness for a particular purpose.
*/

#ifndef WIREGL_PROTOCOL_H
#define WIREGL_PROTOCOL_H

typedef enum {
    /* first message types is 'wGL\001', so we can immediately
       recognize bad message types */
    WIREGL_MESSAGE_OPCODES = 0x77474c01,
    WIREGL_MESSAGE_WRITEBACK,
	WIREGL_MESSAGE_READ_PIXELS,
	WIREGL_MESSAGE_MULTI_BODY,
	WIREGL_MESSAGE_MULTI_TAIL,
	WIREGL_MESSAGE_FLOW_CONTROL,
	WIREGL_MESSAGE_ERROR
} WireGLMessageType;

typedef union {
    /* pointers are usually 4 bytes, but on 64-bit machines (Alpha,
     * SGI-n64, etc.) they are 8 bytes.  Pass network pointers around
     * as an opaque array of bytes, since the interpretation & size of
     * the pointer only matter to the machine which emitted the
     * pointer (and will eventually receive the pointer back again) */
    unsigned int  ptrAlign[2];
    unsigned char ptrSize[8];
	/* hack to make this packet big */
	/* unsigned int  junk[512]; */
} WireGLNetworkPointer;

typedef struct WireGLMessageOpcodes {
	WireGLMessageType  		 type;
    unsigned int       		 senderId;
    unsigned int       		 numOpcodes;
} WireGLMessageOpcodes;

typedef struct WireGLMessageWriteback {
	WireGLMessageType        type;
} WireGLMessageWriteback;

typedef struct WireGLMessageMulti {
	WireGLMessageType        type;
} WireGLMessageMulti;

typedef struct WireGLMessageFlowControl {
	WireGLMessageType        type;
	unsigned int             credits;
} WireGLMessageFlowControl;

typedef struct WireGLMessageReadPixels {
	WireGLMessageType        type;
	unsigned int             bytes_per_row;
	unsigned int             stride;
	unsigned int             rows;
	WireGLNetworkPointer     pixels;
} WireGLMessageReadPixels;

typedef union {
	WireGLMessageType        type;
	WireGLMessageOpcodes     opcodes;
	WireGLMessageWriteback   writeback;
	WireGLMessageReadPixels  readPixels;
	WireGLMessageMulti       multi;
	WireGLMessageFlowControl flowControl;
} WireGLMessage;

void *wireGLNetworkPointerRead( WireGLNetworkPointer *src );
void wireGLNetworkPointerWrite( WireGLNetworkPointer *dst, void *src );

#endif /* WIREGL_PROTOCOL_H */

