/*
** 3/06/2001
** http://graphics.stanford.edu/software/wiregl
**
** Copyright 2001
** The Board of Trustees of The Leland Stanford Junior University.
** All rights reserved.
**
** Except for commercial resale, lease, license or other commercial
** transactions, permission is hereby given to use, copy, and/or
** modify this software, provided that the above copyright notice and
** this permission notice appear in all copies of this software.  No
** part of this software or any derivatives thereof may be used in
** graphics systems for resale or for use in a commercial product.
**
** This software is provided "as is" and without warranty of any kind,
** express, implied or otherwise, including without limitation, any
** warranty of merchantability or fitness for a particular purpose.
*/

#ifndef WIREGL_FEATHER_H
#define WIREGL_FEATHER_H

typedef struct {
	int   top_size;
	int   bottom_size;
	int   left_size;
	int   right_size;
	float top[4];
	float bottom[4];
	float left[4];
	float right[4];
	int   top_dice;
	int   bottom_dice;
	int   left_dice;
	int   right_dice;
	char  overlay[256];
} WireGLFeatherParam;

void wireGLConfigureFeathering ( int windowSize_x, int windowSize_y,
								 WireGLFeatherParam *param );

void wireGLDrawFeatheringStrips( void );

#endif /* WIREGL_FEATHER_H */
