/*
** 3/06/2001
** http://graphics.stanford.edu/software/wiregl
**
** Copyright 2001
** The Board of Trustees of The Leland Stanford Junior University.
** All rights reserved.
**
** Except for commercial resale, lease, license or other commercial
** transactions, permission is hereby given to use, copy, and/or
** modify this software, provided that the above copyright notice and
** this permission notice appear in all copies of this software.  No
** part of this software or any derivatives thereof may be used in
** graphics systems for resale or for use in a commercial product.
**
** This software is provided "as is" and without warranty of any kind,
** express, implied or otherwise, including without limitation, any
** warranty of merchantability or fitness for a particular purpose.
*/

#ifndef WIREGLGLBBOX_H
#define WIREGLGLBBOX_H

#include "wiregl/glcontext/glbase.h"
#include "wiregl/include/wireGL.h"

#ifdef __cplusplus
extern "C" {
#endif

#ifdef WINDOWS
#define UPDATE_2D_BBOX() \
__asm {\
	__asm fld fx\
	__asm fld __wiregl_globals.bounds_min.x\
	__asm fcomi st, st(1)\
	__asm fcmovnb st(0), st(1)\
	__asm fstp __wiregl_globals.bounds_min.x\
	__asm fld __wiregl_globals.bounds_max.x\
	__asm fcomi st, st(1)\
	__asm fcmovb st(0), st(1)\
	__asm fstp __wiregl_globals.bounds_max.x\
	__asm fstp fx\
	\
	__asm fld fy\
	__asm fld __wiregl_globals.bounds_min.y\
	__asm fcomi st, st(1)\
	__asm fcmovnb st(0), st(1)\
	__asm fstp __wiregl_globals.bounds_min.y\
	__asm fld __wiregl_globals.bounds_max.y\
	__asm fcomi st, st(1)\
	__asm fcmovb st(0), st(1)\
	__asm fstp __wiregl_globals.bounds_max.y\
	__asm fstp fy\
} \
	if (__wiregl_globals.bounds_min.z > 0.0f)  __wiregl_globals.bounds_min.z = 0.0f;\
	if (__wiregl_globals.bounds_max.z < 0.0f)  __wiregl_globals.bounds_max.z = 0.0f
#else
#define UPDATE_2D_BBOX() \
if (__wiregl_globals.bounds_min.x > fx)    __wiregl_globals.bounds_min.x = fx;\
if (__wiregl_globals.bounds_min.y > fy)    __wiregl_globals.bounds_min.y = fy;\
if (__wiregl_globals.bounds_min.z > 0.0f)  __wiregl_globals.bounds_min.z = 0.0f;\
if (__wiregl_globals.bounds_max.x < fx)    __wiregl_globals.bounds_max.x = fx;\
if (__wiregl_globals.bounds_max.y < fy)    __wiregl_globals.bounds_max.y = fy;\
if (__wiregl_globals.bounds_max.z < 0.0f)  __wiregl_globals.bounds_max.z = 0.0f
#endif

#ifdef WINDOWS
#define UPDATE_3D_BBOX() \
__asm {\
	__asm fld fx\
	__asm fld __wiregl_globals.bounds_min.x\
	__asm fcomi st, st(1)\
	__asm fcmovnb st(0), st(1)\
	__asm fstp __wiregl_globals.bounds_min.x\
	__asm fld __wiregl_globals.bounds_max.x\
	__asm fcomi st, st(1)\
	__asm fcmovb st(0), st(1)\
	__asm fstp __wiregl_globals.bounds_max.x\
	__asm fstp fx\
	\
	__asm fld fy\
	__asm fld __wiregl_globals.bounds_min.y\
	__asm fcomi st, st(1)\
	__asm fcmovnb st(0), st(1)\
	__asm fstp __wiregl_globals.bounds_min.y\
	__asm fld __wiregl_globals.bounds_max.y\
	__asm fcomi st, st(1)\
	__asm fcmovb st(0), st(1)\
	__asm fstp __wiregl_globals.bounds_max.y\
	__asm fstp fy\
	\
	__asm fld fz\
	__asm fld __wiregl_globals.bounds_min.z\
	__asm fcomi st, st(1)\
	__asm fcmovnb st(0), st(1)\
	__asm fstp __wiregl_globals.bounds_min.z\
	__asm fld __wiregl_globals.bounds_max.z\
	__asm fcomi st, st(1)\
	__asm fcmovb st(0), st(1)\
	__asm fstp __wiregl_globals.bounds_max.z\
	__asm fstp fz\
	\
}
#else
#define UPDATE_3D_BBOX() \
if (__wiregl_globals.bounds_min.x > fx)    __wiregl_globals.bounds_min.x = fx; \
if (__wiregl_globals.bounds_min.y > fy)    __wiregl_globals.bounds_min.y = fy; \
if (__wiregl_globals.bounds_min.z > fz)    __wiregl_globals.bounds_min.z = fz; \
if (__wiregl_globals.bounds_max.x < fx)    __wiregl_globals.bounds_max.x = fx; \
if (__wiregl_globals.bounds_max.y < fy)    __wiregl_globals.bounds_max.y = fy; \
if (__wiregl_globals.bounds_max.z < fz)    __wiregl_globals.bounds_max.z = fz
#endif

#ifdef SIMD
#define UPDATE_3D_BBOX_SIMD() \
__asm {\
	__asm movups xmm0, fx\
	__asm movaps xmm1, __wiregl_globals.bounds_min.x\
	__asm movaps xmm2, __wiregl_globals.bounds_max.x\
	__asm minps xmm1, xmm0\
	__asm maxps xmm2, xmm0\
	__asm movaps __wiregl_globals.bounds_min.x, xmm1\
	__asm movaps __wiregl_globals.bounds_max.x, xmm2\
}
#define UPDATE_3D_BBOX_SIMD_PACK() \
__asm {\
	__asm mov ecx, [data_ptr]\
	__asm movups xmm0, fx\
	__asm movaps xmm1, __wiregl_globals.bounds_min.x\
	__asm movaps xmm2, __wiregl_globals.bounds_max.x\
	__asm minps xmm1, xmm0\
	__asm maxps xmm2, xmm0\
	__asm movaps __wiregl_globals.bounds_min.x, xmm1\
	__asm movaps __wiregl_globals.bounds_max.x, xmm2\
	__asm movups [ecx], xmm0\
}
#define UPDATE_3DV_BBOX_SIMD() \
__asm {\
	__asm mov eax, [v]\
	__asm mov ecx, [data_ptr]\
	__asm movups xmm0, [eax]\
	__asm movaps xmm1, __wiregl_globals.bounds_min.x\
	__asm movaps xmm2, __wiregl_globals.bounds_max.x\
	__asm minps xmm1, xmm0\
	__asm maxps xmm2, xmm0\
	__asm movaps __wiregl_globals.bounds_min.x, xmm1\
	__asm movaps __wiregl_globals.bounds_max.x, xmm2\
	__asm movups [ecx], xmm0\
}
#else
#define UPDATE_3DV_BBOX_SIMD() { CREATE_3D_VFLOATS(); UPDATE_3D_BBOX();}
#define UPDATE_3D_BBOX_SIMD()  UPDATE_3D_BBOX()
#endif

#define CREATE_2D_FLOATS() \
	GLfloat fx = (GLfloat) x; \
	GLfloat fy = (GLfloat) y

#define CREATE_3D_FLOATS() \
	GLfloat fx = (GLfloat) x; \
	GLfloat fy = (GLfloat) y; \
	GLfloat fz = (GLfloat) z

#define CREATE_4D_FLOATS() \
	GLfloat fx = (GLfloat) x; \
	GLfloat fy = (GLfloat) y; \
	GLfloat fz = (GLfloat) z; \
	GLfloat fw = (GLfloat) w; \
	fx /= fw; fy /= fw; fz/= fw

#define CREATE_2D_VFLOATS() \
	GLfloat fx = (GLfloat) v[0]; \
	GLfloat fy = (GLfloat) v[1]

#define CREATE_3D_VFLOATS() \
	GLfloat fx = (GLfloat) v[0]; \
	GLfloat fy = (GLfloat) v[1]; \
	GLfloat fz = (GLfloat) v[2]

#define CREATE_4D_VFLOATS() \
	GLfloat fx = (GLfloat) v[0]; \
	GLfloat fy = (GLfloat) v[1]; \
	GLfloat fz = (GLfloat) v[2]; \
	GLfloat fw = (GLfloat) v[3]; \
	fx /= fw; fy /= fw; fz/= fw


void OPENGL_APIENTRY WIREGL_PACK_FUNCTION( VertexBB2d )( GLdouble x, GLdouble y );
void OPENGL_APIENTRY WIREGL_PACK_FUNCTION( VertexBB2dv )( const GLdouble *v );
void OPENGL_APIENTRY WIREGL_PACK_FUNCTION( VertexBB2f )( GLfloat x, GLfloat y );
void OPENGL_APIENTRY WIREGL_PACK_FUNCTION( VertexBB2fv )( const GLfloat *v );
void OPENGL_APIENTRY WIREGL_PACK_FUNCTION( VertexBB2i )( GLint x, GLint y );
void OPENGL_APIENTRY WIREGL_PACK_FUNCTION( VertexBB2iv )( const GLint *v );
void OPENGL_APIENTRY WIREGL_PACK_FUNCTION( VertexBB2s )( GLshort x, GLshort y );
void OPENGL_APIENTRY WIREGL_PACK_FUNCTION( VertexBB2sv )( const GLshort *v );
void OPENGL_APIENTRY WIREGL_PACK_FUNCTION( VertexBB3d )( GLdouble x, GLdouble y, GLdouble z );
void OPENGL_APIENTRY WIREGL_PACK_FUNCTION( VertexBB3dv )( const GLdouble *v );
void OPENGL_APIENTRY WIREGL_PACK_FUNCTION( VertexBB3f )( GLfloat x, GLfloat y, GLfloat z );
void OPENGL_APIENTRY WIREGL_PACK_FUNCTION( VertexBB3fv )( const GLfloat *v );
void OPENGL_APIENTRY WIREGL_PACK_FUNCTION( VertexBB3i )( GLint x, GLint y, GLint z );
void OPENGL_APIENTRY WIREGL_PACK_FUNCTION( VertexBB3iv )( const GLint *v );
void OPENGL_APIENTRY WIREGL_PACK_FUNCTION( VertexBB3s )( GLshort x, GLshort y, GLshort z );
void OPENGL_APIENTRY WIREGL_PACK_FUNCTION( VertexBB3sv )( const GLshort *v );
void OPENGL_APIENTRY WIREGL_PACK_FUNCTION( VertexBB4d )( GLdouble x, GLdouble y, GLdouble z, GLdouble w );
void OPENGL_APIENTRY WIREGL_PACK_FUNCTION( VertexBB4dv )( const GLdouble *v );
void OPENGL_APIENTRY WIREGL_PACK_FUNCTION( VertexBB4f )( GLfloat x, GLfloat y, GLfloat z, GLfloat w );
void OPENGL_APIENTRY WIREGL_PACK_FUNCTION( VertexBB4fv )( const GLfloat *v );
void OPENGL_APIENTRY WIREGL_PACK_FUNCTION( VertexBB4i )( GLint x, GLint y, GLint z, GLint w );
void OPENGL_APIENTRY WIREGL_PACK_FUNCTION( VertexBB4iv )( const GLint *v );
void OPENGL_APIENTRY WIREGL_PACK_FUNCTION( VertexBB4s )( GLshort x, GLshort y, GLshort z, GLshort w );
void OPENGL_APIENTRY WIREGL_PACK_FUNCTION( VertexBB4sv )( const GLshort *v );

void OPENGL_APIENTRY WIREGL_PACK_FUNCTION( VertexC2d )( GLdouble x, GLdouble y );
void OPENGL_APIENTRY WIREGL_PACK_FUNCTION( VertexC2dv )( const GLdouble *v );
void OPENGL_APIENTRY WIREGL_PACK_FUNCTION( VertexC2f )( GLfloat x, GLfloat y );
void OPENGL_APIENTRY WIREGL_PACK_FUNCTION( VertexC2fv )( const GLfloat *v );
void OPENGL_APIENTRY WIREGL_PACK_FUNCTION( VertexC2i )( GLint x, GLint y );
void OPENGL_APIENTRY WIREGL_PACK_FUNCTION( VertexC2iv )( const GLint *v );
void OPENGL_APIENTRY WIREGL_PACK_FUNCTION( VertexC2s )( GLshort x, GLshort y );
void OPENGL_APIENTRY WIREGL_PACK_FUNCTION( VertexC2sv )( const GLshort *v );
void OPENGL_APIENTRY WIREGL_PACK_FUNCTION( VertexC3d )( GLdouble x, GLdouble y, GLdouble z );
void OPENGL_APIENTRY WIREGL_PACK_FUNCTION( VertexC3dv )( const GLdouble *v );
void OPENGL_APIENTRY WIREGL_PACK_FUNCTION( VertexC3f )( GLfloat x, GLfloat y, GLfloat z );
void OPENGL_APIENTRY WIREGL_PACK_FUNCTION( VertexC3fv )( const GLfloat *v );
void OPENGL_APIENTRY WIREGL_PACK_FUNCTION( VertexC3i )( GLint x, GLint y, GLint z );
void OPENGL_APIENTRY WIREGL_PACK_FUNCTION( VertexC3iv )( const GLint *v );
void OPENGL_APIENTRY WIREGL_PACK_FUNCTION( VertexC3s )( GLshort x, GLshort y, GLshort z );
void OPENGL_APIENTRY WIREGL_PACK_FUNCTION( VertexC3sv )( const GLshort *v );
void OPENGL_APIENTRY WIREGL_PACK_FUNCTION( VertexC4d )( GLdouble x, GLdouble y, GLdouble z, GLdouble w );
void OPENGL_APIENTRY WIREGL_PACK_FUNCTION( VertexC4dv )( const GLdouble *v );
void OPENGL_APIENTRY WIREGL_PACK_FUNCTION( VertexC4f )( GLfloat x, GLfloat y, GLfloat z, GLfloat w );
void OPENGL_APIENTRY WIREGL_PACK_FUNCTION( VertexC4fv )( const GLfloat *v );
void OPENGL_APIENTRY WIREGL_PACK_FUNCTION( VertexC4i )( GLint x, GLint y, GLint z, GLint w );
void OPENGL_APIENTRY WIREGL_PACK_FUNCTION( VertexC4iv )( const GLint *v );
void OPENGL_APIENTRY WIREGL_PACK_FUNCTION( VertexC4s )( GLshort x, GLshort y, GLshort z, GLshort w );
void OPENGL_APIENTRY WIREGL_PACK_FUNCTION( VertexC4sv )( const GLshort *v );

#ifdef __cplusplus
}
#endif

#endif /* WIREGLGL_H */

