/*
** 3/06/2001
** http://graphics.stanford.edu/software/wiregl
**
** Copyright 2001
** The Board of Trustees of The Leland Stanford Junior University.
** All rights reserved.
**
** Except for commercial resale, lease, license or other commercial
** transactions, permission is hereby given to use, copy, and/or
** modify this software, provided that the above copyright notice and
** this permission notice appear in all copies of this software.  No
** part of this software or any derivatives thereof may be used in
** graphics systems for resale or for use in a commercial product.
**
** This software is provided "as is" and without warranty of any kind,
** express, implied or otherwise, including without limitation, any
** warranty of merchantability or fitness for a particular purpose.
*/

#include "glcontext.h"
#include "glerror.h"
#include "glhw.h"

// glRect bucket
void GLSTATE_DECL
__glstate_Rectd (GLdouble x1, GLdouble y1, GLdouble x2, GLdouble y2) {
	GLcontext *g = GetCurrentContext();
	GLbucketstate *bkt = &(g->bucket);
	GLfloat fx1 = (GLfloat) x1;
	GLfloat fy1 = (GLfloat) y1;
	GLfloat fx2 = (GLfloat) x2;
	GLfloat fy2 = (GLfloat) y2;

	if (g->current.beginend)
		if (__glerror(__LINE__, __FILE__, GL_INVALID_OPERATION,
			"Rect called in Begin/End"))
			return;

	if (!IsBucketingActive()) {
		__glbucket_flush();
		__glbucket_begin();
	}

	__glhw_Rectd (x1, y1, x2, y2);

	if (IsUpdateBoundingBox(bkt)) {
		if (bkt->bmin->x > fx1) bkt->bmin->x = fx1;
		if (bkt->bmin->y > fy1) bkt->bmin->y = fy1;
		if (bkt->bmax->x < fx1) bkt->bmax->x = fx1;
		if (bkt->bmax->y < fx1) bkt->bmax->y = fx1;

		if (bkt->bmin->x > fx2) bkt->bmin->x = fx2;
		if (bkt->bmin->y > fy2) bkt->bmin->y = fy2;
		if (bkt->bmax->x < fx2) bkt->bmax->x = fx2;
		if (bkt->bmax->y < fx2) bkt->bmax->y = fx2;

		if (bkt->bmin->z > 0.0f) bkt->bmin->z = 0.0f;
		if (bkt->bmax->z < 0.0f) bkt->bmax->z = 0.0f;
	}

	*bkt->count+=2;
}

void GLSTATE_DECL
__glstate_Rectdv (const GLdouble *v1, const GLdouble *v2) {
	GLcontext *g = GetCurrentContext();
	GLbucketstate *bkt = &(g->bucket);
	GLfloat fx1 = (GLfloat) v1[0];
	GLfloat fy1 = (GLfloat) v1[1];
	GLfloat fx2 = (GLfloat) v2[0];
	GLfloat fy2 = (GLfloat) v2[0];

	if (g->current.beginend)
		if (__glerror(__LINE__, __FILE__, GL_INVALID_OPERATION,
			"Rect called in Begin/End"))
			return;

	if (!IsBucketingActive()) {
		__glbucket_flush();
		__glbucket_begin();
	}

	__glhw_Rectdv (v1, v2);

	if (IsUpdateBoundingBox(bkt)) {
		if (bkt->bmin->x > fx1) bkt->bmin->x = fx1;
		if (bkt->bmin->y > fy1) bkt->bmin->y = fy1;
		if (bkt->bmax->x < fx1) bkt->bmax->x = fx1;
		if (bkt->bmax->y < fx1) bkt->bmax->y = fx1;

		if (bkt->bmin->x > fx2) bkt->bmin->x = fx2;
		if (bkt->bmin->y > fy2) bkt->bmin->y = fy2;
		if (bkt->bmax->x < fx2) bkt->bmax->x = fx2;
		if (bkt->bmax->y < fx2) bkt->bmax->y = fx2;

		if (bkt->bmin->z > 0.0f) bkt->bmin->z = 0.0f;
		if (bkt->bmax->z < 0.0f) bkt->bmax->z = 0.0f;
	}

	*bkt->count+=2;
}

void GLSTATE_DECL
__glstate_Rectf (GLfloat x1, GLfloat y1, GLfloat x2, GLfloat y2) {
	GLcontext *g = GetCurrentContext();
	GLbucketstate *bkt = &(g->bucket);

	if (g->current.beginend)
		if (__glerror(__LINE__, __FILE__, GL_INVALID_OPERATION,
			"Rect called in Begin/End"))
			return;

	if (!IsBucketingActive()) {
		__glbucket_flush();
		__glbucket_begin();
	}

	__glhw_Rectf (x1, y1, x2, y2);

	if (IsUpdateBoundingBox(bkt)) {
		if (bkt->bmin->x > x1) bkt->bmin->x = x1;
		if (bkt->bmin->y > y1) bkt->bmin->y = y1;
		if (bkt->bmax->x < x1) bkt->bmax->x = x1;
		if (bkt->bmax->y < x1) bkt->bmax->y = x1;

		if (bkt->bmin->x > x2) bkt->bmin->x = x2;
		if (bkt->bmin->y > y2) bkt->bmin->y = y2;
		if (bkt->bmax->x < x2) bkt->bmax->x = x2;
		if (bkt->bmax->y < x2) bkt->bmax->y = x2;

		if (bkt->bmin->z > 0.0f) bkt->bmin->z = 0.0f;
		if (bkt->bmax->z < 0.0f) bkt->bmax->z = 0.0f;
	}

	*bkt->count+=2;
}

void GLSTATE_DECL
__glstate_Rectfv (const GLfloat *v1, const GLfloat *v2) {
	GLcontext *g = GetCurrentContext();
	GLbucketstate *bkt = &(g->bucket);
	GLfloat fx1 = v1[0];
	GLfloat fy1 = v1[1];
	GLfloat fx2 = v2[0];
	GLfloat fy2 = v2[1];
	
	if (g->current.beginend)
		if (__glerror(__LINE__, __FILE__, GL_INVALID_OPERATION,
			"Rect called in Begin/End"))
			return;

	if (!IsBucketingActive()) {
		__glbucket_flush();
		__glbucket_begin();
	}

	__glhw_Rectfv (v1, v2);

	if (IsUpdateBoundingBox(bkt)) {
		if (bkt->bmin->x > fx1) bkt->bmin->x = fx1;
		if (bkt->bmin->y > fy1) bkt->bmin->y = fy1;
		if (bkt->bmax->x < fx1) bkt->bmax->x = fx1;
		if (bkt->bmax->y < fx1) bkt->bmax->y = fx1;

		if (bkt->bmin->x > fx2) bkt->bmin->x = fx2;
		if (bkt->bmin->y > fy2) bkt->bmin->y = fy2;
		if (bkt->bmax->x < fx2) bkt->bmax->x = fx2;
		if (bkt->bmax->y < fx2) bkt->bmax->y = fx2;

		if (bkt->bmin->z > 0.0f) bkt->bmin->z = 0.0f;
		if (bkt->bmax->z < 0.0f) bkt->bmax->z = 0.0f;
	}

	*bkt->count+=2;
}

void GLSTATE_DECL
__glstate_Recti (GLint x1, GLint y1, GLint x2, GLint y2) {
	GLcontext *g = GetCurrentContext();
	GLbucketstate *bkt = &(g->bucket);
	GLfloat fx1 = (GLfloat) x1;
	GLfloat fy1 = (GLfloat) y1;
	GLfloat fx2 = (GLfloat) x2;
	GLfloat fy2 = (GLfloat) y2;

	if (g->current.beginend)
		if (__glerror(__LINE__, __FILE__, GL_INVALID_OPERATION,
			"Rect called in Begin/End"))
			return;

	if (!IsBucketingActive()) {
		__glbucket_flush();
		__glbucket_begin();
	}

	__glhw_Recti (x1, y1, x2, y2);

	if (IsUpdateBoundingBox(bkt)) {
		if (bkt->bmin->x > fx1) bkt->bmin->x = fx1;
		if (bkt->bmin->y > fy1) bkt->bmin->y = fy1;
		if (bkt->bmax->x < fx1) bkt->bmax->x = fx1;
		if (bkt->bmax->y < fx1) bkt->bmax->y = fx1;

		if (bkt->bmin->x > fx2) bkt->bmin->x = fx2;
		if (bkt->bmin->y > fy2) bkt->bmin->y = fy2;
		if (bkt->bmax->x < fx2) bkt->bmax->x = fx2;
		if (bkt->bmax->y < fx2) bkt->bmax->y = fx2;

		if (bkt->bmin->z > 0.0f) bkt->bmin->z = 0.0f;
		if (bkt->bmax->z < 0.0f) bkt->bmax->z = 0.0f;
	}

	*bkt->count+=2;
}

void GLSTATE_DECL
__glstate_Rectiv (const GLint *v1, const GLint *v2) {
	GLcontext *g = GetCurrentContext();
	GLbucketstate *bkt = &(g->bucket);
	GLfloat fx1 = (GLfloat) v1[0];
	GLfloat fy1 = (GLfloat) v1[1];
	GLfloat fx2 = (GLfloat) v2[0];
	GLfloat fy2 = (GLfloat) v2[1];
	if (g->current.beginend)
		if (__glerror(__LINE__, __FILE__, GL_INVALID_OPERATION,
			"Rect called in Begin/End"))
			return;

	if (!IsBucketingActive()) {
		__glbucket_flush();
		__glbucket_begin();
	}

	__glhw_Rectiv (v1, v2);

	if (IsUpdateBoundingBox(bkt)) {
		if (bkt->bmin->x > fx1) bkt->bmin->x = fx1;
		if (bkt->bmin->y > fy1) bkt->bmin->y = fy1;
		if (bkt->bmax->x < fx1) bkt->bmax->x = fx1;
		if (bkt->bmax->y < fx1) bkt->bmax->y = fx1;

		if (bkt->bmin->x > fx2) bkt->bmin->x = fx2;
		if (bkt->bmin->y > fy2) bkt->bmin->y = fy2;
		if (bkt->bmax->x < fx2) bkt->bmax->x = fx2;
		if (bkt->bmax->y < fx2) bkt->bmax->y = fx2;

		if (bkt->bmin->z > 0.0f) bkt->bmin->z = 0.0f;
		if (bkt->bmax->z < 0.0f) bkt->bmax->z = 0.0f;
	}

	*bkt->count+=2;
}

void GLSTATE_DECL
__glstate_Rects (GLshort x1, GLshort y1, GLshort x2, GLshort y2) {
	GLcontext *g = GetCurrentContext();
	GLbucketstate *bkt = &(g->bucket);
	GLfloat fx1 = (GLfloat) x1;
	GLfloat fy1 = (GLfloat) y1;
	GLfloat fx2 = (GLfloat) x2;
	GLfloat fy2 = (GLfloat) y2;

	if (g->current.beginend)
		if (__glerror(__LINE__, __FILE__, GL_INVALID_OPERATION,
			"Rect called in Begin/End"))
			return;

	if (!IsBucketingActive()) {
		__glbucket_flush();
		__glbucket_begin();
	}

	__glhw_Rects (x1, y1, x2, y2);

	if (IsUpdateBoundingBox(bkt)) {
		if (bkt->bmin->x > fx1) bkt->bmin->x = fx1;
		if (bkt->bmin->y > fy1) bkt->bmin->y = fy1;
		if (bkt->bmax->x < fx1) bkt->bmax->x = fx1;
		if (bkt->bmax->y < fx1) bkt->bmax->y = fx1;

		if (bkt->bmin->x > fx2) bkt->bmin->x = fx2;
		if (bkt->bmin->y > fy2) bkt->bmin->y = fy2;
		if (bkt->bmax->x < fx2) bkt->bmax->x = fx2;
		if (bkt->bmax->y < fx2) bkt->bmax->y = fx2;

		if (bkt->bmin->z > 0.0f) bkt->bmin->z = 0.0f;
		if (bkt->bmax->z < 0.0f) bkt->bmax->z = 0.0f;
	}

	*bkt->count+=2;
}


void GLSTATE_DECL
__glstate_Rectsv (const GLshort *v1, const GLshort *v2) {
	GLcontext *g = GetCurrentContext();
	GLbucketstate *bkt = &(g->bucket);
	GLfloat fx1 = (GLfloat) v1[0];
	GLfloat fy1 = (GLfloat) v1[1];
	GLfloat fx2 = (GLfloat) v2[0];
	GLfloat fy2 = (GLfloat) v2[1];
	
	if (g->current.beginend)
		if (__glerror(__LINE__, __FILE__, GL_INVALID_OPERATION,
			"Rect called in Begin/End"))
			return;

	if (!IsBucketingActive()) {
		__glbucket_flush();
		__glbucket_begin();
	}

	__glhw_Rectsv (v1, v2);

	if (IsUpdateBoundingBox(bkt)) {
		if (bkt->bmin->x > fx1) bkt->bmin->x = fx1;
		if (bkt->bmin->y > fy1) bkt->bmin->y = fy1;
		if (bkt->bmax->x < fx1) bkt->bmax->x = fx1;
		if (bkt->bmax->y < fx1) bkt->bmax->y = fx1;

		if (bkt->bmin->x > fx2) bkt->bmin->x = fx2;
		if (bkt->bmin->y > fy2) bkt->bmin->y = fy2;
		if (bkt->bmax->x < fx2) bkt->bmax->x = fx2;
		if (bkt->bmax->y < fx2) bkt->bmax->y = fx2;

		if (bkt->bmin->z > 0.0f) bkt->bmin->z = 0.0f;
		if (bkt->bmax->z < 0.0f) bkt->bmax->z = 0.0f;
	}

	*bkt->count+=2;
}
