/*
** 3/06/2001
** http://graphics.stanford.edu/software/wiregl
**
** Copyright 2001
** The Board of Trustees of The Leland Stanford Junior University.
** All rights reserved.
**
** Except for commercial resale, lease, license or other commercial
** transactions, permission is hereby given to use, copy, and/or
** modify this software, provided that the above copyright notice and
** this permission notice appear in all copies of this software.  No
** part of this software or any derivatives thereof may be used in
** graphics systems for resale or for use in a commercial product.
**
** This software is provided "as is" and without warranty of any kind,
** express, implied or otherwise, including without limitation, any
** warranty of merchantability or fitness for a particular purpose.
*/

#ifndef GLHW_H
#define GLHW_H

#include "gltypes.h"

#ifdef WINDOWS 
#define GLAPI __stdcall
#else
#ifdef GLAPI
#undef GLAPI
#endif
#define GLAPI
#endif

#ifdef GLHWAPI_DEFINE
#define GLHWAPI
#else
#define GLHWAPI extern
#endif


#ifdef __cplusplus
extern "C" {
#endif

typedef void (GLAPI *glAble) (GLenum);
typedef void (*GLfunc) ();

extern GLapi hwerror[];

void __glhw_error(void);
void __glhw_RegisterApi(GLconfig *c);
void __glhw_LoadPackApi(void);
void __glhw_LoadStateApi(void);
void __glhw_LoadSystemApi (GLapi *api);
void __glhw_LoadSwitchApi (GLapi *api);
void __glhw_LoadBeginEndApi (void);
void __glhw_UnloadBeginEndApi (void);
void __glhw_LoadVertexPackApi(void);
void __glhw_LoadVertexBBPackApi(void);
void __glhw_LoadVertexCPackApi(void);
void __glhw_LockArrays(void);
void __glhw_UnlockArrays(void);

GLHWAPI void (GLAPI **__glbase_Vertex4fv) (const GLfloat *v);
GLHWAPI void (GLAPI **__glbase_Color4fv) (const GLfloat *c);
GLHWAPI void (GLAPI **__glbase_Normal3fv) (const GLfloat *n);
GLHWAPI void (GLAPI **__glbase_EdgeFlag) (GLboolean z);
GLHWAPI void (GLAPI **__glbase_TexCoord4fv) (const GLfloat *t);

GLHWAPI void (GLAPI *__glhw_Accum) (GLenum op, GLfloat value);
GLHWAPI void (GLAPI *__glhw_AlphaFunc) (GLenum func, GLclampf ref);
GLHWAPI GLboolean (GLAPI *__glhw_AreTexturesResident) (GLsizei n, const GLuint *textures, GLboolean *residences);
GLHWAPI void (GLAPI *__glhw_ArrayElement) (GLint i);
GLHWAPI void (GLAPI *__glhw_Begin) (GLenum mode);
GLHWAPI void (GLAPI *__glhw_BindTexture) (GLenum target, GLuint texture);
GLHWAPI void (GLAPI *__glhw_Bitmap) (GLsizei width, GLsizei height, GLfloat xorig, GLfloat yorig, GLfloat xmove, GLfloat ymove, const GLubyte *bitmap);
GLHWAPI void (GLAPI *__glhw_BlendFunc) (GLenum sfactor, GLenum dfactor);
GLHWAPI void (GLAPI *__glhw_CallList) (GLuint list);
GLHWAPI void (GLAPI *__glhw_CallLists) (GLsizei n, GLenum type, const GLvoid *lists);
GLHWAPI void (GLAPI *__glhw_Clear) (GLbitfield mask);
GLHWAPI void (GLAPI *__glhw_ClearAccum) (GLfloat red, GLfloat green, GLfloat blue, GLfloat alpha);
GLHWAPI void (GLAPI *__glhw_ClearColor) (GLclampf red, GLclampf green, GLclampf blue, GLclampf alpha);
GLHWAPI void (GLAPI *__glhw_ClearDepth) (GLclampd depth);
GLHWAPI void (GLAPI *__glhw_ClearIndex) (GLfloat c);
GLHWAPI void (GLAPI *__glhw_ClearStencil) (GLint s);
GLHWAPI void (GLAPI *__glhw_ClipPlane) (GLenum plane, const GLdouble *equation);
GLHWAPI void (GLAPI *__glhw_Color3b) (GLbyte red, GLbyte green, GLbyte blue);
GLHWAPI void (GLAPI *__glhw_Color3bv) (const GLbyte *v);
GLHWAPI void (GLAPI *__glhw_Color3d) (GLdouble red, GLdouble green, GLdouble blue);
GLHWAPI void (GLAPI *__glhw_Color3dv) (const GLdouble *v);
GLHWAPI void (GLAPI *__glhw_Color3f) (GLfloat red, GLfloat green, GLfloat blue);
GLHWAPI void (GLAPI *__glhw_Color3fv) (const GLfloat *v);
GLHWAPI void (GLAPI *__glhw_Color3i) (GLint red, GLint green, GLint blue);
GLHWAPI void (GLAPI *__glhw_Color3iv) (const GLint *v);
GLHWAPI void (GLAPI *__glhw_Color3s) (GLshort red, GLshort green, GLshort blue);
GLHWAPI void (GLAPI *__glhw_Color3sv) (const GLshort *v);
GLHWAPI void (GLAPI *__glhw_Color3ub) (GLubyte red, GLubyte green, GLubyte blue);
GLHWAPI void (GLAPI *__glhw_Color3ubv) (const GLubyte *v);
GLHWAPI void (GLAPI *__glhw_Color3ui) (GLuint red, GLuint green, GLuint blue);
GLHWAPI void (GLAPI *__glhw_Color3uiv) (const GLuint *v);
GLHWAPI void (GLAPI *__glhw_Color3us) (GLushort red, GLushort green, GLushort blue);
GLHWAPI void (GLAPI *__glhw_Color3usv) (const GLushort *v);
GLHWAPI void (GLAPI *__glhw_Color4b) (GLbyte red, GLbyte green, GLbyte blue, GLbyte alpha);
GLHWAPI void (GLAPI *__glhw_Color4bv) (const GLbyte *v);
GLHWAPI void (GLAPI *__glhw_Color4d) (GLdouble red, GLdouble green, GLdouble blue, GLdouble alpha);
GLHWAPI void (GLAPI *__glhw_Color4dv) (const GLdouble *v);
GLHWAPI void (GLAPI *__glhw_Color4f) (GLfloat red, GLfloat green, GLfloat blue, GLfloat alpha);
GLHWAPI void (GLAPI *__glhw_Color4fv) (const GLfloat *v);
GLHWAPI void (GLAPI *__glhw_Color4i) (GLint red, GLint green, GLint blue, GLint alpha);
GLHWAPI void (GLAPI *__glhw_Color4iv) (const GLint *v);
GLHWAPI void (GLAPI *__glhw_Color4s) (GLshort red, GLshort green, GLshort blue, GLshort alpha);
GLHWAPI void (GLAPI *__glhw_Color4sv) (const GLshort *v);
GLHWAPI void (GLAPI *__glhw_Color4ub) (GLubyte red, GLubyte green, GLubyte blue, GLubyte alpha);
GLHWAPI void (GLAPI *__glhw_Color4ubv) (const GLubyte *v);
GLHWAPI void (GLAPI *__glhw_Color4ui) (GLuint red, GLuint green, GLuint blue, GLuint alpha);
GLHWAPI void (GLAPI *__glhw_Color4uiv) (const GLuint *v);
GLHWAPI void (GLAPI *__glhw_Color4us) (GLushort red, GLushort green, GLushort blue, GLushort alpha);
GLHWAPI void (GLAPI *__glhw_Color4usv) (const GLushort *v);
GLHWAPI void (GLAPI *__glhw_ColorMask) (GLboolean red, GLboolean green, GLboolean blue, GLboolean alpha);
GLHWAPI void (GLAPI *__glhw_ColorMaterial) (GLenum face, GLenum mode);
GLHWAPI void (GLAPI *__glhw_ColorPointer) (GLint size, GLenum type, GLsizei stride, const GLvoid *pointer);
GLHWAPI void (GLAPI *__glhw_CopyPixels) (GLint x, GLint y, GLsizei width, GLsizei height, GLenum type);
GLHWAPI void (GLAPI *__glhw_CopyTexImage1D) (GLenum target, GLint level, GLenum internalFormat, GLint x, GLint y, GLsizei width, GLint border);
GLHWAPI void (GLAPI *__glhw_CopyTexImage2D) (GLenum target, GLint level, GLenum internalFormat, GLint x, GLint y, GLsizei width, GLsizei height, GLint border);
GLHWAPI void (GLAPI *__glhw_CopyTexSubImage1D) (GLenum target, GLint level, GLint xoffset, GLint x, GLint y, GLsizei width);
GLHWAPI void (GLAPI *__glhw_CopyTexSubImage2D) (GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint x, GLint y, GLsizei width, GLsizei height);
GLHWAPI void (GLAPI *__glhw_CullFace) (GLenum mode);
GLHWAPI void (GLAPI *__glhw_DeleteLists) (GLuint list, GLsizei range);
GLHWAPI void (GLAPI *__glhw_DeleteTextures) (GLsizei n, const GLuint *textures);
GLHWAPI void (GLAPI *__glhw_DepthFunc) (GLenum func);
GLHWAPI void (GLAPI *__glhw_DepthMask) (GLboolean flag);
GLHWAPI void (GLAPI *__glhw_DepthRange) (GLclampd zNear, GLclampd zFar);
GLHWAPI void (GLAPI *__glhw_Disable) (GLenum cap);
GLHWAPI void (GLAPI *__glhw_DisableClientState) (GLenum array);
GLHWAPI void (GLAPI *__glhw_DrawArrays) (GLenum mode, GLint first, GLsizei count);
GLHWAPI void (GLAPI *__glhw_DrawBuffer) (GLenum mode);
GLHWAPI void (GLAPI *__glhw_DrawElements) (GLenum mode, GLsizei count, GLenum type, const GLvoid *indices);
GLHWAPI void (GLAPI *__glhw_DrawPixels) (GLsizei width, GLsizei height, GLenum format, GLenum type, const GLvoid *pixels);
GLHWAPI void (GLAPI *__glhw_EdgeFlag) (GLboolean flag);
GLHWAPI void (GLAPI *__glhw_EdgeFlagPointer) (GLsizei stride, const GLvoid *pointer);
GLHWAPI void (GLAPI *__glhw_EdgeFlagv) (const GLboolean *flag);
GLHWAPI void (GLAPI *__glhw_Enable) (GLenum cap);
GLHWAPI void (GLAPI *__glhw_EnableClientState) (GLenum array);
GLHWAPI void (GLAPI *__glhw_End) (void);
GLHWAPI void (GLAPI *__glhw_EndList) (void);
GLHWAPI void (GLAPI *__glhw_EvalCoord1d) (GLdouble u);
GLHWAPI void (GLAPI *__glhw_EvalCoord1dv) (const GLdouble *u);
GLHWAPI void (GLAPI *__glhw_EvalCoord1f) (GLfloat u);
GLHWAPI void (GLAPI *__glhw_EvalCoord1fv) (const GLfloat *u);
GLHWAPI void (GLAPI *__glhw_EvalCoord2d) (GLdouble u, GLdouble v);
GLHWAPI void (GLAPI *__glhw_EvalCoord2dv) (const GLdouble *u);
GLHWAPI void (GLAPI *__glhw_EvalCoord2f) (GLfloat u, GLfloat v);
GLHWAPI void (GLAPI *__glhw_EvalCoord2fv) (const GLfloat *u);
GLHWAPI void (GLAPI *__glhw_EvalMesh1) (GLenum mode, GLint i1, GLint i2);
GLHWAPI void (GLAPI *__glhw_EvalMesh2) (GLenum mode, GLint i1, GLint i2, GLint j1, GLint j2);
GLHWAPI void (GLAPI *__glhw_EvalPoint1) (GLint i);
GLHWAPI void (GLAPI *__glhw_EvalPoint2) (GLint i, GLint j);
GLHWAPI void (GLAPI *__glhw_FeedbackBuffer) (GLsizei size, GLenum type, GLfloat *buffer);
GLHWAPI void (GLAPI *__glhw_Finish) (void);
GLHWAPI void (GLAPI *__glhw_Flush) (void);
GLHWAPI void (GLAPI *__glhw_Fogf) (GLenum pname, GLfloat param);
GLHWAPI void (GLAPI *__glhw_Fogfv) (GLenum pname, const GLfloat *params);
GLHWAPI void (GLAPI *__glhw_Fogi) (GLenum pname, GLint param);
GLHWAPI void (GLAPI *__glhw_Fogiv) (GLenum pname, const GLint *params);
GLHWAPI void (GLAPI *__glhw_FrontFace) (GLenum mode);
GLHWAPI void (GLAPI *__glhw_Frustum) (GLdouble left, GLdouble right, GLdouble bottom, GLdouble top, GLdouble zNear, GLdouble zFar);
GLHWAPI GLuint (GLAPI *__glhw_GenLists) (GLsizei range);
GLHWAPI void (GLAPI *__glhw_GenTextures) (GLsizei n, GLuint *textures);
GLHWAPI void (GLAPI *__glhw_GetBooleanv) (GLenum pname, GLboolean *params);
GLHWAPI void (GLAPI *__glhw_GetClipPlane) (GLenum plane, GLdouble *equation);
GLHWAPI void (GLAPI *__glhw_GetDoublev) (GLenum pname, GLdouble *params);
GLHWAPI GLenum (GLAPI *__glhw_GetError) (void);
GLHWAPI void (GLAPI *__glhw_GetFloatv) (GLenum pname, GLfloat *params);
GLHWAPI void (GLAPI *__glhw_GetIntegerv) (GLenum pname, GLint *params);
GLHWAPI void (GLAPI *__glhw_GetLightfv) (GLenum light, GLenum pname, GLfloat *params);
GLHWAPI void (GLAPI *__glhw_GetLightiv) (GLenum light, GLenum pname, GLint *params);
GLHWAPI void (GLAPI *__glhw_GetMapdv) (GLenum target, GLenum query, GLdouble *v);
GLHWAPI void (GLAPI *__glhw_GetMapfv) (GLenum target, GLenum query, GLfloat *v);
GLHWAPI void (GLAPI *__glhw_GetMapiv) (GLenum target, GLenum query, GLint *v);
GLHWAPI void (GLAPI *__glhw_GetMaterialfv) (GLenum face, GLenum pname, GLfloat *params);
GLHWAPI void (GLAPI *__glhw_GetMaterialiv) (GLenum face, GLenum pname, GLint *params);
GLHWAPI void (GLAPI *__glhw_GetPixelMapfv) (GLenum map, GLfloat *values);
GLHWAPI void (GLAPI *__glhw_GetPixelMapuiv) (GLenum map, GLuint *values);
GLHWAPI void (GLAPI *__glhw_GetPixelMapusv) (GLenum map, GLushort *values);
GLHWAPI void (GLAPI *__glhw_GetPointerv) (GLenum pname, GLvoid* *params);
GLHWAPI void (GLAPI *__glhw_GetPolygonStipple) (GLubyte *mask);
GLHWAPI const GLubyte * (GLAPI *__glhw_GetString) (GLenum name);
GLHWAPI void (GLAPI *__glhw_GetTexEnvfv) (GLenum target, GLenum pname, GLfloat *params);
GLHWAPI void (GLAPI *__glhw_GetTexEnviv) (GLenum target, GLenum pname, GLint *params);
GLHWAPI void (GLAPI *__glhw_GetTexGendv) (GLenum coord, GLenum pname, GLdouble *params);
GLHWAPI void (GLAPI *__glhw_GetTexGenfv) (GLenum coord, GLenum pname, GLfloat *params);
GLHWAPI void (GLAPI *__glhw_GetTexGeniv) (GLenum coord, GLenum pname, GLint *params);
GLHWAPI void (GLAPI *__glhw_GetTexImage) (GLenum target, GLint level, GLenum format, GLenum type, GLvoid *pixels);
GLHWAPI void (GLAPI *__glhw_GetTexLevelParameterfv) (GLenum target, GLint level, GLenum pname, GLfloat *params);
GLHWAPI void (GLAPI *__glhw_GetTexLevelParameteriv) (GLenum target, GLint level, GLenum pname, GLint *params);
GLHWAPI void (GLAPI *__glhw_GetTexParameterfv) (GLenum target, GLenum pname, GLfloat *params);
GLHWAPI void (GLAPI *__glhw_GetTexParameteriv) (GLenum target, GLenum pname, GLint *params);
GLHWAPI void (GLAPI *__glhw_Hint) (GLenum target, GLenum mode);
GLHWAPI void (GLAPI *__glhw_IndexMask) (GLuint mask);
GLHWAPI void (GLAPI *__glhw_IndexPointer) (GLenum type, GLsizei stride, const GLvoid *pointer);
GLHWAPI void (GLAPI *__glhw_Indexd) (GLdouble c);
GLHWAPI void (GLAPI *__glhw_Indexdv) (const GLdouble *c);
GLHWAPI void (GLAPI *__glhw_Indexf) (GLfloat c);
GLHWAPI void (GLAPI *__glhw_Indexfv) (const GLfloat *c);
GLHWAPI void (GLAPI *__glhw_Indexi) (GLint c);
GLHWAPI void (GLAPI *__glhw_Indexiv) (const GLint *c);
GLHWAPI void (GLAPI *__glhw_Indexs) (GLshort c);
GLHWAPI void (GLAPI *__glhw_Indexsv) (const GLshort *c);
GLHWAPI void (GLAPI *__glhw_Indexub) (GLubyte c);
GLHWAPI void (GLAPI *__glhw_Indexubv) (const GLubyte *c);
GLHWAPI void (GLAPI *__glhw_InitNames) (void);
GLHWAPI void (GLAPI *__glhw_InterleavedArrays) (GLenum format, GLsizei stride, const GLvoid *pointer);
GLHWAPI GLboolean (GLAPI *__glhw_IsEnabled) (GLenum cap);
GLHWAPI GLboolean (GLAPI *__glhw_IsList) (GLuint list);
GLHWAPI GLboolean (GLAPI *__glhw_IsTexture) (GLuint texture);
GLHWAPI void (GLAPI *__glhw_LightModelf) (GLenum pname, GLfloat param);
GLHWAPI void (GLAPI *__glhw_LightModelfv) (GLenum pname, const GLfloat *params);
GLHWAPI void (GLAPI *__glhw_LightModeli) (GLenum pname, GLint param);
GLHWAPI void (GLAPI *__glhw_LightModeliv) (GLenum pname, const GLint *params);
GLHWAPI void (GLAPI *__glhw_Lightf) (GLenum light, GLenum pname, GLfloat param);
GLHWAPI void (GLAPI *__glhw_Lightfv) (GLenum light, GLenum pname, const GLfloat *params);
GLHWAPI void (GLAPI *__glhw_Lighti) (GLenum light, GLenum pname, GLint param);
GLHWAPI void (GLAPI *__glhw_Lightiv) (GLenum light, GLenum pname, const GLint *params);
GLHWAPI void (GLAPI *__glhw_LineStipple) (GLint factor, GLushort pattern);
GLHWAPI void (GLAPI *__glhw_LineWidth) (GLfloat width);
GLHWAPI void (GLAPI *__glhw_ListBase) (GLuint base);
GLHWAPI void (GLAPI *__glhw_LoadIdentity) (void);
GLHWAPI void (GLAPI *__glhw_LoadMatrixd) (const GLdouble *m);
GLHWAPI void (GLAPI *__glhw_LoadMatrixf) (const GLfloat *m);
GLHWAPI void (GLAPI *__glhw_LoadName) (GLuint name);
GLHWAPI void (GLAPI *__glhw_LogicOp) (GLenum opcode);
GLHWAPI void (GLAPI *__glhw_Map1d) (GLenum target, GLdouble u1, GLdouble u2, GLint stride, GLint order, const GLdouble *points);
GLHWAPI void (GLAPI *__glhw_Map1f) (GLenum target, GLfloat u1, GLfloat u2, GLint stride, GLint order, const GLfloat *points);
GLHWAPI void (GLAPI *__glhw_Map2d) (GLenum target, GLdouble u1, GLdouble u2, GLint ustride, GLint uorder, GLdouble v1, GLdouble v2, GLint vstride, GLint vorder, const GLdouble *points);
GLHWAPI void (GLAPI *__glhw_Map2f) (GLenum target, GLfloat u1, GLfloat u2, GLint ustride, GLint uorder, GLfloat v1, GLfloat v2, GLint vstride, GLint vorder, const GLfloat *points);
GLHWAPI void (GLAPI *__glhw_MapGrid1d) (GLint un, GLdouble u1, GLdouble u2);
GLHWAPI void (GLAPI *__glhw_MapGrid1f) (GLint un, GLfloat u1, GLfloat u2);
GLHWAPI void (GLAPI *__glhw_MapGrid2d) (GLint un, GLdouble u1, GLdouble u2, GLint vn, GLdouble v1, GLdouble v2);
GLHWAPI void (GLAPI *__glhw_MapGrid2f) (GLint un, GLfloat u1, GLfloat u2, GLint vn, GLfloat v1, GLfloat v2);
GLHWAPI void (GLAPI *__glhw_Materialf) (GLenum face, GLenum pname, GLfloat param);
GLHWAPI void (GLAPI *__glhw_Materialfv) (GLenum face, GLenum pname, const GLfloat *params);
GLHWAPI void (GLAPI *__glhw_Materiali) (GLenum face, GLenum pname, GLint param);
GLHWAPI void (GLAPI *__glhw_Materialiv) (GLenum face, GLenum pname, const GLint *params);
GLHWAPI void (GLAPI *__glhw_MatrixMode) (GLenum mode);
GLHWAPI void (GLAPI *__glhw_MultMatrixd) (const GLdouble *m);
GLHWAPI void (GLAPI *__glhw_MultMatrixf) (const GLfloat *m);
GLHWAPI void (GLAPI *__glhw_NewList) (GLuint list, GLenum mode);
GLHWAPI void (GLAPI *__glhw_Normal3b) (GLbyte nx, GLbyte ny, GLbyte nz);
GLHWAPI void (GLAPI *__glhw_Normal3bv) (const GLbyte *v);
GLHWAPI void (GLAPI *__glhw_Normal3d) (GLdouble nx, GLdouble ny, GLdouble nz);
GLHWAPI void (GLAPI *__glhw_Normal3dv) (const GLdouble *v);
GLHWAPI void (GLAPI *__glhw_Normal3f) (GLfloat nx, GLfloat ny, GLfloat nz);
GLHWAPI void (GLAPI *__glhw_Normal3fv) (const GLfloat *v);
GLHWAPI void (GLAPI *__glhw_Normal3i) (GLint nx, GLint ny, GLint nz);
GLHWAPI void (GLAPI *__glhw_Normal3iv) (const GLint *v);
GLHWAPI void (GLAPI *__glhw_Normal3s) (GLshort nx, GLshort ny, GLshort nz);
GLHWAPI void (GLAPI *__glhw_Normal3sv) (const GLshort *v);
GLHWAPI void (GLAPI *__glhw_NormalPointer) (GLenum type, GLsizei stride, const GLvoid *pointer);
GLHWAPI void (GLAPI *__glhw_Ortho) (GLdouble left, GLdouble right, GLdouble bottom, GLdouble top, GLdouble zNear, GLdouble zFar);
GLHWAPI void (GLAPI *__glhw_PassThrough) (GLfloat token);
GLHWAPI void (GLAPI *__glhw_PixelMapfv) (GLenum map, GLsizei mapsize, const GLfloat *values);
GLHWAPI void (GLAPI *__glhw_PixelMapiv) (GLenum map, GLsizei mapsize, const GLint *values);
GLHWAPI void (GLAPI *__glhw_PixelMapuiv) (GLenum map, GLsizei mapsize, const GLuint *values);
GLHWAPI void (GLAPI *__glhw_PixelMapusv) (GLenum map, GLsizei mapsize, const GLushort *values);
GLHWAPI void (GLAPI *__glhw_PixelStoref) (GLenum pname, GLfloat param);
GLHWAPI void (GLAPI *__glhw_PixelStorei) (GLenum pname, GLint param);
GLHWAPI void (GLAPI *__glhw_PixelTransferf) (GLenum pname, GLfloat param);
GLHWAPI void (GLAPI *__glhw_PixelTransferi) (GLenum pname, GLint param);
GLHWAPI void (GLAPI *__glhw_PixelZoom) (GLfloat xfactor, GLfloat yfactor);
GLHWAPI void (GLAPI *__glhw_PointSize) (GLfloat size);
GLHWAPI void (GLAPI *__glhw_PolygonMode) (GLenum face, GLenum mode);
GLHWAPI void (GLAPI *__glhw_PolygonOffset) (GLfloat factor, GLfloat units);
GLHWAPI void (GLAPI *__glhw_PolygonStipple) (const GLubyte *mask);
GLHWAPI void (GLAPI *__glhw_PopAttrib) (void);
GLHWAPI void (GLAPI *__glhw_PopClientAttrib) (void);
GLHWAPI void (GLAPI *__glhw_PopMatrix) (void);
GLHWAPI void (GLAPI *__glhw_PopName) (void);
GLHWAPI void (GLAPI *__glhw_PrioritizeTextures) (GLsizei n, const GLuint *textures, const GLclampf *priorities);
GLHWAPI void (GLAPI *__glhw_PushAttrib) (GLbitfield mask);
GLHWAPI void (GLAPI *__glhw_PushClientAttrib) (GLbitfield mask);
GLHWAPI void (GLAPI *__glhw_PushMatrix) (void);
GLHWAPI void (GLAPI *__glhw_PushName) (GLuint name);
GLHWAPI void (GLAPI *__glhw_RasterPos2d) (GLdouble x, GLdouble y);
GLHWAPI void (GLAPI *__glhw_RasterPos2dv) (const GLdouble *v);
GLHWAPI void (GLAPI *__glhw_RasterPos2f) (GLfloat x, GLfloat y);
GLHWAPI void (GLAPI *__glhw_RasterPos2fv) (const GLfloat *v);
GLHWAPI void (GLAPI *__glhw_RasterPos2i) (GLint x, GLint y);
GLHWAPI void (GLAPI *__glhw_RasterPos2iv) (const GLint *v);
GLHWAPI void (GLAPI *__glhw_RasterPos2s) (GLshort x, GLshort y);
GLHWAPI void (GLAPI *__glhw_RasterPos2sv) (const GLshort *v);
GLHWAPI void (GLAPI *__glhw_RasterPos3d) (GLdouble x, GLdouble y, GLdouble z);
GLHWAPI void (GLAPI *__glhw_RasterPos3dv) (const GLdouble *v);
GLHWAPI void (GLAPI *__glhw_RasterPos3f) (GLfloat x, GLfloat y, GLfloat z);
GLHWAPI void (GLAPI *__glhw_RasterPos3fv) (const GLfloat *v);
GLHWAPI void (GLAPI *__glhw_RasterPos3i) (GLint x, GLint y, GLint z);
GLHWAPI void (GLAPI *__glhw_RasterPos3iv) (const GLint *v);
GLHWAPI void (GLAPI *__glhw_RasterPos3s) (GLshort x, GLshort y, GLshort z);
GLHWAPI void (GLAPI *__glhw_RasterPos3sv) (const GLshort *v);
GLHWAPI void (GLAPI *__glhw_RasterPos4d) (GLdouble x, GLdouble y, GLdouble z, GLdouble w);
GLHWAPI void (GLAPI *__glhw_RasterPos4dv) (const GLdouble *v);
GLHWAPI void (GLAPI *__glhw_RasterPos4f) (GLfloat x, GLfloat y, GLfloat z, GLfloat w);
GLHWAPI void (GLAPI *__glhw_RasterPos4fv) (const GLfloat *v);
GLHWAPI void (GLAPI *__glhw_RasterPos4i) (GLint x, GLint y, GLint z, GLint w);
GLHWAPI void (GLAPI *__glhw_RasterPos4iv) (const GLint *v);
GLHWAPI void (GLAPI *__glhw_RasterPos4s) (GLshort x, GLshort y, GLshort z, GLshort w);
GLHWAPI void (GLAPI *__glhw_RasterPos4sv) (const GLshort *v);
GLHWAPI void (GLAPI *__glhw_ReadBuffer) (GLenum mode);
GLHWAPI void (GLAPI *__glhw_ReadPixels) (GLint x, GLint y, GLsizei width, GLsizei height, GLenum format, GLenum type, GLvoid *pixels);
GLHWAPI void (GLAPI *__glhw_Rectd) (GLdouble x1, GLdouble y1, GLdouble x2, GLdouble y2);
GLHWAPI void (GLAPI *__glhw_Rectdv) (const GLdouble *v1, const GLdouble *v2);
GLHWAPI void (GLAPI *__glhw_Rectf) (GLfloat x1, GLfloat y1, GLfloat x2, GLfloat y2);
GLHWAPI void (GLAPI *__glhw_Rectfv) (const GLfloat *v1, const GLfloat *v2);
GLHWAPI void (GLAPI *__glhw_Recti) (GLint x1, GLint y1, GLint x2, GLint y2);
GLHWAPI void (GLAPI *__glhw_Rectiv) (const GLint *v1, const GLint *v2);
GLHWAPI void (GLAPI *__glhw_Rects) (GLshort x1, GLshort y1, GLshort x2, GLshort y2);
GLHWAPI void (GLAPI *__glhw_Rectsv) (const GLshort *v1, const GLshort *v2);
GLHWAPI GLint (GLAPI *__glhw_RenderMode) (GLenum mode);
GLHWAPI void (GLAPI *__glhw_Rotated) (GLdouble angle, GLdouble x, GLdouble y, GLdouble z);
GLHWAPI void (GLAPI *__glhw_Rotatef) (GLfloat angle, GLfloat x, GLfloat y, GLfloat z);
GLHWAPI void (GLAPI *__glhw_Scaled) (GLdouble x, GLdouble y, GLdouble z);
GLHWAPI void (GLAPI *__glhw_Scalef) (GLfloat x, GLfloat y, GLfloat z);
GLHWAPI void (GLAPI *__glhw_Scissor) (GLint x, GLint y, GLsizei width, GLsizei height);
GLHWAPI void (GLAPI *__glhw_SelectBuffer) (GLsizei size, GLuint *buffer);
GLHWAPI void (GLAPI *__glhw_ShadeModel) (GLenum mode);
GLHWAPI void (GLAPI *__glhw_StencilFunc) (GLenum func, GLint ref, GLuint mask);
GLHWAPI void (GLAPI *__glhw_StencilMask) (GLuint mask);
GLHWAPI void (GLAPI *__glhw_StencilOp) (GLenum fail, GLenum zfail, GLenum zpass);
GLHWAPI void (GLAPI *__glhw_TexCoord1d) (GLdouble s);
GLHWAPI void (GLAPI *__glhw_TexCoord1dv) (const GLdouble *v);
GLHWAPI void (GLAPI *__glhw_TexCoord1f) (GLfloat s);
GLHWAPI void (GLAPI *__glhw_TexCoord1fv) (const GLfloat *v);
GLHWAPI void (GLAPI *__glhw_TexCoord1i) (GLint s);
GLHWAPI void (GLAPI *__glhw_TexCoord1iv) (const GLint *v);
GLHWAPI void (GLAPI *__glhw_TexCoord1s) (GLshort s);
GLHWAPI void (GLAPI *__glhw_TexCoord1sv) (const GLshort *v);
GLHWAPI void (GLAPI *__glhw_TexCoord2d) (GLdouble s, GLdouble t);
GLHWAPI void (GLAPI *__glhw_TexCoord2dv) (const GLdouble *v);
GLHWAPI void (GLAPI *__glhw_TexCoord2f) (GLfloat s, GLfloat t);
GLHWAPI void (GLAPI *__glhw_TexCoord2fv) (const GLfloat *v);
GLHWAPI void (GLAPI *__glhw_TexCoord2i) (GLint s, GLint t);
GLHWAPI void (GLAPI *__glhw_TexCoord2iv) (const GLint *v);
GLHWAPI void (GLAPI *__glhw_TexCoord2s) (GLshort s, GLshort t);
GLHWAPI void (GLAPI *__glhw_TexCoord2sv) (const GLshort *v);
GLHWAPI void (GLAPI *__glhw_TexCoord3d) (GLdouble s, GLdouble t, GLdouble r);
GLHWAPI void (GLAPI *__glhw_TexCoord3dv) (const GLdouble *v);
GLHWAPI void (GLAPI *__glhw_TexCoord3f) (GLfloat s, GLfloat t, GLfloat r);
GLHWAPI void (GLAPI *__glhw_TexCoord3fv) (const GLfloat *v);
GLHWAPI void (GLAPI *__glhw_TexCoord3i) (GLint s, GLint t, GLint r);
GLHWAPI void (GLAPI *__glhw_TexCoord3iv) (const GLint *v);
GLHWAPI void (GLAPI *__glhw_TexCoord3s) (GLshort s, GLshort t, GLshort r);
GLHWAPI void (GLAPI *__glhw_TexCoord3sv) (const GLshort *v);
GLHWAPI void (GLAPI *__glhw_TexCoord4d) (GLdouble s, GLdouble t, GLdouble r, GLdouble q);
GLHWAPI void (GLAPI *__glhw_TexCoord4dv) (const GLdouble *v);
GLHWAPI void (GLAPI *__glhw_TexCoord4f) (GLfloat s, GLfloat t, GLfloat r, GLfloat q);
GLHWAPI void (GLAPI *__glhw_TexCoord4fv) (const GLfloat *v);
GLHWAPI void (GLAPI *__glhw_TexCoord4i) (GLint s, GLint t, GLint r, GLint q);
GLHWAPI void (GLAPI *__glhw_TexCoord4iv) (const GLint *v);
GLHWAPI void (GLAPI *__glhw_TexCoord4s) (GLshort s, GLshort t, GLshort r, GLshort q);
GLHWAPI void (GLAPI *__glhw_TexCoord4sv) (const GLshort *v);
GLHWAPI void (GLAPI *__glhw_TexCoordPointer) (GLint size, GLenum type, GLsizei stride, const GLvoid *pointer);
GLHWAPI void (GLAPI *__glhw_TexEnvf) (GLenum target, GLenum pname, GLfloat param);
GLHWAPI void (GLAPI *__glhw_TexEnvfv) (GLenum target, GLenum pname, const GLfloat *params);
GLHWAPI void (GLAPI *__glhw_TexEnvi) (GLenum target, GLenum pname, GLint param);
GLHWAPI void (GLAPI *__glhw_TexEnviv) (GLenum target, GLenum pname, const GLint *params);
GLHWAPI void (GLAPI *__glhw_TexGend) (GLenum coord, GLenum pname, GLdouble param);
GLHWAPI void (GLAPI *__glhw_TexGendv) (GLenum coord, GLenum pname, const GLdouble *params);
GLHWAPI void (GLAPI *__glhw_TexGenf) (GLenum coord, GLenum pname, GLfloat param);
GLHWAPI void (GLAPI *__glhw_TexGenfv) (GLenum coord, GLenum pname, const GLfloat *params);
GLHWAPI void (GLAPI *__glhw_TexGeni) (GLenum coord, GLenum pname, GLint param);
GLHWAPI void (GLAPI *__glhw_TexGeniv) (GLenum coord, GLenum pname, const GLint *params);
GLHWAPI void (GLAPI *__glhw_TexImage1D) (GLenum target, GLint level, GLint internalformat, GLsizei width, GLint border, GLenum format, GLenum type, const GLvoid *pixels);
GLHWAPI void (GLAPI *__glhw_TexImage2D) (GLenum target, GLint level, GLint internalformat, GLsizei width, GLsizei height, GLint border, GLenum format, GLenum type, const GLvoid *pixels);
GLHWAPI void (GLAPI *__glhw_TexParameterf) (GLenum target, GLenum pname, GLfloat param);
GLHWAPI void (GLAPI *__glhw_TexParameterfv) (GLenum target, GLenum pname, const GLfloat *params);
GLHWAPI void (GLAPI *__glhw_TexParameteri) (GLenum target, GLenum pname, GLint param);
GLHWAPI void (GLAPI *__glhw_TexParameteriv) (GLenum target, GLenum pname, const GLint *params);
GLHWAPI void (GLAPI *__glhw_TexSubImage1D) (GLenum target, GLint level, GLint xoffset, GLsizei width, GLenum format, GLenum type, const GLvoid *pixels);
GLHWAPI void (GLAPI *__glhw_TexSubImage2D) (GLenum target, GLint level, GLint xoffset, GLint yoffset, GLsizei width, GLsizei height, GLenum format, GLenum type, const GLvoid *pixels);
GLHWAPI void (GLAPI *__glhw_Translated) (GLdouble x, GLdouble y, GLdouble z);
GLHWAPI void (GLAPI *__glhw_Translatef) (GLfloat x, GLfloat y, GLfloat z);
GLHWAPI void (GLAPI *__glhw_Vertex2d) (GLdouble x, GLdouble y);
GLHWAPI void (GLAPI *__glhw_Vertex2dv) (const GLdouble *v);
GLHWAPI void (GLAPI *__glhw_Vertex2f) (GLfloat x, GLfloat y);
GLHWAPI void (GLAPI *__glhw_Vertex2fv) (const GLfloat *v);
GLHWAPI void (GLAPI *__glhw_Vertex2i) (GLint x, GLint y);
GLHWAPI void (GLAPI *__glhw_Vertex2iv) (const GLint *v);
GLHWAPI void (GLAPI *__glhw_Vertex2s) (GLshort x, GLshort y);
GLHWAPI void (GLAPI *__glhw_Vertex2sv) (const GLshort *v);
GLHWAPI void (GLAPI *__glhw_Vertex3d) (GLdouble x, GLdouble y, GLdouble z);
GLHWAPI void (GLAPI *__glhw_Vertex3dv) (const GLdouble *v);
GLHWAPI void (GLAPI *__glhw_Vertex3f) (GLfloat x, GLfloat y, GLfloat z);
GLHWAPI void (GLAPI *__glhw_Vertex3fv) (const GLfloat *v);
GLHWAPI void (GLAPI *__glhw_Vertex3i) (GLint x, GLint y, GLint z);
GLHWAPI void (GLAPI *__glhw_Vertex3iv) (const GLint *v);
GLHWAPI void (GLAPI *__glhw_Vertex3s) (GLshort x, GLshort y, GLshort z);
GLHWAPI void (GLAPI *__glhw_Vertex3sv) (const GLshort *v);
GLHWAPI void (GLAPI *__glhw_Vertex4d) (GLdouble x, GLdouble y, GLdouble z, GLdouble w);
GLHWAPI void (GLAPI *__glhw_Vertex4dv) (const GLdouble *v);
GLHWAPI void (GLAPI *__glhw_Vertex4f) (GLfloat x, GLfloat y, GLfloat z, GLfloat w);
GLHWAPI void (GLAPI *__glhw_Vertex4fv) (const GLfloat *v);
GLHWAPI void (GLAPI *__glhw_Vertex4i) (GLint x, GLint y, GLint z, GLint w);
GLHWAPI void (GLAPI *__glhw_Vertex4iv) (const GLint *v);
GLHWAPI void (GLAPI *__glhw_Vertex4s) (GLshort x, GLshort y, GLshort z, GLshort w);
GLHWAPI void (GLAPI *__glhw_Vertex4sv) (const GLshort *v);
GLHWAPI void (GLAPI *__glhw_VertexPointer) (GLint size, GLenum type, GLsizei stride, const GLvoid *pointer);
GLHWAPI void (GLAPI *__glhw_Viewport) (GLint x, GLint y, GLsizei width, GLsizei height);

void GLAPI __glhw_nop();
void GLAPI __glhw_nop4 (GLint);
void GLAPI __glhw_nop8 (GLdouble);
void GLAPI __glhw_nop12 (GLdouble, GLint);
void GLAPI __glhw_nop16 (GLdouble, GLdouble);
void GLAPI __glhw_nop20 (GLdouble, GLdouble, GLint);
void GLAPI __glhw_nop24 (GLdouble, GLdouble, GLdouble);
void GLAPI __glhw_nop28 (GLdouble, GLdouble, GLdouble, GLint);
void GLAPI __glhw_nop32 (GLdouble, GLdouble, GLdouble, GLdouble);
void GLAPI __glhw_nop36 (GLdouble, GLdouble, GLdouble, GLdouble, GLint);
void GLAPI __glhw_nop40 (GLdouble, GLdouble, GLdouble, GLdouble, GLdouble);
void GLAPI __glhw_nop44 (GLdouble, GLdouble, GLdouble, GLdouble, GLdouble, GLint);
void GLAPI __glhw_nop48 (GLdouble, GLdouble, GLdouble, GLdouble, GLdouble, GLdouble);
void GLAPI __glhw_nop52 (GLdouble, GLdouble, GLdouble, GLdouble, GLdouble, GLdouble, GLint);
void GLAPI __glhw_nop56 (GLdouble, GLdouble, GLdouble, GLdouble, GLdouble, GLdouble, GLdouble);

#ifdef __cplusplus
}
#endif

#endif
