/*
** 3/06/2001
** http://graphics.stanford.edu/software/wiregl
**
** Copyright 2001
** The Board of Trustees of The Leland Stanford Junior University.
** All rights reserved.
**
** Except for commercial resale, lease, license or other commercial
** transactions, permission is hereby given to use, copy, and/or
** modify this software, provided that the above copyright notice and
** this permission notice appear in all copies of this software.  No
** part of this software or any derivatives thereof may be used in
** graphics systems for resale or for use in a commercial product.
**
** This software is provided "as is" and without warranty of any kind,
** express, implied or otherwise, including without limitation, any
** warranty of merchantability or fitness for a particular purpose.
*/

#ifndef GLHINT_H
#define GLHINT_H

#include "gltypes.h"
#include "glconfig.h"

#ifdef __cplusplus
extern "C" {
#endif

typedef struct {
	GLbitvalue dirty;
} GLhintbits;

typedef struct {
	GLenum		perspectivecorrection;
	GLenum		pointsmooth;
	GLenum		linesmooth;
	GLenum		polygonsmooth;
	GLenum		fog;
	GLenum		distributedtexture;
} GLhintstate;

/* these hint constants are also in include/wiregl_const.h */

#define WIREGL_DEFAULT_BBOX_HINT		0x8F01
#define WIREGL_SCREEN_BBOX_HINT			0x8F02
#define WIREGL_OBJECT_BBOX_HINT			0x8F03
#define WIREGL_BROADCAST_HINT			0x8F04
#define WIREGL_PACK_ONLY_HINT			0x8F05

#define WIREGL_DISTRIBUTED_TEXTURE_HINT		0x8F06

#define IsUpdateBoundingBox(b) (!((b)->hint))

void __glhint_initbits (GLhintbits *h, GLconfig *c);
void __glhint_switch (GLhintbits *h, GLbitvalue bitID, 
				  GLhintstate *current, GLhintstate *target);
void __glhint_sync (GLhintbits *h, GLbitvalue bitID, 
				  GLhintstate *current, GLhintstate *target);
void __glhint_init (GLhintstate *h, GLconfig *c);
void __glhint_destroy (GLhintstate *);

void GLSTATE_DECL __glstate_Hint (GLenum target, GLenum mode);

#ifdef __cplusplus
}
#endif


#endif

