##
## 3/06/2001
## http://graphics.stanford.edu/software/wiregl
##
## Copyright 2001
## The Board of Trustees of The Leland Stanford Junior University.
## All rights reserved.
##
## Except for commercial resale, lease, license or other commercial
## transactions, permission is hereby given to use, copy, and/or
## modify this software, provided that the above copyright notice and
## this permission notice appear in all copies of this software.  No
## part of this software or any derivatives thereof may be used in
## graphics systems for resale or for use in a commercial product.
##
## This software is provided "as is" and without warranty of any kind,
## express, implied or otherwise, including without limitation, any
## warranty of merchantability or fitness for a particular purpose.
##

require 'glcurrent_types.pl';

print <<EOF;

#include "glcontext.h"
#include "glcurrent.h"
#include "glhw.h"
#include "glerror.h"

#include "glconvert_gen.c"

void
__glcurrent_recover (GLcurrentstate *c, GLcurrentbits *cb, GLbitvalue bitID) {
	unsigned char *v;
	convert_func convert=NULL;
	GLbitvalue nbitID = ~bitID;
	static const GLcolorf color_default			= {0.0f, 0.0f, 0.0f, 1.0f};
	static const GLtexcoordf texcoord_default	= {0.0f, 0.0f, 0.0f, 1.0f};
	static const GLvectorf normal_default		= {0.0f, 0.0f, 0.0f, 1.0f};
	static const GLfloat index_default			= 0.0f;
	static const GLboolean edgeflag_default		= GL_TRUE;
	GLnormal_p		*normal		= &(c->current->normal);
	GLcolor_p		*color		= &(c->current->color);
	GLtexcoord_p	*texcoord	= &(c->current->texcoord);
	GLindex_p		*index		= &(c->current->index);
	GLedgeflag_p	*edgeflag	= &(c->current->edgeflag);

	/* Save pre state */
	c->normal_pre = c->normal;
	c->color_pre = c->color;
	c->texcoord_pre = c->texcoord;
	c->index_pre = c->index;
	c->edgeflag_pre = c->edgeflag;

EOF

foreach $k (keys (%hash)) {
	print "\t/* $k */\n";
	print "\tv=NULL;\n";

	$name = lc $k;

	foreach $type (@ {$hash{$k}{types}}) {
		foreach $size (@ {$hash{$k}{sizes}}) {
			print "\tif ( v < $name->$type$size) {\n";
			print "\t\tv = $name->$type$size;\n";
			if ( ( $k eq "Color" || $k eq "Normal" ) && $type ne 'f' && $type ne 'd' && $type ne 'l') {
				print "\t\tconvert = (convert_func) __convert_rescale_$type$size;\n";
			} elsif ($k ne "EdgeFlag") {
				print "\t\tconvert = (convert_func) __convert_$type$size;\n";
			}
			print "\t}\n";
		}
	}
	print "\n";
	print "\tif (v != NULL) {\n";
	print "\t\tc->$name = ${name}_default;\n";
	if ($k eq "EdgeFlag") {
		print "\t\t__convert_boolean (&(c->$name), v);\n";
	} elsif ($k eq "Index") {
		print "\t\tconvert(&(c->$name), v);\n";
	} elsif ($k eq "Normal") {
		print "\t\tconvert(&(c->$name.x), v);\n";
	} elsif ($k eq "TexCoord") {
		print "\t\tconvert(&(c->$name.s), v);\n";
	} elsif ($k eq "Color") {
		print "\t\tconvert(&(c->$name.r), v);\n";
	}
	print "\t\tcb->$name = nbitID;\n";
	print "\t\tcb->dirty = nbitID;\n";
	print "\t}\n";
	print "\t$name->ptr = v;\n\n";
}

print <<EOF;
}

void
__glcurrent_fixup_pointers (GLcurrentstate *c, int offset) {
	GLnormal_p		*normal		= &(c->current->normal);
	GLcolor_p		*color		= &(c->current->color);
	GLtexcoord_p	*texcoord	= &(c->current->texcoord);
	GLindex_p		*index		= &(c->current->index);
	GLedgeflag_p	*edgeflag	= &(c->current->edgeflag);

EOF

foreach $k (keys (%hash)) {
	print "\t/* $k */\n";

	$name = lc $k;

	foreach $type (@ {$hash{$k}{types}}) {
		foreach $size (@ {$hash{$k}{sizes}}) {
			$ptr = "$name->$type$size";
			print "\tif ( $ptr )\n";
			print "\t\t$ptr += offset;\n";
		}
	}

	print "\n";
}

print "}\n\n";

print <<EOF;
void
__glcurrent_null_pointers (GLcurrentstate *c) {
	GLnormal_p		*normal		= &(c->current->normal);
	GLcolor_p		*color		= &(c->current->color);
	GLtexcoord_p	*texcoord	= &(c->current->texcoord);
	GLindex_p		*index		= &(c->current->index);
	GLedgeflag_p	*edgeflag	= &(c->current->edgeflag);

EOF

foreach $k (keys (%hash)) {
	print "\t/* $k */\n";
	$name = lc $k;
	foreach $type (@ {$hash{$k}{types}}) {
		print "\t$name->ptr = NULL;\n";
		foreach $size (@ {$hash{$k}{sizes}}) {
			print "\t$name->$type$size = NULL;\n";
		}
	}
	print "\n";
}

print "}\n\n";
