/*
** 3/06/2001
** http://graphics.stanford.edu/software/wiregl
**
** Copyright 2001
** The Board of Trustees of The Leland Stanford Junior University.
** All rights reserved.
**
** Except for commercial resale, lease, license or other commercial
** transactions, permission is hereby given to use, copy, and/or
** modify this software, provided that the above copyright notice and
** this permission notice appear in all copies of this software.  No
** part of this software or any derivatives thereof may be used in
** graphics systems for resale or for use in a commercial product.
**
** This software is provided "as is" and without warranty of any kind,
** express, implied or otherwise, including without limitation, any
** warranty of merchantability or fitness for a particular purpose.
*/

#ifndef GLCURRENT_H
#define GLCURRENT_H

#include "gltypes.h"
#include "glconfig.h"
#include "glcurrent_pointers.h"

#ifdef __cplusplus
extern "C" {
#endif

typedef struct GLcurrentbits {
	GLbitvalue	dirty;
	GLbitvalue  enable;
	GLbitvalue	color;
	GLbitvalue	index;
	GLbitvalue	texcoord;
	GLbitvalue	normal;
	GLbitvalue	raster;
	GLbitvalue	edgeflag;
} GLcurrentbits; 

typedef struct GLvertex {
	GLvectorf	pos;
	GLcolorf	color;
	GLtexcoordf	texcoord;
	GLvectorf	normal;
	GLboolean	edgeflag;
	GLfloat		index;
} GLvertex;

typedef struct GLcurrentstate {
	GLcolorf		color;
	GLfloat			index;
	GLtexcoordf		texcoord;
	GLvectorf		normal;
	GLboolean		edgeflag;
	
	GLcolorf		color_pre;
	GLfloat			index_pre;
	GLtexcoordf		texcoord_pre;
	GLvectorf		normal_pre;
	GLboolean		edgeflag_pre;

	GLcurrent		*current;

	GLvectorf		rasterpos;
	GLvectorf		rasterpos_pre;

	GLfloat			rasterdistance;
	GLcolorf		rastercolor;
	GLtexcoordf		rastertexture;
	GLdouble		rasterindex;
	GLboolean		rastervalid;

	GLboolean		normalize;

	GLboolean		beginend;
	GLenum			mode;
	GLboolean		isloop;

	GLuint			beginendmax;
	GLuint			beginendnum;
	GLuint          flush_on_end;

	GLint			num_restore;
	GLint			wind;
	GLvertex		vtx[3];

} GLcurrentstate; 

void __glcurrent_initbits (GLcurrentbits *, GLconfig *);
void __glcurrent_switch (GLcurrentbits *, GLbitvalue bitID,
							 GLcurrentstate *, GLcurrentstate *);
void __glcurrent_sync (GLcurrentbits *, GLbitvalue bitID,
							 GLcurrentstate *, GLcurrentstate *);

void __glcurrent_init (GLcurrentstate *c, GLconfig *cfg);
void __glcurrent_destroy (GLcurrentstate *c);
void __glcurrent_recover (GLcurrentstate *c, GLcurrentbits *cb, GLbitvalue bitID);
void __glcurrent_restore_tri (GLcurrentstate *c);
void __glcurrent_fixup_pointers (GLcurrentstate *c, int offset);
void __glcurrent_finish (GLcurrentstate *c, GLcurrentbits *cb, GLbitvalue bitID);
void __glcurrent_null_pointers (GLcurrentstate *c);

void GLSTATE_DECL __glstate_RasterPos2d(GLdouble x, GLdouble y);
void GLSTATE_DECL __glstate_RasterPos2f(GLfloat x, GLfloat y);
void GLSTATE_DECL __glstate_RasterPos2i(GLint x, GLint y);
void GLSTATE_DECL __glstate_RasterPos2s(GLshort x, GLshort y);
void GLSTATE_DECL __glstate_RasterPos3d(GLdouble x, GLdouble y, GLdouble z);
void GLSTATE_DECL __glstate_RasterPos3f(GLfloat x, GLfloat y, GLfloat z);
void GLSTATE_DECL __glstate_RasterPos3i(GLint x, GLint y, GLint z);
void GLSTATE_DECL __glstate_RasterPos3s(GLshort x, GLshort y, GLshort z);
void GLSTATE_DECL __glstate_RasterPos4d(GLdouble x, GLdouble y, GLdouble z, GLdouble w);
void GLSTATE_DECL __glstate_RasterPos4f(GLfloat x, GLfloat y, GLfloat z, GLfloat w);
void GLSTATE_DECL __glstate_RasterPos4i(GLint x, GLint y, GLint z, GLint w);
void GLSTATE_DECL __glstate_RasterPos4s(GLshort x, GLshort y, GLshort z, GLshort w);
void GLSTATE_DECL __glstate_RasterPos2dv(const GLdouble *v);
void GLSTATE_DECL __glstate_RasterPos2fv(const GLfloat *v);
void GLSTATE_DECL __glstate_RasterPos2iv(const GLint *v);
void GLSTATE_DECL __glstate_RasterPos2sv(const GLshort *v);
void GLSTATE_DECL __glstate_RasterPos3dv(const GLdouble *v);
void GLSTATE_DECL __glstate_RasterPos3fv(const GLfloat *v);
void GLSTATE_DECL __glstate_RasterPos3iv(const GLint *v);
void GLSTATE_DECL __glstate_RasterPos3sv(const GLshort *v);
void GLSTATE_DECL __glstate_RasterPos4dv(const GLdouble *v);
void GLSTATE_DECL __glstate_RasterPos4fv(const GLfloat *v);
void GLSTATE_DECL __glstate_RasterPos4iv(const GLint *v);
void GLSTATE_DECL __glstate_RasterPos4sv(const GLshort *v);

void GLSTATE_DECL __glstate_Begin (GLenum mode);
void GLSTATE_DECL __glstate_End (void);

void GLSTATE_DECL __gltrack_Begin (GLenum mode);
void GLSTATE_DECL __gltrack_End (void);

#ifdef __cplusplus
}
#endif

#endif
