##
## 3/06/2001
## http://graphics.stanford.edu/software/wiregl
##
## Copyright 2001
## The Board of Trustees of The Leland Stanford Junior University.
## All rights reserved.
##
## Except for commercial resale, lease, license or other commercial
## transactions, permission is hereby given to use, copy, and/or
## modify this software, provided that the above copyright notice and
## this permission notice appear in all copies of this software.  No
## part of this software or any derivatives thereof may be used in
## graphics systems for resale or for use in a commercial product.
##
## This software is provided "as is" and without warranty of any kind,
## express, implied or otherwise, including without limitation, any
## warranty of merchantability or fitness for a particular purpose.
##

require 'glcurrent_types.pl';

print <<EOF;

static double __read_double( void *src )
{
    unsigned int *ui = (unsigned int *) src;
    double d;
    ((unsigned int *) &d)[0] = ui[0];
    ((unsigned int *) &d)[1] = ui[1];
    return d;
}

EOF

foreach $k (keys (%gltypes)) {
	for $i (1..4) {
		print "void __convert_$k$i (GLfloat *dst, $gltypes{$k}{type} *src) {\n";
		if ( $k eq 'd' ) {
		  for $j (1..$i-1) {
		    print "\t*dst++ = (GLfloat) __read_double(src++);\n";
		  }
		  print "\t*dst = (GLfloat) __read_double(src);\n";
		}
		else {
		  for $j (1..$i-1) {
		    print "\t*dst++ = (GLfloat) *src++;\n";
		  }
		  print "\t*dst = (GLfloat) *src;\n";
		}
		print "}\n\n";
	}
}

%scale = (
	'ub' => 'GL_MAXUBYTE',
	'b'  => 'GL_MAXBYTE',
	'us' => 'GL_MAXUSHORT',
	's'  => 'GL_MAXSHORT',
	'ui' => 'GL_MAXUINT',
	'i'  => 'GL_MAXINT',
	'f'  => '',
	'd'  => ''
);

foreach $k (keys (%gltypes)) {
	if ($k ne 'f' && $k ne 'd' && $k ne 'l') {
		for $i (1..4) {
			print "void __convert_rescale_$k$i (GLfloat *dst, $gltypes{$k}{type} *src) {\n";
			for $j (1..$i-1) {
				print "\t*dst++ = ((GLfloat) *src++) / $scale{$k};\n";
			}
			print "\t*dst = ((GLfloat) *src) / $scale{$k};\n";
			print "}\n\n";
		}
	}
}


print <<EOF;

void __convert_boolean (GLboolean *dst, GLboolean *src) {
	*dst = *src;
}

typedef void (*convert_func) (GLfloat *, unsigned char *);

EOF


foreach $k (keys (%hash)) {
	$name = lc $k;
	$ucname = uc $k;
	$num_members = $#{$hash{$k}{default}} + 1;

	print "#define VPINCH_CONVERT_$ucname(op,data,dst) \\\n";
	print "{\\\n";
	print "\tGLfloat vdata[$num_members] = { ";

## Copy dst data into vdata
	$i = 0;
    foreach $defaultvar (@ {$hash{$k}{default}}) {
		print $defaultvar;
		if ($i != $#{$hash{$k}{default}}) {
			print ", ";
		}
		$i++;
	}
	print "};\\\n";

	print "\tswitch (op) { \\\n";

	foreach $type (@ {$hash{$k}{types}}) {
		foreach $size (@ {$hash{$k}{sizes}}) {
			$uctype = uc $type;
			if ($ucname eq "EDGEFLAG") {
				print "\tcase WIREGL_${ucname}_OPCODE: \\\n";
			} else {
				print "\tcase WIREGL_$ucname$size${uctype}_OPCODE: \\\n";
			}
			
			if (($ucname eq "COLOR" || $ucname eq "NORMAL") && $type ne "f" && $type ne "d") {
				print "\t\t__convert_rescale_$type$size (vdata, ($gltypes{$type}{type} *) (data)); \\\n";
			} else {
				print "\t\t__convert_$type$size (vdata, ($gltypes{$type}{type} *) (data)); \\\n";
			}
			print "\t\tbreak; \\\n";
		}
	}

	print "\tdefault: \\\n";
	print "\t\twireGLAbort (); \\\n";
	print "\t}\\\n";

	$i = 0;
	foreach $member (@ {$hash{$k}{members}}) {
		print "\t(dst).$member = vdata[$i];\\\n";
		$i++
	}

	print "}\n\n";
}


