/*
** 3/06/2001
** http://graphics.stanford.edu/software/wiregl
**
** Copyright 2001
** The Board of Trustees of The Leland Stanford Junior University.
** All rights reserved.
**
** Except for commercial resale, lease, license or other commercial
** transactions, permission is hereby given to use, copy, and/or
** modify this software, provided that the above copyright notice and
** this permission notice appear in all copies of this software.  No
** part of this software or any derivatives thereof may be used in
** graphics systems for resale or for use in a commercial product.
**
** This software is provided "as is" and without warranty of any kind,
** express, implied or otherwise, including without limitation, any
** warranty of merchantability or fitness for a particular purpose.
*/

#ifndef GLCONTEXT_H
#define GLCONTEXT_H

#include "gltypes.h"
#include "glconfig.h"

#include "glbucket.h"
#include "glbuffer.h"
#include "glclient.h"
#include "glcurrent.h"
#include "glenable.h"
#include "gleval.h"
#include "glfog.h"
#include "glget.h"
#include "glhint.h"
#include "glimaging.h"
#include "gllighting.h"
#include "glline.h"
#include "gllists.h"
#include "glpixel.h"
#include "glpolygon.h"
#include "glselection.h"
#include "glstencil.h"
#include "gltexture.h"
#include "gltrans.h"
#include "glviewport.h"

#include <stdlib.h>
#include <stdio.h>

#ifdef __cplusplus
extern "C" {
#endif

#define GLCONTEXT_MAXCONTEXTS GLBITS_LENGTH

#define GLUPDATE_TRANS		0x00001
#define GLUPDATE_PIXEL		0x00002
#define GLUPDATE_CURRENT	0x00004
#define GLUPDATE_VIEWPORT	0x00008
#define GLUPDATE_FOG		0x00010
#define GLUPDATE_TEXTURE	0x00020
#define GLUPDATE_LISTS		0x00040
#define GLUPDATE_CLIENT		0x00080
#define GLUPDATE_BUFFER		0x00100
#define GLUPDATE_HINT		0x00200
#define GLUPDATE_LIGHTING	0x00400
#define GLUPDATE_LINE		0x00800
#define GLUPDATE_POLYGON	0x01000
#define GLUPDATE_STENCIL	0x02000
#define GLUPDATE_EVAL		0x04000
#define GLUPDATE_IMAGING	0x08000
#define GLUPDATE_SELECTION	0x10000

typedef struct GLstatebits {
	GLbufferbits	buffer;
	GLclientbits	client;
	GLcurrentbits	current;
	GLfogbits		fog;
	GLhintbits		hint;
	GLlightingbits	lighting;
	GLlinebits		line;
	GLpixelbits		pixel;
	GLpolygonbits	polygon;
	GLstencilbits	stencil;
	GLtexturebits	texture;
	GLtransbits		trans;
	GLviewportbits	viewport;
	GLevalbits		eval;
/* Still need implementing... */
	GLimagingbits	imaging;
	GLlistsbits		lists;
	GLselectionbits	selection;
} GLstatebits;

typedef struct GLcontext {
	GLbucketstate	bucket;
	GLbufferstate	buffer;
	GLclientstate	client;
	GLcurrentstate	current;
	GLevalstate		eval;
	GLfogstate		fog;
	GLhintstate		hint;
	GLlightingstate	lighting;
	GLlinestate		line;
	GLlistsstate	lists;
	GLpixelstate	pixel;
	GLpolygonstate	polygon;
	GLstencilstate	stencil;
	GLtexturestate	texture;
	GLtransstate	trans;
	GLviewportstate viewport;

/* Still need implementing */
	GLimagingstate		imaging;
	GLselectionstate	selection;
	
	GLuint			ID;
	GLbitvalue		bitID;
	GLbitvalue		nbitID;
	GLbitvalue		update;
	GLenum			error;
	char *	vendor;
	char *	renderer;
	char *	version;
	char *	extensions;

	GLconfig		*config;

} GLcontext;

extern GLboolean __glinitflag;
extern GLcontext *	__currentcontext;
extern GLstatebits	* __statebits;
extern GLint __bktactive;
extern GLconfig * __config;

#define GetCurrentContext() __currentcontext
#define GetStateBits() __statebits
#define IsBucketingActive() __bktactive

void		__glInit (GLconfig *);
void		__glDestroy (void);
GLcontext * __glCreateVirtualContext(void);
GLcontext *	__glCreateContext(void);
GLcontext * __glCreateContext_id(GLbitvalue id, int i);
void		__glMakeCurrent(GLcontext *g);
GLcontext * __glGetCurrentContext (void);
void		__glDestroyContext(GLcontext *g);
const GLflushinfo * __glBeginFlush(void);
void		__glDiffContext(GLcontext *from, GLcontext *to);
void		__glEndFlush(void);
void		__glCloseBeginEnd( GLcontext *target);
void		__glFixupPointers( int offset );
void		__glExtractCurrentState( void );
void        __glSetOutputBounds (GLcontext *g,
								 GLrecti *outputwindow,
								 GLrecti *imagespace,
								 GLrecti *imagewindow);
void        __glApplyViewTranform (GLcontext *g, GLboolean z);
void	    __glstate_SendState( GLint state );



GLenum	GLSTATE_DECL __glstate_GetError(void);

void		__glcontext_switch(GLcontext *from, GLcontext *to);
void		__glcontext_sync(GLcontext *from, GLcontext *to);

void    __glstate_SetBroadcast(GLint state);

#define UNUSED(x)  ((void) x)

#ifdef __cplusplus
}
#endif

#endif
