/*
** 3/06/2001
** http://graphics.stanford.edu/software/wiregl
**
** Copyright 2001
** The Board of Trustees of The Leland Stanford Junior University.
** All rights reserved.
**
** Except for commercial resale, lease, license or other commercial
** transactions, permission is hereby given to use, copy, and/or
** modify this software, provided that the above copyright notice and
** this permission notice appear in all copies of this software.  No
** part of this software or any derivatives thereof may be used in
** graphics systems for resale or for use in a commercial product.
**
** This software is provided "as is" and without warranty of any kind,
** express, implied or otherwise, including without limitation, any
** warranty of merchantability or fitness for a particular purpose.
*/

#ifndef GLBUCKET_H
#define GLBUCKET_H

#include "gltypes.h"
#include "glconfig.h"

#ifdef __cplusplus
extern "C" {
#endif

struct GLcontext;
typedef struct {
	GLboolean active;
	GLenum hint;
	GLuint *count;
	GLuint *max;
	GLvectorf *bmin;
	GLvectorf *bmax;
	void (*flush) (struct GLcontext *);
} GLbucketstate;

typedef struct {
	GLbitvalue hits;
	GLint	   isstate;
	GLvectorf  screenmin;
	GLvectorf  screenmax;
	GLvectorf  objectmin;
	GLvectorf  objectmax;
	GLrecti    pixelbounds;
} GLflushinfo;

void __glbucket_init(GLbucketstate *b, GLconfig *c);
void __glbucket_destroy(GLbucketstate *);
void __glbucket_bounds(GLint x, GLint y, GLint w, GLint h);
GLrectf * __glbucket_getclip(GLbitvalue id);
void __glbucket_begin(void);
const GLflushinfo * __glbucket_flush (void);
void __glbucket_endflush (void);
GLmatrix * __glbucket_getcompositematrix(void);
void __glbucket_drawbbox(void);
void __glbucket_syncstate ( void );

/* HACK SUCKS */
extern GLint __bktactive;
extern GLint __bktalwaysbroadcast;
extern GLint __bktbroadcast;
extern GLint __bktnobuffer;
extern GLint __isstate;


// Broadcast functions
void GLSTATE_DECL __glstate_Accum (GLenum op, GLfloat value);
void GLSTATE_DECL __glstate_CallLists (GLsizei n, GLenum type, const GLvoid *lists);
void GLSTATE_DECL __glstate_CallList (GLuint list);
void GLSTATE_DECL __glstate_Clear (GLbitfield mask);
void GLSTATE_DECL __glstate_Bitmap (GLsizei width, GLsizei height,
									GLfloat xorig, GLfloat yorig,
									GLfloat xmove, GLfloat ymove,
									const GLubyte * bitmap);
void GLSTATE_DECL __glstate_DrawPixels (GLsizei width, GLsizei height, 
										GLenum format, GLenum type,
										const GLvoid *pixels);

void GLSTATE_DECL __gltrack_Clear (GLbitfield mask);
void GLSTATE_DECL __gltrack_Bitmap (GLsizei width, GLsizei height,
									GLfloat xorig, GLfloat yorig,
									GLfloat xmove, GLfloat ymove,
									const GLubyte * bitmap);


// Rect bucketer
void GLSTATE_DECL __glstate_Rectd (GLdouble x1, GLdouble y1, GLdouble x2, GLdouble y2);
void GLSTATE_DECL __glstate_Rectdv (const GLdouble *v1, const GLdouble *v2);
void GLSTATE_DECL __glstate_Rectf (GLfloat x1, GLfloat y1, GLfloat x2, GLfloat y2);
void GLSTATE_DECL __glstate_Rectfv (const GLfloat *v1, const GLfloat *v2);
void GLSTATE_DECL __glstate_Recti (GLint x1, GLint y1, GLint x2, GLint y2);
void GLSTATE_DECL __glstate_Rectiv (const GLint *v1, const GLint *v2);
void GLSTATE_DECL __glstate_Rects (GLshort x1, GLshort y1, GLshort x2, GLshort y2);
void GLSTATE_DECL __glstate_Rectsv (const GLshort *v1, const GLshort *v2);

#ifdef __cplusplus
}
#endif


#endif
