##
## 3/06/2001
## http://graphics.stanford.edu/software/wiregl
##
## Copyright 2001
## The Board of Trustees of The Leland Stanford Junior University.
## All rights reserved.
##
## Except for commercial resale, lease, license or other commercial
## transactions, permission is hereby given to use, copy, and/or
## modify this software, provided that the above copyright notice and
## this permission notice appear in all copies of this software.  No
## part of this software or any derivatives thereof may be used in
## graphics systems for resale or for use in a commercial product.
##
## This software is provided "as is" and without warranty of any kind,
## express, implied or otherwise, including without limitation, any
## warranty of merchantability or fitness for a particular purpose.
##

sub gentrackcode;
$name = shift @ARGV;
gentrackcode ("gl".$name.".c");


sub gentrackcode {
$fname = $_[0];
$inecheck = 0;
$infunc = 0;
$infuncdef = 1;
$scopecount = 0;
$include = 0;
$itermediate = 0;
$foundunimplemented = 0;

open (FILE, $fname);

mainloop: while ($line = <FILE>) {
	chomp $line;

	if ($line =~ /\/\*ECHECK\*\//) {
		$inecheck = !$inecheck;
		next mainloop if (!$inecheck);
	}

	if ($line =~ /\/\*INCLUDE\*\//) {
		$include = !$include;
		print $line."\n";
		next mainloop;
	}

	if ($line =~ /TRACK_ONLY/) {
		$include = !$include;
		next mainloop;
	}

	print $line."\n" if ($include);
	next mainloop if ($inecheck || $include);

	$scopecount++ if ($line =~ /{/);
	$scopecount-- if ($line =~ /}/);

	if ($infunc) {
		$foundunimplemented = 1 if ($line =~ /UNIMPLEMENTED/);
		if ($scopecount == 0) {
			if (!$intermediate && !$foundunimplemented) {
				print "\n\t__glhw_$func (";
				foreach $param (@params) {
					print $param;
					print ", " if ($param ne $params[$#params]);
				}
				print ");\n\n";
			}
			$intermediate = 0;
			$foundunimpleneted = 0;
			$infunc = 0;
		}

		if ($line =~ /(\t*)__glstate_(.*)/) {
			$intermediate = 1;
			print $1."__gltrack_".$2."\n";
		} else {
			print $line."\n";
		}
	} elsif ($line =~ /__glstate_/) {
		next mainloop if ($line =~ /Get/);

		while ($line !~ /\)/) {
			$temp = <FILE>;
			chomp $temp;
			$temp =~ /\t*(.*)/;
			$line = $line.$1;
			$scopecount++ if ($temp =~ /{/);
		}

		$line =~ /__glstate_(\w*)\s*\((.*)/;
		$func = $1;
		$argstring = $2;

		@params = ();
		@words = split ' ', $argstring;
		foreach $word (@words) {
			if ($word =~ /(\w*)\,/ || $word =~ /(\w\w*)\)/) {
				$params[++$#params] = $1;
			} 
		}
		$infunc = 1;

		print "\n\nvoid GLSTATE_DECL\n__gltrack_$func ($argstring \n";
	}
}
}
