##
## 3/06/2001
## http://graphics.stanford.edu/software/wiregl
##
## Copyright 2001
## The Board of Trustees of The Leland Stanford Junior University.
## All rights reserved.
##
## Except for commercial resale, lease, license or other commercial
## transactions, permission is hereby given to use, copy, and/or
## modify this software, provided that the above copyright notice and
## this permission notice appear in all copies of this software.  No
## part of this software or any derivatives thereof may be used in
## graphics systems for resale or for use in a commercial product.
##
## This software is provided "as is" and without warranty of any kind,
## express, implied or otherwise, including without limitation, any
## warranty of merchantability or fitness for a particular purpose.
##

sub gendiffcode;
$name = shift @ARGV;

print << 'EOF';
/*
** 3/06/2001
** http://graphics.stanford.edu/software/wiregl
**
** Copyright 2001
** The Board of Trustees of The Leland Stanford Junior University.
** All rights reserved.
**
** Except for commercial resale, lease, license or other commercial
** transactions, permission is hereby given to use, copy, and/or
** modify this software, provided that the above copyright notice and
** this permission notice appear in all copies of this software.  No
** part of this software or any derivatives thereof may be used in
** graphics systems for resale or for use in a commercial product.
**
** This software is provided "as is" and without warranty of any kind,
** express, implied or otherwise, including without limitation, any
** warranty of merchantability or fitness for a particular purpose.
*/

#include "glcontext.h"
#include "glerror.h"
#include "glhw.h"

EOF

print "void\n";
print "__gl".$name."_sync(GL".$name."bits *b, GLbitvalue bitID,\n";
print "\tGL".$name."state *current, GL".$name."state *target) {\n";
gendiffcode ("gl".$name.".txt", 1, 0);
print "}\n\n";

print "void\n";
print "__gl".$name."_switch(GL".$name."bits *b, GLbitvalue bitID,\n";
print "\tGL".$name."state *current, GL".$name."state *target) {\n";
gendiffcode ("gl".$name.".txt", 0, 1);
print "}\n\n";

sub gendiffcode {

$fname = $_[0];
$docopy = $_[1];
$doinvalid = $_[2];

$target = "target";
$current = "current";
$bit = "b";
$tab = "\t";
$current_guard = "";
$current_dependancy = "";

%v_types = (
	'l' => 'GLboolean',
	'b' => 'GLbyte',
	'ub' => 'GLubyte',
	's' => 'GLshort',
	'us' => 'GLushort',
	'i' => 'GLint',
	'ui' => 'GLuint',
	'f' => 'GLfloat',
	'd' => 'GLdouble'
);


open(FILE, $fname);

print "\tGLbitvalue nbitID = ~bitID;\n";

mainloop: while ($line = <FILE>) {
	chomp $line;


## Handle text dump
	if ($line =~ /^\+(.*)/) {
		next mainloop if $doinvalid;
		$line = $1;
	}

	elsif ($line =~ /^-(.*)/) {
		next mainloop if $docopy;
		$line = $1;
	}

	if ($line =~ /^>(.*)/) {
		$text = $1;
		chop $tab if ($line =~ /}/);
		print $tab.$text."\n";
		$tab=$tab."\t" if ($line =~ /{/);
		next mainloop;
	}
  
## Handle commands

	$target = $1 if ($line =~ /%target=(\w*)/);
	$current = $1 if ($line =~ /%current=(\w*)/);
	$bit = $1 if ($line =~ /%bit=(\w*)/);

	if ($line =~ /%flush/) {
		if (($current_guard ne "")) {
			print $tab."$bit->$current_guard &= nbitID;\n";
			chop ($tab);
			print $tab."}\n";
		}
		if ($docopy && ($current_dependancy ne "")) {
			chop ($tab);
			print $tab."}\n";
		}
		$current_guard = "";
		$current_dependancy = "";
	}
	next mainloop if ($line =~ /%.*/);

## Load the line
	($dependancy, $guardbit, $members, $func) = split /:/, $line;
	chomp $func;

## Close the guardbit and dependancy
  if (($current_guard ne "") && ($current_guard ne $guardbit)) {
	print $tab."$bit->$current_guard &= nbitID;\n";
	chop ($tab);
	print $tab."}\n";
  }
  if ($docopy && ($current_dependancy ne "") && ($current_dependancy ne $dependancy)) {
	chop ($tab);
	print $tab."}\n";
  }

## Open the dependancy if
  if ($docopy && $current_dependancy ne $dependancy && $dependancy ne "") {
    print $tab."if ($target->$dependancy) {\n";
	$tab = $tab."\t";
	$current_dependancy = $dependancy;
  }
  
## Open the guard if
  if ($docopy && $current_dependancy ne $dependancy && $dependancy ne "") {
    print $tab."if ($target->$dependancy) {\n";
		$tab = $tab."\t";
  }
  
  if ($current_guard ne $guardbit && $guardbit ne "") {
		print $tab."if ($bit->$guardbit & bitID) {\n";
		$tab = $tab."\t";
		if (substr($members,0,1) ne "\*" && $guardbit eq "enable") {
			print $tab."glAble able[2];\n";
			print $tab."able[0] = __glhw_Disable;\n";
			print $tab."able[1] = __glhw_Enable;\n";
		}
  }

  $current_dependancy = $dependancy;
  $current_guard = $guardbit;

## Handle text dump
  if (substr($members,0,1) eq "\*") {
    print $tab.substr($members, 1)."\n"
  } else {

	## Parse the members variable
	  @mainelem = split /,/, $members;
	  @elems = split /\|/, $members;
	  if ($#elems) {
		@mainelem = ("");
		$mainelem[0] = $elems[0];
		@elems = split /,/, $elems[1];
		foreach $elem (@elems) {
		  $elem = $mainelem[0] . "." . $elem;
		}
	  } else {
		@elems = split /,/, $members;
	  }

	## Check member values
	  print $tab."if (";
	  $first = 1;
	  foreach $elem (@elems) {
		if ($first != 1) {
		  print " ||\n$tab    ";
		}
		$first = 0;
		print "$current->$elem != $target->$elem";
	  }
	  print ") {\n";
	  $tab = $tab."\t";

## Handle text function 
	if (substr($func, 0, 1) eq "*") {
		$func = substr($func, 1);
		print $tab.$func."\n";
	} else {
		if ($func ne "") {
## Call the glhw function
			if ($guardbit eq "enable") {
				print $tab."able[$target->$elems[0]]($func);\n";
			} else {
				@funcargs = split /,/, $func;
				$func = shift @funcargs;

				if (substr ($func, -1) eq "v") {
					$v_type = substr ($func, -2, 1);
					$num_elems = $#elems+1;
					print $tab.$v_types{$v_type}." varg[$num_elems];\n";
					$i = 0;
					foreach $elem (@elems) {
						print $tab."varg[$i] = $target->".$elem.";\n";
						$i++;
					}
				}

				print $tab."__glhw_$func (";
				foreach $funcarg (@funcargs) {
					print $funcarg.", ";
				}

## Handle vargs
				if (substr ($func, -1) eq "v") {
					print "varg";
				} else {
					$first = 1;
					foreach $elem (@elems) {
					if ($first != 1) {
						print ",\n$tab    ";
					}
					$first = 0;
					print "$target->$elem";
					}
				}
				print ");\n";
			}
		}
	}

## Do the sync if nessesary
	  if ($docopy) {
		foreach $elem (@mainelem) {
		  print $tab."$current->$elem = $target->$elem;\n";
		}
	  }

	## Do the clear if nessesary
	  if ($doinvalid) {
		if ($guardbit ne "") {
			print $tab."$bit->$guardbit=GLBITS_ONES;\n";
		}
		print $tab."$bit->dirty=GLBITS_ONES;\n";
	  }

	## Close the compare
	  chop ($tab);
	  print $tab."}\n";
	}
}

## Do final closures
if ($current_guard ne "") {
  print $tab."$bit->$current_guard &= nbitID;\n";
  chop ($tab);
  print $tab."}\n";
}
if ($docopy && $current_dependancy ne "") {
  chop ($tab);
  print $tab."} \/*$current_dependancy*\/\n"
}

print $tab."$bit->dirty &= nbitID;\n";

}

