
proc usage args {
    puts ""
    puts "vripupdate <vrip_file> <conf_file> \[options\]"
    puts ""
    puts "    Options:"
    puts "        -carve_conservative"
    puts "        -carve_agressive"
    puts "        -carve_only"
    puts "        -show_render"
    puts "        -slicer"
    puts ""
    exit
}

# Print usage if necessary...
if {$argc == 0 || [lindex $argv 0] == "-h"} {
    usage
}





vrip_param -quiet 1

set gridFile [lindex $argv 0]
set confFile [lindex $argv 1]

# Check arguments, to avoid obscure error messages later.
if {![file isfile $gridFile]} {
    puts stderr "Error:  Could not open grid file: $gridFile"
    usage
}
if {![file isfile $confFile]} {
    puts stderr "Error:  Could not open conf file: $confFile"
    usage
}

set bmeshCmd bmesh
set warp 0
set doSil 0

if {$argc > 2} {
    for {set i 2} {$i < $argc} {incr i} {
        set arg [lindex $argv $i]
        if {$arg == "-carve_conservative"} {
	    set bmeshCmd bmeshlin
	    vrip_param -use_tails 1
        } elseif {$arg == "-carve_semi"} {
	    set bmeshCmd bmeshlin
	    vrip_param -use_tails 1
	    param -maxedge 0.01
        } elseif {$arg == "-carve_agressive"} {
	    set bmeshCmd bmeshlin
	    vrip_param -use_tails 1 -fill_gaps 1
        } elseif {$arg == "-carve_only"} {
	    set bmeshCmd bmeshlin
	    vrip_param -use_tails 1 -tails_only 1
	} elseif {$arg == "-show_render"} {
	    show_render
	} elseif {$arg == "-slicer"} {
	    slicer
	} elseif {$arg == "-linepersp"} {
	    set bmeshCmd bmeshlin
	} elseif {$arg == "-stzoom"} {
	    incr i
	    set arg [lindex $argv $i]
	    set CywarpSTZoom $arg
	    set warp 1
	} elseif {$arg == "-yzoom"} {
	    incr i
	    set arg [lindex $argv $i]
	    set CywarpYZoom $arg
	    set warp 1
	} elseif {$arg == "-wangle"} {
	    incr i
	    set arg [lindex $argv $i]
	    set CywarpAngle $arg
	    set warp 1
	} elseif {$arg == "-sil"} {
	    set doSil 1
	    set bmeshCmd bmeshlin
	}
    }
}

if {$warp} {
    set bmeshCmd "${bmeshCmd}warp"
}

if {$bmeshCmd != "bmesh"} {
    alias bmesh $bmeshCmd
}

update

catch {exec vriphead $gridFile} msg
set x [string last Resolution: $msg]
set x [expr $x + [string length Resolution:] + 1]
set voxelSize [string range $msg $x end]
set voxelSize [format "%g" $voxelSize]

if {[info exists resToScaleMap($voxelSize)]} {
   changeRampScale $resToScaleMap($voxelSize)
}

if {$doSil} {
   param -use_length 0
   param -line_persp_center 0 0.1536 1.102
   updateSilFromConf $gridFile $confFile
} else {
   updateFromConf $gridFile $confFile
}

exit

