/*

Brian Curless

Computer Graphics Laboratory
Stanford University

---------------------------------------------------------------------

Copyright (1997) The Board of Trustees of the Leland Stanford Junior
University. Except for commercial resale, lease, license or other
commercial transactions, permission is hereby given to use, copy,
modify this software for academic purposes only.  No part of this
software or any derivatives thereof may be used in the production of
computer models for resale or for use in a commercial
product. STANFORD MAKES NO REPRESENTATIONS OR WARRANTIES OF ANY KIND
CONCERNING THIS SOFTWARE.  No support is implied or provided.

*/


#include <limits.h>
#include <stdlib.h>
#include <math.h>
#include <unistd.h>
#include <sys/wait.h>

#include "vrip.h"
#include "vripGlobals.h"
#include "Mesh.h"
#include "plyio.h"
#include "vripPlyCmds.h"

int
Vrip_FillPlyGapsCmd(ClientData, Tcl_Interp *interp, int argc, char *argv[])
{
    if (argc != 3) {
	interp->result = "Usage: vrip_fillplygaps <file-in> <file-out>";
	return TCL_ERROR;
    }

    Mesh *mesh = readMeshFromPly(argv[1], TRUE, FALSE);

    doConfidence(mesh);

    writePlyFile(argv[2], mesh);

    delete mesh;

    return TCL_OK;
}


int
Vrip_ExtendPlyEdgesCmd(ClientData, Tcl_Interp *interp, int argc, char *argv[])
{
    if (argc != 3) {
	interp->result = "Usage: vrip_extendplyedges <file-in> <file-out>";
	return TCL_ERROR;
    }

    Mesh *mesh = readMeshFromPly(argv[1], FALSE, TRUE);

    doConfidence(mesh);

    writePlyFile(argv[2], mesh);

    delete mesh;

    return TCL_OK;
}


int
Vrip_PlyConfidenceCmd(ClientData, Tcl_Interp *interp, int argc, char *argv[])
{
    if (argc != 3) {
	interp->result = "Usage: vrip_plyconf <file-in> <file-out>";
	return TCL_ERROR;
    }

    Mesh *mesh = readMeshFromPly(argv[1], FALSE, FALSE);

    doConfidence(mesh);    

    writePlyFile(argv[2], mesh);

    delete mesh;

    return TCL_OK;
}


int
Vrip_PlyDepthMapCmd(ClientData, Tcl_Interp *interp, int argc, char *argv[])
{
   float noiseLevel = 0;

   if (argc != 2 && argc != 3) {
      interp->result = "Usage: vrip_plydmap <file-out> [noise_level]";
      return TCL_ERROR;
   }
   
   if (argc == 3) {
      noiseLevel = atof(argv[2]);
   }
   
   theDepthMap->writePly(argv[1], noiseLevel);
   
   return TCL_OK;
}

