/*

Brian Curless

Computer Graphics Laboratory
Stanford University

---------------------------------------------------------------------

Copyright (1997) The Board of Trustees of the Leland Stanford Junior
University. Except for commercial resale, lease, license or other
commercial transactions, permission is hereby given to use, copy,
modify this software for academic purposes only.  No part of this
software or any derivatives thereof may be used in the production of
computer models for resale or for use in a commercial
product. STANFORD MAKES NO REPRESENTATIONS OR WARRANTIES OF ANY KIND
CONCERNING THIS SOFTWARE.  No support is implied or provided.

*/


#include <limits.h>
#include <stdlib.h>
#include <math.h>
#include <unistd.h>
#include <sys/wait.h>

#include "vrip.h"
#include "vripFileCmds.h"
#include "vripGlobals.h"
#include "vripAux.h"


int
Vrip_WriteGridCmd(ClientData, Tcl_Interp *interp, int argc, char *argv[])
{
    if (argc != 2 && argc != 3) {
	interp->result = "Usage: vrip_writegrid <filename>";
	return TCL_ERROR;
    }

    // The third argument is supposed to be something that flags us
    //  not to transpose the grid

    if (argc == 2) {	
	// Unflip the grid
	if (frontRLEGrid->flip) {
	    frontRLEGrid->flip = FALSE;
	    frontRLEGrid->origin[2] = -frontRLEGrid->origin[2];
	}

	// Restore to original untransposed coords
	if (frontRLEGrid->axis != Z_AXIS) {
	   if (frontRLEGrid->axis == X_AXIS) {
	      frontRLEGrid->transposeXZ(backRLEGrid);
	      swapgrids();
	   }
	   else {
	      frontRLEGrid->transposeYZ(backRLEGrid);
	      swapgrids();
	   }

	   frontRLEGrid->axis = Z_AXIS;
	}
    }

    if (!frontRLEGrid->write(argv[1])) {
	interp->result = "vrip_writegrid: could not write file";
	return TCL_ERROR;
    }

    return TCL_OK;
}


int
Vrip_WriteGridNormCmd(ClientData, Tcl_Interp *interp, int argc, char *argv[])
{
    if (argc != 2) {
	interp->result = "Usage: vrip_writegridnorm <filename>";
	return TCL_ERROR;
    }


    // Unflip the grid
    if (frontRLEGridNorm->flip) {
	frontRLEGridNorm->flip = FALSE;
	frontRLEGridNorm->origin[2] = -frontRLEGridNorm->origin[2];
    }

    // Restore to original untransposed coords
    if (frontRLEGridNorm->axis != Z_AXIS) {
       if (frontRLEGridNorm->axis == X_AXIS) {
	  frontRLEGridNorm->transposeXZ(backRLEGridNorm);
	  swapgrids();
       }
       else {
	  frontRLEGridNorm->transposeYZ(backRLEGridNorm);
	  swapgrids();
       }

       frontRLEGridNorm->axis = Z_AXIS;
    }


    if (!frontRLEGridNorm->write(argv[1])) {
	interp->result = "vrip_writegridnorm: could not write file";
	return TCL_ERROR;
    }

    return TCL_OK;
}


int
Vrip_WriteDenCmd(ClientData, Tcl_Interp *interp, int argc, char *argv[])
{
    if (argc != 2) {
	interp->result = "Usage: vrip_writeden <filename>";
	return TCL_ERROR;
    }
    
    theGrid->writeDen(argv[1]);

    return TCL_OK;
}


int
Vrip_ReadGridCmd(ClientData, Tcl_Interp *interp, int argc, char *argv[])
{
    int maxDim;

    if (argc != 2) {
	interp->result = "Usage: vrip_readgrid <filename>";
	return TCL_ERROR;
    }

    if (frontRLEGrid == NULL) {
	frontRLEGrid = new OccGridRLE(50,50,50,CHUNK_SIZE);
	backRLEGrid = new OccGridRLE(50,50,50,CHUNK_SIZE);
    }
    
    if (!frontRLEGrid->read(argv[1])) {
	interp->result = "vrip_readgrid: could not read file";
	return TCL_ERROR;
    }

    // Don't delete - re-use!!

    delete backRLEGrid;


    backRLEGrid = new OccGridRLE(frontRLEGrid->xdim, frontRLEGrid->ydim,
			       frontRLEGrid->zdim, CHUNK_SIZE);
    backRLEGrid->resolution = frontRLEGrid->resolution;
    backRLEGrid->origin[0] = frontRLEGrid->origin[0];
    backRLEGrid->origin[1] = frontRLEGrid->origin[1];
    backRLEGrid->origin[2] = frontRLEGrid->origin[2];

    if (theDepthMap != NULL) {
	delete theDepthMap;
    }

    maxDim = MAX(frontRLEGrid->xdim, MAX(frontRLEGrid->ydim, 
					 frontRLEGrid->zdim));
    theDepthMap = new DepthMap(int(maxDim*2.2), 
			       int(maxDim*2.2), 
			       FALSE, DEPTH_TREE_GRANULARITY);

    return TCL_OK;
}

