# LIF1.0
# Lightfield library, version 1.0
#
# Copy and modify this file to describe a set of images for
# generating a light field.
#
# Any line beginning with '#' is a comment.
#
# The light field is made up of "slabs".  Each slab is
# a regular array of images, taken from regular intervals 
# on a uv plane, looking at an st plane.
#

# ==================== begin slab specification ====================
#
# The first line gives the slab number (each number must be unique,
# and less than LF_MAXSLABS (currently 30).  It also lists the
# basename for the array of images.  For example, the line
# 	SLAB		0 data/lion
# would tell the program to look in the data directory for files
# of the format "lion.u.v.rgb", i.e.
# lion.0.0.rgb, lion.0.1.rgb, ..., lion.16.16.rgb, etc.

SLAB		0 dragon8/dragon

# These next four lines describe the location of the uv plane.  
# Each line describes one vertex of the quadrilateral.  The first
# four numbers of each line give the x,y,z,w coordinates of the
# corner vertex, and the last two numbers give texture coordinates,
# describing how to map u and v to the quadrilateral.  
#
# The four vertices should be coplanar.

# Note that the W coordinate is 0.0.  This places the uv plane
# at infinity, creating an orthographic projection for each 
# source (.rgb) image.
SLAB_UV
		-1000 -1000 1000 0.0   0 0
		 1000 -1000 1000 0.0   1 0
		 1000  1000 1000 0.0   1 1
		-1000  1000 1000 0.0   0 1

# These next four lines describe the location of the st plane.  
# Each line describes one vertex of the quadrilateral.  The first
# four numbers of each line give the x,y,z,w coordinates of the
# corner vertex, and the last two numbers give texture coordinates,
# describing how to map u and v to the quadrilateral.
#
# The four vertices should be coplanar.

SLAB_ST
		-0.5 -0.5 0.0 1.0   0 0 
		 0.5 -0.5 0.0 1.0   1 0 
		 0.5  0.5 0.0 1.0   1 1 
		-0.5  0.5 0.0 1.0   0 1 


# This line describes the dimensions of the light field array in
# u and v. (i.e. the size of the array of images.)

SAMPLES_UV	8 8

# This line describes the dimensions of the light field array in
# s and t. (i.e. the size of each image (in pixels)).

SAMPLES_ST	256 256

# This line describes the format of the images.

FORMAT		RGB

# -------------------- end of slab 0 --------------------
