#!/usr/sbin/perl

$level_begin = 0;
$level_beginmask = 0;
$level_start[0] = 0;
$level_cur[0] = 0;
$level_inc[0] = 1;

LOOP:
while (<>) {
	chop;
	if  (/^\s*$/)  {
		# empty lines
		next LOOP;
	}

	if  (/^#.*$/)  {
		# comments
		next LOOP;
	}

	if  (/^\s*end\s*$/) {
		# ends
		! $level_begin && die "Unmatched end";
		if  ($level_marker[$level_begin] ne " ")  {
			$fmt_str = sprintf("%%%ds", ($level_begin-1)*4);
			$blanks = sprintf($fmt_str, "");
			print "/* ", $blanks,  "END: ", $level_marker[$level_begin], " */\n";
		}
		$level_begin--;
		print "\n";
		next LOOP;
	}

	if  (/^\s*endmask\s*$/) {
		# endmasks
		! $level_beginmask && die "Unmatched endmask";
		$level_beginmask--;
		if  ($mask_marker ne " ")  {
			print "/* ", "ENDMASK: ", $mask_marker, " */\n";
		}
		print "\n";
		next LOOP;
	}

	if  (/^\s*beginmask(.*)$/) {
		# beginmasks
		$level_beginmask >= 1 && die "Cannot handle recursive beginmask/endmask yet";
		$level_beginmask++;

		$_ = $1;
		# test refs
		if  (/ref#\s*([^\s#][^#]+[^\s#])\s*#/) {
			$mask_marker = $1;
			print "/* ", "BEGINMASK: ", $mask_marker, " */\n";
		}
		else {
			$mask_marker = " ";
		}
		$bit = 0;
		next LOOP;
	}

	if  (/^\s*begin(.*)$/) {
		# begins
		$_ = $1;
		$level_begin++;
		# test starts in number form
		if  (/start#\s*(\d*)\s*#(.*)/) {
			$level_start[$level_begin] = $level_cur[$level_begin] = $1;
			$_ = $2;
		}
		# test starts in string form
		if  (/start#\s*([^\s#][^#]+[^\s#])\s*#(.*)/)  {
			! $references{$1} && die $1, " not defined previously";
			$level_start[$level_begin] = $level_cur[$level_begin] = $references{$1};
			$_ = $2
		}
		else {
			$level_start[$level_begin] = $level_cur[$level_begin] = $level_cur[$level_begin-1];
			$level_cur[$level_begin-1] += $level_inc[$level_begin-1];
		}
		# test incs
		if  (/inc#(\d+)#(.*)/) {
			$level_inc[$level_begin] = $1;
			$_ = $2;
		}
		else {
			$level_inc[$level_begin] = 1;
		}
		# test refs
		if  (/ref#\s*([^\s#][^#]+[^\s#])\s*#/) {
			$references{$1} && die "Multiple references on ", $1;
			$references{$1} = $level_cur[$level_begin];
			$level_marker[$level_begin] = $1;
			$fmt_str = sprintf("%%%ds", ($level_begin-1)*4);
			$blanks = sprintf($fmt_str, "");
			print "/* ", $blanks,  "BEGIN: ", $1, " */\n";
		}
		else {
			$level_marker[$level_begin] = " ";
		}
		next LOOP;
	}

	if  ($level_beginmask && /^\s+(\w.*)$/) {
		($defname, $masks) = split(/\s+/, $1);
		$defined{$defname} && die "Multiple defines on ", $defname;
		$_ = $masks;
		$fmt_str = sprintf("#define %s ", $defname);
		if  (/offset/) {
			$defined{$defname} = $bit;
		}
		elsif  (/or#([\w|]+)#/)  {
			@constant_list = split(/\|/, $1);
			$defined{$defname} = 0;
			foreach $constant (@constant_list) {
				! $defined{$constant} && die $constant " not defined";
				$defined{$defname} |= $defined{$constant};
			}
		}
		elsif  (/([+-]?\d+)/)  {
			$new_bit = $bit + $1;
			$defined{$defname} = (1 << $new_bit) - (1 << $bit);
			$bit = $new_bit;
		}
		else {
			$new_bit = $bit + 1;
			$defined{$defname} = (1 << $new_bit) - (1 << $bit);
			$bit = $new_bit;
		}
		printf("%-32s0x%08x\n", $fmt_str, $defined{$defname});
		next LOOP;
	}

	if  ($level_begin && /^\s+(\w.*)$/) {
		($defname, $index) = split(/\s+/, $1);
		if  ($defined{$defname})  {
			print "/*\t", $defname, " */\n";
			next LOOP;
		}
		$_ = $index;
		if  (/offset/) {
			$defined{$defname} = $level_cur[$level_begin] - $level_start[$level_begin];
		}
		elsif  (/([+-]?\d+)/)  {
			$defined{$defname} = $1;
		}
		elsif  (/(\w+)/) {
			! $defined{$1} && die $1, "not defined previously";
			$defined{$defname} = $defined{$1};
		}
		else {
			$defined{$defname} = $level_cur[$level_begin];
			$level_cur[$level_begin] += $level_inc[$level_begin];
		}
		printf "#define\t%-23s 0x%03x\n", $defname, $defined{$defname};
		next LOOP;
	}

	die "Unrecognized line:", $_;
}
