#!/usr/sbin/perl

READ_INCLUDES:
while (@ARGV) {
	$file = shift @ARGV;
	if  ($file eq "-l")  {
		$read_libs = 1;
		last READ_INCLUDES;
	}
	$gen_files .= $file . ' ';
	$include_files .= $file . ' ';
	open(FILE, $file) || die "Could not open $file\n";
	while (<FILE>)  {
		if  (/^#include\s+["<]([^">]+)[">]/)  {
			$include_files .= $1 . ' ';
		}
		if  (/\/\*BEGIN:C\+\+TOC\*\//)  {
			if  ($in_prototype)  {
				die "Cannot handle nested BEGIN:C++TOC\n";
			}
			$in_prototype = 1;
			$/ = ";";
			$* = 1;
		}
		if  ($in_prototype && /extern\s+([^\(]+)\(([^;]+)\);/) {
			$func_head = $1;
			$func_body = $2;
			@func_name_parts = split(/\s+/, $1);
			$_ = pop(@func_name_parts);
			/(\w+)/ || die "Illegal syntax\n";
			$func = $1;
			$func_head{$func} = $func_head;
			$func_body{$func} = $func_body;
			push(@proto_funcs, $func);
		}
		if  (/\/\*END:C\+\+TOC]*\//)  {
			if  (! $in_prototype)  {
				die "unmatched END:C++TOC\n";
			}
			$in_prototype = 0;
			$/ = "\n";
			$* = 0;
		}
	}
}

! $read_libs && die "No library files\n";

while (@ARGV) {
	$file = shift @ARGV;
	open(FILE, "nm $file |") || die "Could not find $file\n";
	while (<FILE>)  {
		foreach $func (@proto_funcs) {
			if  (/\b(${func}\w*)\b/)  {
				$corresponds{$func} &&
				$corresponds{$func} ne $1 &&
				die "Multiple symbols for $func";
				$corresponds{$func} = $1;
			}
		}
	}
}

print "/*DON'T EDIT THIS FILE, IT'S AUTO_GENERATED BY*/\n/*c++2c.perl and ", $gen_files, "*/\n\n\n";
@included_files = split(' ', $include_files);
foreach $headfile (@included_files) {
	print "#include \"", $headfile, "\"\n";
}
print "\n\n";

foreach $func (sort keys(%corresponds)) {
	print $func_head{$func}, "(", $func_body{$func}, ")\n";
	print "{\n";
	@func_head_parts = split(/\s+/, $func_head{$func});
	$_ = pop(@func_head_parts); 
	s/$func/$corresponds{$func}/;
	push(@func_head_parts, $_);
	$func_head = join(' ', @func_head_parts);
	print "\textern ", $func_head, "(", $func_body{$func}, ");\n\n";
	$func_type = shift(@func_head_parts);
	if  ($func_type eq "void") {
		print "\t", $corresponds{$func}, "(";
	}
	else {
		print "\treturn ", $corresponds{$func}, "(";
	}
	@params_list = split(/\s*,\s*/, $func_body{$func});
	$first_param = 1;
	foreach $param (@params_list)  {
		@param_parts = split(/\s+/, $param);
		$param_name = pop(@param_parts);
		if  ($first_param)  {
			$first_param = 0;
		}
		else  {
			print ", ";
		}
		$_ = $param_name;
		/(\w+)/ || die "Inlegal syntax\n";
		print $1;
	}
	print ");\n}\n\n";
}

