#ifdef NEW_HANDLER
#include <new.h>
#endif

#include <stream.h>
#include "error.h"
#include "perf.h"
#include "dataseq.h"
#include "codevec.h"
#include "vq.h"
#include "tvq.h"

extern "C" double atof(const char*);
extern "C" void signal(int,void (*)());

char Usage[] = "Usage: vq init.vq source.dat \
[-c final.vq] [-q reproduction.qnt] \
\n";

VQ* vqp;			// pointer to vector quantizer
char* vqfilename = 0;		// default to no training
char* qntfilename = 0;		// default to no quantization
double PERF::lambda = 0;	// default to fixed rate
int fillEmptyCellsFlag = 0;     // default to don't fill empty cells

#ifdef NEW_HANDLER
void freeStoreException() { cerr<<"free store exhausted!\n"; exit(1); }
#endif
// void Handler() { cerr<<"Saving..."; vqp->put(vqfilename); cerr<<"Done\n"; }
void Handler() { vqp->put(vqfilename); }

int main(int argc, char* argv[]) {

#ifdef NEW_HANDLER
set_new_handler(freeStoreException);
#endif

    // Read command line.
    if (argc < 3) Error(Usage);
    for (int i=3; i<argc; i++) {
	if (argv[i][0] != '-') Error(Usage);
	switch (argv[i][1]) {
	case 'c':
	    vqfilename = argv[++i];
	    break;
	case 'q':
	    qntfilename = argv[++i];
	    break;
	default:
	    Error(Usage);
	    }
	}

    // Read vq and source files.
    vqp = new_VQ(argv[1]);	// also sets dim (needed in next line)
    DATASEQ ds(argv[2]);	// also sets N (number of source vecs)

    // Train vq if necessary.
    if (vqfilename) {
	signal(2,Handler);	// write out codebook on signal 2 (INT)
	vqp->train(ds);
	vqp->put(vqfilename);
	}

    // Test performance of source on vq.
    PERF perf = vqp->test(ds);
    cout << "Distortion: " << perf.dist/N;
    cout << " Rate: " << perf.rate/N;
    cout << " Lambda: " << perf.lambda << "\n";

    // Quantize source if necessary.
    if (qntfilename) {
	vqp->quantize(ds);
	WriteData(qntfilename);
	}

    delete vqp;
    return 0;
    }
