#ifndef perf_h
#define perf_h

class PERF {
public:
    double dist;
    double rate;
    static double lambda;
    PERF() { dist=0; rate=0; }
    PERF(double d, double r=0) { dist=d; rate=r; }
    PERF(const PERF& p) { dist=p.dist; rate=p.rate; }
    operator double() const { return dist + lambda*rate; }
    PERF& operator+=(const PERF& p);
    PERF& operator-=(const PERF& p);
    friend PERF operator+(PERF p, PERF q);
    friend PERF operator-(PERF p);
    };

inline PERF& PERF::operator+=(const PERF& p)
    { dist+=p.dist; rate+=p.rate; return *this; }

inline PERF& PERF::operator-=(const PERF& p)
    { dist-=p.dist; rate-=p.rate; return *this; }

inline PERF operator+(PERF p, PERF q)
    { return PERF(p.dist+q.dist,p.rate+q.rate); }

inline PERF operator-(PERF p)
    { p.dist = -p.dist; p.rate = -p.rate; return p; }

#endif
