#ifndef dataseq_h
#define dataseq_h

#include <stream.h>

class DATAVEC;				// forward reference
class DATABLK;				// forward reference
class DATASEQ;				// forward reference

class DATASEQ {
public:
    DATABLK* head;			// pointer to first datablk
    DATABLK* tail;			// pointer to last datablk

    DATASEQ() { head=tail=0; }		// constructor
    DATASEQ::DATASEQ(const unsigned char *, int);
    DATASEQ(const DATABLK&, long);	// constructor
    DATASEQ(const DATASEQ&, long);	// constructor
    DATASEQ(const char* filename);	// constructor
    ~DATASEQ();				// destructor

    DATABLK* pop();			// pop
    void push(DATABLK*);		// push
    DATASEQ& operator+=(DATASEQ&);	// append
    };

class DATABLK {
public:
    DATABLK* next;			// link to next block in sequence
    DATAVEC* loc;			// pointer to first datavec in block
    long width;				// width of block (in datavecs)

    DATABLK(DATAVEC* l=0, long w=0)	{ next=0; loc=l; width=w; }
    };

#endif
