#include <stream.h>
#include "error.h"
#include "dataseq.h"
#include "codevec.h"

/*
 * Construct a DATASEQ from an array of data
 */
DATASEQ::DATASEQ(const unsigned char *data_array, int size)
{
    head = tail = 0;
    ReadData(data_array, size, *this);
}

/*
 *  Construct a DATASEQ from subblocks of a DATABLK.
 */
DATASEQ::DATASEQ(const DATABLK& db, long width) {

    head = tail = 0;
    for (long w=0; w+width<=db.width; w+=width)
	push(new DATABLK(db.loc+w,width));
    }

/*
 *  Construct a DATASEQ from subblocks of the DATABLKs of another DATASEQ.
 */
DATASEQ::DATASEQ(const DATASEQ& ds, long width) {

    head = tail = 0;
    for (DATABLK* dbp=ds.head; dbp; dbp=dbp->next)
	for (long w=0; w+width<=dbp->width; w+=width)
	    push(new DATABLK(dbp->loc+w,width));
    }

/*
 *  Destruct the DATASEQ.
 */
DATASEQ::~DATASEQ() {

    while (head) {
	DATABLK* tmp = head;
	head = tmp->next;
	delete tmp;
	}
    tail = 0;
    }

/*
 *  Pop a DATABLK off the stack.
 */
DATABLK* DATASEQ::pop() {

    if (head==0) Error("DATASEQ: can't pop empty stack");
    DATABLK* tmp = head;
    head = tmp->next;
    if (head==0) tail = 0;
    return tmp;
    }

/*
 *  Push a DATABLK onto the stack.
 */
void DATASEQ::push(DATABLK* dbp) {

    DATABLK* tmp = head;
    head = dbp;
    dbp->next = tmp;
    if (tmp==0) tail = head;
    }

/*
 *  Append a DATASEQ to the stack.
 */
DATASEQ& DATASEQ::operator+=(DATASEQ& ds) {

    if (tail) tail->next = ds.head;
    if (ds.tail) tail = ds.tail;
    if (head==0) head = ds.head;
    ds.head = ds.tail = 0;
    return *this;
    }
