#ifndef codevec_h
#define codevec_h

#include <stream.h>
#include "perf.h"
#include "vq.h"
// this has to be chnaged for different data types

typedef unsigned char DATATYPE;	// datatype of each component of DATAVEC
typedef short CODETYPE;	// datatype of each component of CODEVEC
inline CODETYPE round(double d) { return CODETYPE(d+0.5); } // integer CODETYPE
// inline CODETYPE round(double d) { return CODETYPE(d); } // real CODETYPE

const int MAXDIM = 64;	// for simplicity, compile in this constant

class CODEVEC;		// forward reference

class DATAVEC {
private:
    DATATYPE vec[MAXDIM];
public:
    friend CODEVEC;
    friend void ReadData(const unsigned char *, int, DATASEQ&);
    };

class CODEVEC: public VQ {
private:
    CODETYPE vec[MAXDIM];
public:
    double dist(const DATAVEC&) const;

    // Functions needed for a generic VQ:
    CODEVEC() { }
    CODEVEC(istream& is) { get(is); }
    CODEVEC(const CODEVEC&);
    ~CODEVEC();
    void train(const DATASEQ&, double precision=EPSILON);
    PERF test(const DATABLK&) const;
    VQ*  copy() const;
    void get(istream&);
    void put(ostream&) const;
    };

#endif
