/* lerp.h:
 * Macros for doing linear interpolation operations.
 */

static	v0_temp, v2_temp;

#define BILERP(v0,v1,v2,v3,fx,fy,fxbits,fybits)\
	(v0_temp = (int)v0 + ((fx * ((int)v1-(int)v0)) >> fxbits),\
	 v2_temp = (int)v2 + ((fx * ((int)v3-(int)v2)) >> fxbits),\
	 v0_temp + (fy * ((v2_temp-v0_temp)) >> fybits))

/* stuff for uncompressed lightfield */
#define	LIGHTPTR(u,v,s,t)\
	(lightfield + uindex[u]+vindex[v]+sindex[s]+tindex[t] + \
	 vqtile_uindex[u]+vqtile_vindex[v]+vqtile_sindex[s]+vqtile_tindex[t])

#define QUADLERPRGB(u,v,s,t,fu,fv,fs,ft,imgp)\
	p00 = LIGHTPTR(u,v,s,t);\
	p10 = LIGHTPTR(u,v,s+1,t);\
	p01 = LIGHTPTR(u,v,s,t+1);\
	p11 = LIGHTPTR(u,v,s+1,t+1);\
	c00.r = BILERP(p00->r,p10->r,p01->r,p11->r,fs,ft,frac_sbits,frac_tbits);\
	c00.g = BILERP(p00->g,p10->g,p01->g,p11->g,fs,ft,frac_sbits,frac_tbits);\
	c00.b = BILERP(p00->b,p10->b,p01->b,p11->b,fs,ft,frac_sbits,frac_tbits);\
	\
	p00 = LIGHTPTR(u+1,v,s,t);\
	p10 = LIGHTPTR(u+1,v,s+1,t);\
	p01 = LIGHTPTR(u+1,v,s,t+1);\
	p11 = LIGHTPTR(u+1,v,s+1,t+1);\
	c10.r = BILERP(p00->r,p10->r,p01->r,p11->r,fs,ft,frac_sbits,frac_tbits);\
	c10.g = BILERP(p00->g,p10->g,p01->g,p11->g,fs,ft,frac_sbits,frac_tbits);\
	c10.b = BILERP(p00->b,p10->b,p01->b,p11->b,fs,ft,frac_sbits,frac_tbits);\
	\
	p00 = LIGHTPTR(u,v+1,s,t);\
	p10 = LIGHTPTR(u,v+1,s+1,t);\
	p01 = LIGHTPTR(u,v+1,s,t+1);\
	p11 = LIGHTPTR(u,v+1,s+1,t+1);\
	c01.r = BILERP(p00->r,p10->r,p01->r,p11->r,fs,ft,frac_sbits,frac_tbits);\
	c01.g = BILERP(p00->g,p10->g,p01->g,p11->g,fs,ft,frac_sbits,frac_tbits);\
	c01.b = BILERP(p00->b,p10->b,p01->b,p11->b,fs,ft,frac_sbits,frac_tbits);\
	\
	p00 = LIGHTPTR(u+1,v+1,s,t);\
	p10 = LIGHTPTR(u+1,v+1,s+1,t);\
	p01 = LIGHTPTR(u+1,v+1,s,t+1);\
	p11 = LIGHTPTR(u+1,v+1,s+1,t+1);\
	c11.r = BILERP(p00->r,p10->r,p01->r,p11->r,fs,ft,frac_sbits,frac_tbits);\
	c11.g = BILERP(p00->g,p10->g,p01->g,p11->g,fs,ft,frac_sbits,frac_tbits);\
	c11.b = BILERP(p00->b,p10->b,p01->b,p11->b,fs,ft,frac_sbits,frac_tbits);\
	\
	imgp->r = BILERP(c00.r,c10.r,c01.r,c11.r,fu,fv,frac_ubits,frac_vbits);\
	imgp->g = BILERP(c00.g,c10.g,c01.g,c11.g,fu,fv,frac_ubits,frac_vbits);\
	imgp->b = BILERP(c00.b,c10.b,c01.b,c11.b,fu,fv,frac_ubits,frac_vbits)

/* Used by fast version of code that performs uv bilerping only */
#define BILERPUVRGB(u,v,s,t,fu,fv,imgp)\
	p00 = LIGHTPTR(u,v,s,t);\
	p10 = LIGHTPTR(u+1,v,s,t);\
	p01 = LIGHTPTR(u,v+1,s,t);\
	p11 = LIGHTPTR(u+1,v+1,s,t);\
	imgp->r = BILERP(p00->r,p10->r,p01->r,p11->r,fu,fv,frac_ubits,frac_vbits);\
	imgp->g = BILERP(p00->g,p10->g,p01->g,p11->g,fu,fv,frac_ubits,frac_vbits);\
	imgp->b = BILERP(p00->b,p10->b,p01->b,p11->b,fu,fv,frac_ubits,frac_vbits)

/* Used by fast version of code that performs st bilerping only */
#define BILERPSTRGB(u,v,s,t,fs,ft,imgp)\
	p00 = LIGHTPTR(u,v,s,t);\
	p10 = LIGHTPTR(u,v,s+1,t);\
	p01 = LIGHTPTR(u,v,s,t+1);\
	p11 = LIGHTPTR(u,v,s+1,t+1);\
	imgp->r = BILERP(p00->r,p10->r,p01->r,p11->r,fs,ft,frac_sbits,frac_tbits);\
	imgp->g = BILERP(p00->g,p10->g,p01->g,p11->g,fs,ft,frac_sbits,frac_tbits);\
	imgp->b = BILERP(p00->b,p10->b,p01->b,p11->b,fs,ft,frac_sbits,frac_tbits)

/* Used by fast version of code that performs point sampling only */
#define POINTSAMPLERGB(u,v,s,t,imgp)\
	p00 = LIGHTPTR(u,v,s,t);\
	imgp->r = p00->r;\
	imgp->g = p00->g;\
	imgp->b = p00->b

/* stuff for vq */
#define	VQLIGHTPTR(u,v,s,t)\
	(codebook + \
	 (lightfield[uindex[u]+vindex[v]+sindex[s]+tindex[t]]<<tile_shift) + \
	 vqtile_uindex[u]+vqtile_vindex[v]+vqtile_sindex[s]+vqtile_tindex[t])

#define QUADLERPVQRGB(u,v,s,t,fu,fv,fs,ft,imgp)\
	p00 = VQLIGHTPTR(u,v,s,t);\
	p10 = VQLIGHTPTR(u,v,s+1,t);\
	p01 = VQLIGHTPTR(u,v,s,t+1);\
	p11 = VQLIGHTPTR(u,v,s+1,t+1);\
	c00.r = BILERP(p00->r,p10->r,p01->r,p11->r,fs,ft,frac_sbits,frac_tbits);\
	c00.g = BILERP(p00->g,p10->g,p01->g,p11->g,fs,ft,frac_sbits,frac_tbits);\
	c00.b = BILERP(p00->b,p10->b,p01->b,p11->b,fs,ft,frac_sbits,frac_tbits);\
	\
	p00 = VQLIGHTPTR(u+1,v,s,t);\
	p10 = VQLIGHTPTR(u+1,v,s+1,t);\
	p01 = VQLIGHTPTR(u+1,v,s,t+1);\
	p11 = VQLIGHTPTR(u+1,v,s+1,t+1);\
	c10.r = BILERP(p00->r,p10->r,p01->r,p11->r,fs,ft,frac_sbits,frac_tbits);\
	c10.g = BILERP(p00->g,p10->g,p01->g,p11->g,fs,ft,frac_sbits,frac_tbits);\
	c10.b = BILERP(p00->b,p10->b,p01->b,p11->b,fs,ft,frac_sbits,frac_tbits);\
	\
	p00 = VQLIGHTPTR(u,v+1,s,t);\
	p10 = VQLIGHTPTR(u,v+1,s+1,t);\
	p01 = VQLIGHTPTR(u,v+1,s,t+1);\
	p11 = VQLIGHTPTR(u,v+1,s+1,t+1);\
	c01.r = BILERP(p00->r,p10->r,p01->r,p11->r,fs,ft,frac_sbits,frac_tbits);\
	c01.g = BILERP(p00->g,p10->g,p01->g,p11->g,fs,ft,frac_sbits,frac_tbits);\
	c01.b = BILERP(p00->b,p10->b,p01->b,p11->b,fs,ft,frac_sbits,frac_tbits);\
	\
	p00 = VQLIGHTPTR(u+1,v+1,s,t);\
	p10 = VQLIGHTPTR(u+1,v+1,s+1,t);\
	p01 = VQLIGHTPTR(u+1,v+1,s,t+1);\
	p11 = VQLIGHTPTR(u+1,v+1,s+1,t+1);\
	c11.r = BILERP(p00->r,p10->r,p01->r,p11->r,fs,ft,frac_sbits,frac_tbits);\
	c11.g = BILERP(p00->g,p10->g,p01->g,p11->g,fs,ft,frac_sbits,frac_tbits);\
	c11.b = BILERP(p00->b,p10->b,p01->b,p11->b,fs,ft,frac_sbits,frac_tbits);\
	\
	imgp->r = BILERP(c00.r,c10.r,c01.r,c11.r,fu,fv,frac_ubits,frac_vbits);\
	imgp->g = BILERP(c00.g,c10.g,c01.g,c11.g,fu,fv,frac_ubits,frac_vbits);\
	imgp->b = BILERP(c00.b,c10.b,c01.b,c11.b,fu,fv,frac_ubits,frac_vbits)

/* Used by fast version of code that performs uv bilerping only */
#define BILERPUVVQRGB(u,v,s,t,fu,fv,imgp)\
	p00 = VQLIGHTPTR(u,v,s,t);\
	p10 = VQLIGHTPTR(u+1,v,s,t);\
	p01 = VQLIGHTPTR(u,v+1,s,t);\
	p11 = VQLIGHTPTR(u+1,v+1,s,t);\
	imgp->r = BILERP(p00->r,p10->r,p01->r,p11->r,fu,fv,frac_ubits,frac_vbits);\
	imgp->g = BILERP(p00->g,p10->g,p01->g,p11->g,fu,fv,frac_ubits,frac_vbits);\
	imgp->b = BILERP(p00->b,p10->b,p01->b,p11->b,fu,fv,frac_ubits,frac_vbits)

/* Used by fast version of code that performs st bilerping only */
#define BILERPSTVQRGB(u,v,s,t,fs,ft,imgp)\
	p00 = VQLIGHTPTR(u,v,s,t);\
	p10 = VQLIGHTPTR(u,v,s+1,t);\
	p01 = VQLIGHTPTR(u,v,s,t+1);\
	p11 = VQLIGHTPTR(u,v,s+1,t+1);\
	imgp->r = BILERP(p00->r,p10->r,p01->r,p11->r,fs,ft,frac_sbits,frac_tbits);\
	imgp->g = BILERP(p00->g,p10->g,p01->g,p11->g,fs,ft,frac_sbits,frac_tbits);\
	imgp->b = BILERP(p00->b,p10->b,p01->b,p11->b,fs,ft,frac_sbits,frac_tbits)

/* Used by fast version of code that performs point sampling only */
#define POINTSAMPLEVQRGB(u,v,s,t,imgp)\
	p00 = VQLIGHTPTR(u,v,s,t);\
	imgp->r = p00->r;\
	imgp->g = p00->g;\
	imgp->b = p00->b

