/*
 * irisgl_driver.c
 *
 * driver functions for IrisGL
 */
#include <gl.h>
#include "lightfield.h"

/* Pixelzoom allows the final image to be scaled up, so that it
 * is bigger (more visible) on the screen.
 */
float pixelzoom = 2.0;

/* function to get current transformation information */
void
irisgl_get_transform(Matrix4 mat_model, Matrix4 mat_proj,
	int *x, int *y, int *width, int *height)
{
    Screencoord left, right, bottom, top;

    mmode(MVIEWING);
    getmatrix(mat_model);
    TRANSMAT4(mat_model, mat_model);

    mmode(MPROJECTION);
    getmatrix(mat_proj);
    TRANSMAT4(mat_proj, mat_proj);

    getviewport(&left, &right, &bottom, &top);
    /* Adjust size for pixel scaling. */
    left /= pixelzoom;
    right /= pixelzoom;
    top /= pixelzoom;
    bottom /= pixelzoom;
    *x = left;
    *y = bottom;
    *width  = right - left + 1;
    *height = top - bottom + 1;
}

/* function to draw stuff into current framebuffer */
void
irisgl_write_pixrect(int x, int y, int w, int h,
	int format, int type, void *pixels)
{
  rectzoom(pixelzoom, pixelzoom);
  lrectwrite(x, y, (x+w-1), 
	     (y+h-1), pixels);
}

LFDriver irisgl_driver = {
    irisgl_get_transform,
    irisgl_write_pixrect,
};

LFDriver *__lf_driver = &irisgl_driver;
