/*
 * intersect.c
 */
#include <stdio.h>
#include <stdlib.h>
#include <math.h>
/* #include <gl.h> */
#include "lightfield.h"

#define	OROURKE_1_EPS	2
#define	WIN_1		1.0001
#define	HOMO_EPS	1e-6f

#define	SINGULAR_UV1	1
#define	SINGULAR_UV2	2
#define	SINGULAR_ST	3

static bool_t
evalInsideOutput(float *v, float plane[4])
{
    return DOTVEC4(v, plane) >= 0.f;
}

/* copy both clip coordinates and s & t coordinates */
static void
copyVertex(float *s, float *d)
{
    COPYVEC4(s+0, d+0);
    COPYVEC2(s+4, d+4);
}

/* clipping routine */
void
clipEdge(float *s1p, float *s2p, float plane[4], float *dp)
{
    float v1 = DOTVEC4(s1p, plane);
    float v2 = DOTVEC4(s2p, plane);
    float a = v2 / (v2 - v1);
    float a_1 = 1.f - a;

    INTERP4(s1p+0, s2p+0, a, a_1, dp+0);
    INTERP2(s1p+4, s2p+4, a, a_1, dp+4);
    if  (plane[2] == 1.f && plane[3] == 1.f) {
	if  (dp[3] >= 0.f)
	    dp[2] = -dp[3];
	else
	    dp[3] = -dp[2];
    }
}

/* routine to clip a quad against the intersection of a # of half-planes */
static int
clipFrustum(LFVtx quad[4], float (*planes)[4], int nplanes, LFVtx *poly)
{
    LFVtx polys[2][10];
    float *polys_p[2][10];
    int polys_cnt[2];
    int i;
    bool_t pingpong = 0;

    for ( i=0 ; i<10 ; i++ ) {
	polys_p[0][i] = &(polys[0][i].x);
	polys_p[1][i] = &(polys[1][i].x);
    }

    for ( i=0 ; i<4 ; i++ ) {
	COPYVEC4(&quad[i].x, &polys[pingpong][i].x);
	COPYVEC2(&quad[i].s, &polys[pingpong][i].s);
    }
    polys_cnt[pingpong] = 4;

    for ( i=0 ; i<nplanes ; i++,planes++ ) {
	polys_cnt[!pingpong] = geom3dPlaneClipPolygon(
		polys_p[pingpong], polys_cnt[pingpong],
		*planes, evalInsideOutput, copyVertex,
		clipEdge, polys_p[!pingpong]);
	pingpong = !pingpong;
    }

    for ( i=0 ; i<polys_cnt[pingpong] ; i++ ) {
	COPYVEC4(&polys[pingpong][i].x, &poly[i].x);
	COPYVEC2(&polys[pingpong][i].s, &poly[i].s);
    }
    return polys_cnt[pingpong];
}

static void
unhomogenizeScreenVtx(LFVtx *v)
{
    v->w  = 1.f / v->w;
    v->x *= v->w;
    v->y *= v->w;
    v->z *= v->w;
    v->s *= v->w;
    v->t *= v->w;
}

#define	BARYCENTRIC_INTERP3(x0, x1, x2, a1, a2, x)	\
	x = (x0) + (a1) * ((x1)-(x0)) + (a2) * ((x2)-(x0))

static void
clipEvaluate(LFVtx *uv_clip, LFVtx *st_clip,
	float (*xy)[2], int ninter, LFScreenVtx *poly)
{
    LFVtx *uv0 = &uv_clip[0];
    LFVtx *uv1 = &uv_clip[1];
    LFVtx *uv2 = &uv_clip[2];
    LFVtx *st0 = &st_clip[0];
    LFVtx *st1 = &st_clip[1];
    LFVtx *st2 = &st_clip[2];
    float area_uv_1, area_st_1;
    float scr_a1, scr_a2;
    int vtx_i;

    /*
     * unhomogenize vertices so that w is really 1/w, s is really s/w,
     * t is really t/w, z is really z/w
     */
    for ( vtx_i=0 ; vtx_i<3 ; vtx_i++ )  {
	if  (uv_clip[vtx_i].w != 1.f)
	    unhomogenizeScreenVtx(&uv_clip[vtx_i]);
	if  (st_clip[vtx_i].w != 1.f)
	    unhomogenizeScreenVtx(&st_clip[vtx_i]);
    }

    area_uv_1 = 1.f / AREA_PNT2(&uv0->x, &uv1->x, &uv2->x);
    area_st_1 = 1.f / AREA_PNT2(&st0->x, &st1->x, &st2->x);
    for ( vtx_i=0 ; vtx_i<ninter ; vtx_i++,xy++,poly++ ) {
	/* compute barycentric coordinates corresponding to UV quad */
	scr_a1 = AREA_PNT2(xy[0], &uv2->x, &uv0->x) * area_uv_1;
	scr_a2 = AREA_PNT2(xy[0], &uv0->x, &uv1->x) * area_uv_1;

	/* compute w, z1, u, v */
	BARYCENTRIC_INTERP3(uv0->w, uv1->w, uv2->w, scr_a1, scr_a2, poly->w);
	BARYCENTRIC_INTERP3(uv0->z, uv1->z, uv2->z, scr_a1, scr_a2, poly->z1);
	BARYCENTRIC_INTERP3(uv0->s, uv1->s, uv2->s, scr_a1, scr_a2, poly->u);
	BARYCENTRIC_INTERP3(uv0->t, uv1->t, uv2->t, scr_a1, scr_a2, poly->v);

	/* compute barycentric coordinates corresponding to ST quad */
	scr_a1 = AREA_PNT2(xy[0], &st2->x, &st0->x) * area_st_1;
	scr_a2 = AREA_PNT2(xy[0], &st0->x, &st1->x) * area_st_1;

	/* compute q, z2, s, t */
	BARYCENTRIC_INTERP3(st0->w, st1->w, st2->w, scr_a1, scr_a2, poly->q);
	BARYCENTRIC_INTERP3(st0->z, st1->z, st2->z, scr_a1, scr_a2, poly->z2);
	BARYCENTRIC_INTERP3(st0->s, st1->s, st2->s, scr_a1, scr_a2, poly->s);
	BARYCENTRIC_INTERP3(st0->t, st1->t, st2->t, scr_a1, scr_a2, poly->t);

	poly->x = xy[0][0];
	poly->y = xy[0][1];
    }
}

static void
multmatrix4(Matrix4 s1, Matrix4 s2, Matrix4 d)
{
    int i, j;

    for ( i=0 ; i<4 ; i++ )
	for ( j=0 ; j<4 ; j++ )
	    d[i][j] = s1[i][0] * s2[0][j] + s1[i][1] * s2[1][j] +
		      s1[i][2] * s2[2][j] + s1[i][3] * s2[3][j];
}

static void
handleSingular(LFVtx quad[4], const Matrix4 model, LFVtx *eye)
{
    float eye_area_1;
    float eye_a1;
    float eye_a2;
    float eye2[2] = { 0.f, 0.f };
    float tex[2];
    int vtx_i;

    for ( vtx_i=0 ; vtx_i<3 ; vtx_i++ )  {
	XFORMVEC4(model, &quad[vtx_i].ox, &eye[vtx_i].x);
    }

    eye_area_1 = 1.f / AREA_PNT2(&eye[0].x, &eye[1].x, &eye[2].x);
    eye_a1 = AREA_PNT2(eye2, &eye[2].x, &eye[0].x) * eye_area_1;
    eye_a2 = AREA_PNT2(eye2, &eye[0].x, &eye[1].x) * eye_area_1;
    BARYCENTRIC_INTERP3(quad[0].s, quad[1].s, quad[2].s,
	eye_a1, eye_a2, tex[0]);
    BARYCENTRIC_INTERP3(quad[0].t, quad[1].t, quad[2].t,
	eye_a1, eye_a2, tex[1]);

    for ( vtx_i=0 ; vtx_i<3 ; vtx_i++ )  {
	COPYVEC2(tex, &eye[vtx_i].s);
    }
}

/*
 * function to compute the common intersection by projecting
 * two quads of a slab onto the viewing plane.
 */
bool_t
lfSlabIntersecting(LFVtx uv_quad[4], LFVtx st_quad[4],
		   const Matrix4 model, const Matrix4 proj,
		   LFScreenVtx *inter, int ninter[2])
{
    Matrix4 comp;
    LFVtx uv_clip1[10];
    LFVtx uv_clip2[10];
    LFVtx st_clip[10];
    float uv_pts[4][4];
    float st_pts[4][4];
    int uv_cnt1;
    int uv_cnt2;
    int st_cnt;
    float uv_pts_2d1[10][2];
    float uv_pts_2d2[10][2];
    float st_pts_2d[10][2];
    float planes[5][4];
    float pt_3d[3];
    float inter2[16][2];
    int vtx_i;
    int n_poly;
    int singular = 0;
    LFScreenVtx *poly_start;
    

    /* project points to normalized frustum to facilitate later processing */
    multmatrix4(proj, model, comp);
    for ( vtx_i=0 ; vtx_i<4 ; vtx_i++ )  {
	XFORMVEC4(comp, &uv_quad[vtx_i].ox, uv_pts[vtx_i]);
	XFORMVEC4(comp, &st_quad[vtx_i].ox, st_pts[vtx_i]);
	COPYVEC4(uv_pts[vtx_i], &uv_quad[vtx_i].x);
	COPYVEC4(st_pts[vtx_i], &st_quad[vtx_i].x);
    }

    /*
     * do clipping so that st quad is in the half viewing cone,
     * and uv quad is in the full viewing cone (the latter might be
     * split into two). this is needed for both eliminating more
     * trivial cases and guarantee projection in step 5 is meaningful.
     */
    TOVEC4(0, 0, 1, 1, planes[0]);
    TOVEC4( 1, 0, 0, OROURKE_1_EPS, planes[1]);
    TOVEC4(-1, 0, 0, OROURKE_1_EPS, planes[2]);
    TOVEC4(0,  1, 0, OROURKE_1_EPS, planes[3]);
    TOVEC4(0, -1, 0, OROURKE_1_EPS, planes[4]);
    st_cnt = clipFrustum(st_quad, planes, 5, st_clip);
    
    if  (! st_cnt)  {
	return FALSE;
    }
    

    TOVEC4( 0, 0, 1, 1, planes[0]);
    TOVEC4( 1, 0, 0, WIN_1, planes[1]);
    TOVEC4(-1, 0, 0, WIN_1, planes[2]);
    TOVEC4(0,  1, 0, WIN_1, planes[3]);
    TOVEC4(0, -1, 0, WIN_1, planes[4]);
    uv_cnt1 = clipFrustum(uv_quad, planes, 5, uv_clip1);

    TOVEC4( 0, 0, -1, -1, planes[0]);
    TOVEC4(-1, 0, 0, -WIN_1, planes[1]);
    TOVEC4( 1, 0, 0, -WIN_1, planes[2]);
    TOVEC4(0, -1, 0, -WIN_1, planes[3]);
    TOVEC4(0,  1, 0, -WIN_1, planes[4]);

    uv_cnt2 = clipFrustum(uv_quad, planes, 5, uv_clip2);
    
    if  (! uv_cnt1 && ! uv_cnt2)  {
	return FALSE;
    }
    

    /*
     * project both uv-quad and st-quad into the normalized
     * viewing frustum.
     */
    for ( vtx_i=0 ; vtx_i<uv_cnt1 ; vtx_i++ ) {
	if  (! HOMOVEC4(&uv_clip1[vtx_i].x, pt_3d, HOMO_EPS))  {
	    singular = SINGULAR_UV1;
	    break;
	}
	COPYVEC2(pt_3d, uv_pts_2d1[vtx_i]);
    }

    for ( vtx_i=0 ; vtx_i<uv_cnt2 ; vtx_i++ ) {
	if  (! HOMOVEC4(&uv_clip2[vtx_i].x, pt_3d, HOMO_EPS))  {
	    singular = SINGULAR_UV2;
	    break;
	}
	COPYVEC2(pt_3d, uv_pts_2d2[vtx_i]);
    }

    for ( vtx_i=0 ; vtx_i<st_cnt ; vtx_i++ ) {
	if  (! HOMOVEC4(&st_clip[vtx_i].x, pt_3d, HOMO_EPS))  {
	    singular = SINGULAR_ST;
	    break;
	}
	COPYVEC2(pt_3d, st_pts_2d[vtx_i]);
    }

    if  (singular)
      {
	
	ninter[1] = 0;
	if  (singular == SINGULAR_ST)  {
	  lfError("lfSlabIntersecting: viewer on the ST plane\n");
	  handleSingular(st_quad, model, st_clip);
	  if  (uv_cnt1)  {
	    ninter[0] = uv_cnt1;
	    clipEvaluate(uv_clip1, st_clip, uv_pts_2d1, uv_cnt1, inter);
	  }
	  else 
	    {
	      ninter[0] = uv_cnt2;
	      clipEvaluate(uv_clip2, st_clip, uv_pts_2d2, uv_cnt2, inter);
	    }
	}
	else {
	  ninter[0] = st_cnt;
	  if  (uv_cnt1)  {
	    handleSingular(uv_quad, model, uv_clip1);
	    clipEvaluate(uv_clip1, st_clip, st_pts_2d, st_cnt, inter);
	  }
	  else  {
	    handleSingular(uv_quad, model, uv_clip2);
	    clipEvaluate(uv_clip2, st_clip, st_pts_2d, st_cnt, inter);
	  }
	}

	return TRUE;
      }
    else
      {
	/*
	 * compute and check intersections of st quad with
	 * uv quad on the viewing plane
	 */
	ninter[0] = ninter[1] = 0;
	poly_start = inter, n_poly = 0;
	if  (uv_cnt1 && (ninter[n_poly] = 
			 geom2dConvexPolygonIntersect(uv_pts_2d1,
						      uv_cnt1, st_pts_2d, st_cnt, inter2))) 
	  {
	    bool_t z_uv_smaller_st = FALSE;
	    bool_t z_uv_larger_st  = FALSE;

	    /* compute attributes for intersection */
	    clipEvaluate(uv_clip1, st_clip, inter2, ninter[n_poly], poly_start);
	  
	    /*
	     * step 1: check if uv quad is behind st quad
	     * the following code warns that UV quad and ST quad intersect.
	     */
	    for ( vtx_i=0 ; vtx_i<ninter[n_poly] ; vtx_i++ )
	      if  (poly_start[vtx_i].z1 > poly_start[vtx_i].z2)
		z_uv_larger_st  = TRUE;
	      else
		z_uv_smaller_st = TRUE;
	  
	    if  (z_uv_smaller_st && z_uv_larger_st)  {
	      lfError("lfSlabIntersecting: two slab quads intersecting\n");
	      return FALSE;
	    }
	  
	    if  (z_uv_smaller_st)  {
	      poly_start += ninter[n_poly];
	      n_poly++;
	    }
	  }
	
	if  (uv_cnt2 && (ninter[n_poly] = 
			 geom2dConvexPolygonIntersect(uv_pts_2d2,
						      uv_cnt2, st_pts_2d, st_cnt, inter2))) 
	  {
	    /* compute attributes for intersection */
	    clipEvaluate(uv_clip2, st_clip, inter2, ninter[n_poly], poly_start);
	    
	    n_poly++;
	  }
	
	
	if  (! n_poly)  {
	  
	  return FALSE;
	}
	
	return TRUE;
      }
}





