/*
 * draw_fb.c
 *
 * this file eventually will replace draw.c
 */
#include "lightfield.h"

static void
setDrawingParams(LFOps *ops, LFInternOp *op)
{
    LFView *view = &__LF_GET_CONTEXT()->view;
    float *descr = op->op_descr;
    int mag_filter = LF_NEAREST_UVST;
    int min_filter = LF_NEAREST_UVST;
    int i;

    while (*descr != LF_NULL) {
	int param_type = (int)*descr++;
	switch(param_type) {
	case LF_DRAW_MAG_FILTER:
	    switch((int)*descr++) {
	    case LF_NEAREST_UVST:
		view->filter = 0;
		break;

	    case LF_NEAREST_UV_BILINEAR_ST:
		view->filter = LF_LERP_ST;
		break;

	    case LF_BILINEAR_UV_NEAREST_ST:
		view->filter = LF_LERP_UV;
		break;

	    case LF_QUADLINEAR_UVST:
		view->filter = LF_LERP_UV | LF_LERP_ST;
		break;
	    }
	}
    }

    for ( i=0 ; i<ops->op_slab_cnt ; i++ ) {
	LFSlab *slab = ops->op_slabs[i];
	LFShared *shared = slab->shared;
	if  (shared->flag & LF_SLAB_VALID_AUX) 
	    continue;
	shared->flag |= LF_SLAB_VALID_AUX;
	lfLinearizeVQCodebook(shared->vq);
	lfMakeIndices(shared);
	lfPadData(slab, 0xff, 4, LF_PAD_FIRST);
	shared->u_frac_bits = 6;
	shared->v_frac_bits = 6;
	shared->s_frac_bits = 6;
	shared->t_frac_bits = 6;
    }
}

void *
lfBeginDrawFB(LFOps *ops, LFInternOp *op)
{
    LFDriver *driver = __LF_GET_DRIVER();
    LFView *view = &__LF_GET_CONTEXT()->view;
    int x, y, width, height;

    /* get matrices and viewport */
    (*driver->get_transform)(view->mat_model, view->mat_proj,
	&x, &y, &width, &height);
    configViewport(x, y, width, height, view);

    /* clear the viewport pixel buffer */
    bzero(view->pixel_buffer, view->pixel_buffer_size); 

    op->op_func = lfDrawFB;
    op->op_end  = lfEndDrawFB;
    op->op_update = lfUpdateNoop;

    setDrawingParams(ops, op);

    return NULL;
}

void
lfDrawFB(LFSlab **slabs, int nslab, const int *pos,
	const float *descr, const void *input, int input_size,
	void *output, int output_size, void *aux_ptr)
{
    lfDrawSlab(slabs[pos[LF_SLAB_POS]]);
}

void
lfEndDrawFB(LFOps *ops, LFInternOp *op, void *aux_ptr)
{
    LFDriver *driver = __LF_GET_DRIVER();
    LFView *view = &__LF_GET_CONTEXT()->view;

    /* write the resulting looked up stuff into the framebuffer */
    (*driver->write_pixrect)(view->x, view->y, view->width, view->height,
	view->format, view->type, view->pixel_buffer);
}
