%{
/*
 * descr_file_yacc.y
 *
 * parser for a lightfield description file 
 */
#include <stdio.h>
#include <string.h>
#include "lightfield.h"

extern LFSlab *__lf_descr_slabs;

static LFSlab *cur_slab;
static LFVtx *cur_vtx;

%}
%union {
	float	f;
	int	i;
	char	*s;
}
%token	<i> INTEGER
%token	<f> REAL
%token	<s> FILEPATH
%token	RGBA RGB
%token	SLAB FORMAT SLAB_UV SLAB_ST SAMPLES_UV SAMPLES_ST
%type	<i> ColorFormat
%type 	<f> Number
%%
Field		: /* empty */
		| Field Slab
		;

Slab		: SlabHdr SlabAttribs
		;

SlabAttribs	: /* empty */
		| SlabAttribs SlabAttrib
		;

SlabAttrib	: SlabFormat
		| SlabGeomUV
		| SlabGeomST
		| SlabSampleUV
		| SlabSampleST
		;

SlabHdr		: SLAB INTEGER FILEPATH
		{
			if  ($2 >= LF_MAXSLABS)  {
				lfError("lfBeginReadSliceFile: too many slabs\n");
				exit(1);
			}
			cur_slab = &__lf_descr_slabs[$2];
			cur_slab->lightfield = strdup($3);
		}
		;

SlabFormat	: FORMAT ColorFormat
		{
			cur_slab->shared->sample_size = $2;
/*				($2 == 4) ? 4 : 3;
*/
		}
		;

SlabGeomUV	: SLAB_UV	{ cur_vtx = cur_slab->uv; }
		Vert Vert Vert Vert
		;

SlabGeomST	: SLAB_ST	{ cur_vtx = cur_slab->st; }
		Vert Vert Vert Vert
		;

SlabSampleUV	: SAMPLES_UV INTEGER INTEGER
		{
			cur_slab->shared->nu = $2;
			cur_slab->shared->nv = $3;
		}
		;

SlabSampleST	: SAMPLES_ST INTEGER INTEGER
		{
			cur_slab->shared->ns = $2;
			cur_slab->shared->nt = $3;
		}
		;

ColorFormat	: RGBA
		{
			$$ = 4;
		}
		| RGB
		{
			$$ = 3;
		}
		;

Vert		: Number Number Number Number Number Number
		{
			cur_vtx->ox = $1;
			cur_vtx->oy = $2;
			cur_vtx->oz = $3;
			cur_vtx->ow = $4;
			cur_vtx->s  = $5;
			cur_vtx->t  = $6;
			cur_vtx++;
		}
		;

Number		: REAL
		| INTEGER	{ $$ = (float)$1; }
		;
%%
void
yyerror(char *s)
{
    extern int yylineno;

    lfError("Error on line %d: %s\n", yylineno, s);
    exit(1);
}
