%{
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include "y.tab.h"

void skip_comments(void);
void skip_to_the_end(void);
%}
alpha   [a-zA-Z]
special	[\.\_-]
digit	[0-9]
string	({alpha}|".")({alpha}|{digit}|{special})*
filepath "/"?"/"?(("."|".."|{string})"/")*{string}
%%
[ \t\n]		;
#		skip_comments();
FIELD_DONE	skip_to_the_end();
SLAB		return SLAB;
FORMAT		return FORMAT;
SLAB_UV		return SLAB_UV;
SLAB_ST		return SLAB_ST;
SAMPLES_UV	return SAMPLES_UV;
SAMPLES_ST	return SAMPLES_ST;
RGBA		return RGBA;
RGB		return RGB;
[+-]?{digit}*\.{digit}+ { yylval.f = atof(yytext); return REAL; }
[+-]?{digit}+	{ yylval.i = atoi(yytext); return INTEGER; }
{filepath}	{ yylval.s = strdup(yytext); return FILEPATH; }

%%
int
yywrap()
{
    return 1;
}

void
skip_comments(void)
{
    while (input() != '\n');
}

void
skip_to_the_end(void)
{
    int c;

    while ((c=getchar()) != EOF);
    ungetc(c, stdin);
}
