/*
 * create.c
 *
 * stuff related to creation from the virtual camera model
 */
#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include "lightfield.h"

static void
createFillSlab(LFOps *ops, LFInternOp *op)
{
    LFShared *shared;
    float *descr = op->op_descr;
    int u_size, v_size;
    int s_size, t_size;
    int sample_size;
    int i;

    /* set slab attributes */
    u_size = v_size = 16;
    s_size = t_size = 256;
    sample_size = 3;
    while (*descr != LF_NULL) {
	switch((int)*descr++) {
	case LF_CREATE_SAMPLES_UV:
	    u_size = *descr++;
	    v_size = *descr++;
	    break;

	case LF_CREATE_SAMPLES_ST:
	    s_size = *descr++;
	    t_size = *descr++;
	    break;

	case LF_CREATE_FORMAT:
	    switch((int)*descr++) {
	    case LF_RGB:
		sample_size = 3;
		break;

	    case LF_RGBA:
		sample_size = 4;
		break;
	    }
	    break;
	}
    }

    for ( i=0 ; i<ops->op_slab_cnt ; i++ )
	if  (ops->op_slabs[i]->shared)  {
	    if  (ops->op_slabs[i]->shared->vq)  {
		free(ops->op_slabs[i]->shared->vq);
		ops->op_slabs[i]->shared->vq = 0;
	    }
	    free(ops->op_slabs[i]->shared);
	}

    shared = malloc(sizeof(LFShared));
    shared->nu = u_size;
    shared->nv = v_size;
    shared->ns = s_size;
    shared->nt = t_size;
    shared->sample_size = sample_size;
    shared->vq = NULL;

    for ( i=0 ; i<ops->op_slab_cnt ; i++ )
	ops->op_slabs[i]->shared = shared;
    ops->chain_msk |= LF_SHARED;

}

void *
lfBeginCreate(LFOps *ops, LFInternOp *op)
{
    /* fill in slab data structure */
    if  (ops->chain_msk & LF_SET_SLAB)
	createFillSlab(ops, op);

    /* fill in functions */
    switch(op->op_method) {
    case LF_POINT:
	op->op_func  = NULL;
	op->op_end   = NULL;
	op->op_update = ops->chain_msk &
			(LF_GEN_VQ_TRAINSET|LF_GEN_VQ_CODEARRAY) ?
			lfSerialUpdateBlockPoint : lfSerialUpdatePoint;
	break;

    case LF_SLICE_ST:
	op->op_func  = NULL;
	op->op_end   = NULL;
	op->op_update = ops->chain_msk &
			(LF_GEN_VQ_TRAINSET|LF_GEN_VQ_CODEARRAY) ?
			lfSerialUpdateBlockSlice : lfUpdateNoop;
	break;
    }

    return NULL;
}
