/*
 * api.c
 *
 * the external interface
 */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "lightfield.h"

static 
lenList(const float *descr)
{
    int len = 1;
    while (*descr != (float)LF_NULL)  {
	descr++, len++;
    }
    return len;
}

static float *
replicaList(const float *descr)
{
    int len = lenList(descr);
    float *new = malloc(sizeof(float) * len);
    int i;

    for ( i=0 ; i<len ; i++ )
	new[i] = descr[i];
    return new;
}

static void
addOp(int op_id, int method, const float *descr, void *extra)
{
    LFOps *ops = &(__LF_GET_CONTEXT()->ops);
    LFOp *op;
    
    assert(ops->op_cnt < LF_MAX_OPS);
    op = &ops->ops[ops->op_cnt++];
    op->op_id = op_id;
    op->op_method = method;
    op->op_descr = descr ? replicaList(descr) : NULL;
    op->op_extra = extra;
}

static LFSlab *
allocSlab(int id)
{
    LFSlab *slab = malloc(sizeof(LFSlab));

    slab->id = id;
    slab->lightfield = NULL;
    slab->shared = NULL;

    return slab;
}

void
lfBegin(int id, const float *hints)
{
    LFContext *ctx = __LF_GET_CONTEXT();
    LFField *field = ctx->field;
    LFOps *ops = &ctx->ops;
    int slab_i;

    assert(ops->op_cnt == 0);
    ops->op_slab_cnt = 0;
    if  (id >= (1 << LF_MAXSLABS))  {
	lfError("Illegal slab mask 0x%08x\n", id);
	return;
    }
	
#if	0
    switch(id) {
    case LF_FIELD:
	for ( slab_i=0 ; slab_i<LF_MAXSLABS ; slab_i++ )
	    if  (__LF_SLAB_ACTIVE(field, slab_i)) {
		ops->op_slabs[ops->op_slab_cnt++] = field->slabs[slab_i];
	    }
	break;

    case LF_SLAB_0:
    case LF_SLAB_1:
    case LF_SLAB_2:
    case LF_SLAB_3:
    case LF_SLAB_4:
    case LF_SLAB_5:
    case LF_SLAB_6:
    case LF_SLAB_7:
	slab_i = id - LF_SLAB_0;
	if  (__LF_SLAB_ACTIVE(field, slab_i)) {
	    ops->op_slabs[ops->op_slab_cnt++] = field->slabs[slab_i];
	}
	break;
    }
#else
    for ( slab_i=0 ; slab_i<LF_MAXSLABS ; slab_i++ )
	if  (id & (LF_SLAB_0 << slab_i))  {
	    if  (! field->slabs[slab_i])
		field->slabs[slab_i] = allocSlab(slab_i);
	    ops->op_slabs[ops->op_slab_cnt++] = field->slabs[slab_i];
	}
#endif

    ops->op_hints = hints ? replicaList(hints) : NULL;
}

void
lfEnd(void)
{
    LFOps *ops = &(__LF_GET_CONTEXT()->ops);

    if  (! ops->op_cnt)
	return;

    /* do parsing */
    lfDataflowAnalysis(ops);

    /* reset op cnt */
    ops->op_cnt = 0;
}

void
lfCreate(int method, const float *descr, void (*callback)())
{
    lfError("lfCreate: not completed yet\n");
    return;

    switch(method) {
    case LF_SLICE_ST:
    case LF_POINT:
	break;

    default:
	lfError("Unknown creation method %d\n", method);
	return;
    }

    addOp(LF_OP_COMPRESS, method, descr, callback);
}

void
lfCompress(int method, float *descr)
{
    switch(method) {
    case LF_VQ:
	break;

    default:
	lfError("Unknown compression method %d\n", method);
	return;
    }
    
    addOp(LF_OP_COMPRESS, method, descr, NULL);
}

void
lfRead(int method, const float *descr, char *filename)
{
    switch(method) {
    case LF_LIGHTFIELD:
	break;

    case LF_SLICE_ST:
	break;

    default:
	lfError("Unknown read method %d\n", method);
	return;
    }

    addOp(LF_OP_READ, method, descr, strdup(filename));
}

void
lfWrite(int method, const float *descr, char *filename)
{
    switch(method) {
    case LF_LIGHTFIELD:
	break;

    default:
	lfError("Unknown write method %d\n", method);
	return;
    }

    addOp(LF_OP_WRITE, method, descr, strdup(filename));
}

void
lfDraw(int method, const float *descr, void *p)
{
    switch(method) {
    case LF_COLOR:
	break;

    default:
	lfError("Unknown draw method %d\n", method);
	return;
    }

    addOp(LF_OP_DRAW, method, descr, p);
}

