/*
 * matrix.c
 *
 * stuff related to matrix 
 */
#include "geom.h"
#include <assert.h>

void
matrix3Inverse(Matrix3 s, Matrix3 d)
{
    float determ_1;

    d[0][0] = s[1][1] * s[2][2] - s[1][2] * s[2][1];
    d[1][0] = s[1][2] * s[2][0] - s[1][0] * s[2][2];
    d[2][0] = s[1][0] * s[2][1] - s[1][1] * s[2][0];

    d[0][1] = s[2][1] * s[0][2] - s[2][2] * s[0][1];
    d[1][1] = s[2][2] * s[0][0] - s[2][0] * s[0][2];
    d[2][1] = s[2][0] * s[0][1] - s[2][1] * s[0][0];

    d[0][2] = s[0][1] * s[1][2] - s[0][2] * s[1][1];
    d[1][2] = s[0][2] * s[1][0] - s[0][0] * s[1][2];
    d[2][2] = s[0][0] * s[1][1] - s[0][1] * s[1][0];

    determ_1 = 1.f / (s[0][0]*d[0][0] + s[0][1]*d[1][0] + s[0][2]*d[2][0]);
    
    SCALEVEC3(d[0], determ_1, d[0]);
    SCALEVEC3(d[1], determ_1, d[1]);
    SCALEVEC3(d[2], determ_1, d[2]);
}
