#include "vec4.h"
#include "geom_3d.h"
#include <assert.h>

int
geom3dPlaneClipPolygon(float **src_poly, int n_src_poly, float plane[4],
	bool_t (*eval)(float *, float [4]),
	void (*copy)(float *, float *),
	void (*clip)(float *, float *, float [4], float *),
	float **dst_poly)
{
    float **e1_curr = src_poly + n_src_poly - 1;
    float **e1_prev = src_poly;
    float **e2_curr = src_poly + 1;
    float **e2_prev = src_poly;
    float **new = dst_poly;
    bool_t e1_curr_inside;
    bool_t e1_prev_inside;
    bool_t e2_curr_inside;
    bool_t e2_prev_inside;
    int new_cnt;

    if  (! n_src_poly)
	return 0;

    e1_prev_inside = (*eval)(*e1_prev, plane);
    do  {
	e1_curr_inside = (*eval)(*e1_curr, plane);

	/*
	 * check if current vertex has the same inside-outside notion 
	 * as the previous one. if they do, then no intersection
	 * between this pair of vertices.
	 */
	if  (e1_curr_inside == e1_prev_inside)  {
	    e1_prev = e1_curr--;
	    e1_prev_inside = e1_curr_inside;
	    continue;
	}

	/*
	 * otherwise, find one intersection. search for the
	 * other intersection along the other direction.
	 */
	e2_prev_inside = (*eval)(*e2_prev, plane);
	for ( ; ; )  {
	    e2_curr_inside = (*eval)(*e2_curr, plane);
	    if  (e2_prev_inside != e2_curr_inside)
		break;
	    e2_prev = e2_curr++;
	    e2_prev_inside = e2_curr_inside;
	}

	/*
	 *  find both intersections. now fill the new polygon
	 *  structure. we can have only two cases: either
	 *  we start from a point outside the desired half-space
	 *  or we start from a point inside the half-space.
	 */
	if  (! e2_prev_inside)  {	/* start outside clipping plane */
	    /* deal with 1st intersection. always clip outside-to-inside */
	    (*clip)(*e2_prev, *e2_curr, plane, *new);
	    new++; new_cnt = 2;

	    /*  walk along the edges inside the clipping plane  */
	    do {
		(*copy)(*e2_curr, *new);
		new++, new_cnt++;
	    }
	    while (e2_curr++ != e1_curr);

	    /* deal with 2nd intersection. always clip outside-to-inside */
	    (*clip)(*e1_prev, *e1_curr, plane, *new);
	}
	else  {				/* start inside clipping plane */
	    /* deal with 1st intersection. always clip outside-to-inside */
	    (*clip)(*e2_curr, *e2_prev, plane, *new);
	    new++;

	    /* deal with 2nd intersection. always clip outside-to-inside */
	    (*clip)(*e1_curr, *e1_prev, plane, *new);
	    new++, new_cnt = 2;

	    /*  walk along portion of the edges inside the clipping plane  */
	    e1_prev = src_poly + n_src_poly - 1;
	    for ( ; e1_curr != e1_prev ; ) {
		e1_curr++;
		(*copy)(*e1_curr, *new);
		new++, new_cnt++;
	    }

	    e2_curr = src_poly;
	    do  {
		(*copy)(*e2_curr, *new);
		new++, new_cnt++;
	    }
	    while (e2_curr++ != e2_prev);
	}

	return new_cnt;
    } while  (e1_curr != e2_prev);

    /*  test for special case: all in  */
    if  (e1_curr_inside)  {
	int i;

	for ( e1_curr=src_poly,i=0 ; i<n_src_poly ; i++,e1_curr++,new++ )
	    (*copy)(*e1_curr, *new);
	return n_src_poly;
    }

    return 0;
}
