/*
 * vec.c
 *
 * a bunch of functions with respect to 2d vectors (lines)
 */
#include "common.h"
#include "geom.h"

bool_t
geom2dColinearPntOnSegment(float v0[2], float v1[2],
	float pnt[2], float epsilon)
{
    float dir01[2];
    float diff0[2], diff1[2];
    float dot;

    SUBVEC2(diff1, diff0, dir01);
    SUBVEC2(pnt, v0, diff0);
    SUBVEC2(pnt, v1, diff1);
    dot = DOTVEC2(dir01, dir01);
    return  (  DOTVEC2(diff0, diff0) <= dot + epsilon
	    && DOTVEC2(diff1, diff1) <= dot + epsilon
	    );
}

int
geom2dSegmentSegmentRelation(float line0_v0[2], float line0_v1[2],
	float line1_v0[2], float line1_v1[2], float inter[2],
	float params[2], float epsilon)
{
    float dir0[2];
    float dir1[2];
    float diff_line01_v0[2];
    float scale;
    float s, t;
    float lo_bound = -epsilon;
    float up_bound = 1.f + epsilon;

    SUBVEC2(line0_v1, line0_v0, dir0);
    SUBVEC2(line1_v1, line1_v0, dir1);
    scale = DETERM_VEC2(dir0, dir1);

    /* check for parallel lines */
    if  (ABS(scale) <= epsilon) {
	/* we have parallel lines, check if they are colinear */
	float area = AREA_PNT2(line0_v0, line0_v1, line1_v0);
	if  (ABS(area) > epsilon)
	    return GEOM_FIGURE_PARALLEL;

	/* we have colinear lines. check for overlapping segments */
	if  (geom2dColinearPntOnSegment(line0_v0,line0_v1,line1_v0,epsilon)) {
	    COPYVEC2(line1_v0, inter);
	    return GEOM_FIGURE_COINCIDENT;
	}

	if  (geom2dColinearPntOnSegment(line0_v0,line0_v1,line1_v1,epsilon)) {
	    COPYVEC2(line1_v1, inter);
	    return GEOM_FIGURE_COINCIDENT;
	}

	return GEOM_FIGURE_PARALLEL;
    }

    /* otherwise, lines cannot be parallel */
    scale = -1.f / scale;
    SUBVEC2(line0_v0, line1_v0, diff_line01_v0);
    s = DETERM_VEC2(diff_line01_v0, dir1) * scale;
    t = DETERM_VEC2(diff_line01_v0, dir0) * scale;
    params[0] = s, params[1] = t;
    INTERP2(line0_v0, line0_v1, 1-s, s, inter);
    return (  s >= lo_bound && s <= up_bound
	   && t >= lo_bound && t <= up_bound
	   ) ? GEOM_FIGURE_INTERSECTING : GEOM_FIGURE_SLANTED;
}
