/*
 * tri.c
 *
 * a bunch of functions with respect to triangles
 */
#include "common.h"
#include "geom_2d.h"
#include "vec2.h"

bool_t
geom2dPntInDegeneratedTriangle(float tri_v0[2], float tri_v1[2],
	float tri_v2[2], float pnt[2], float epsilon)
{
    float diff_v1_v0[2];
    float diff_p_v0[2];
    float area;

    SUBVEC2(tri_v1, tri_v0, diff_v1_v0);
    SUBVEC2(pnt, tri_v0, diff_p_v0);
    area = AREA_VEC2(diff_v1_v0, diff_p_v0);

    if  (ABS(area) > epsilon)
	return FALSE;

    /* the point is on the line. check if it is within the interval */
    return  (  geom2dColinearPntOnSegment(tri_v0, tri_v1, pnt, epsilon)
	    || geom2dColinearPntOnSegment(tri_v1, tri_v2, pnt, epsilon)
	    || geom2dColinearPntOnSegment(tri_v2, tri_v0, pnt, epsilon)
	    );
}

/*
 * a function to classify a point's relationship with a triangle.
 * we declare the point is inside a triangle if it's within epsilon
 * of the triangle border.
 */
bool_t
geom2dPntInTriangle(float tri_v0[2], float tri_v1[2], float tri_v2[2],
	float pnt[2], float epsilon)
{
    float diff_v1_v0[2];
    float diff_v2_v0[2];
    float diff_p_v0[2];
    float scale;
    float a0, a1, a2;
    float lo_bound = -epsilon;
    float up_bound = 1.f + epsilon;

    SUBVEC2(tri_v1, tri_v0, diff_v1_v0);
    SUBVEC2(tri_v2, tri_v0, diff_v2_v0);
    scale = DETERM_VEC2(diff_v1_v0, diff_v2_v0);

    /* check if we are dealing with a degenerated triangle (to a line) */
    if  (ABS(scale) <= epsilon)
	return geom2dPntInDegeneratedTriangle(tri_v0, tri_v1, tri_v2,
						pnt, epsilon);

    /* otherwise,we have a normal triangle */
    scale = 1.f / scale;
    SUBVEC2(pnt, tri_v0, diff_p_v0);
    a1 = DETERM_VEC2(diff_p_v0, diff_v2_v0) * scale;
    a2 = DETERM_VEC2(diff_v1_v0, diff_p_v0) * scale;
    a0 = 1.f - a1 - a2;
    return (  a0 >= lo_bound && a0 <= up_bound
	   && a1 >= lo_bound && a1 <= up_bound
	   && a2 >= lo_bound && a2 <= up_bound
	   );
}
