/*
 * general.c
 *
 * a bunch of functions with respect to general 2d stuff
 */
#include <assert.h>
#include "common.h"
#include "geom_type.h"
#include "geom_2d.h"
#include "vec2.h"

/*
 * function to compute the centroid of a bunch of 2d points
 */
void
geom2dCentroid(float (*poly)[2], int n, float centroid[2])
{
    float scale = 1.f / n;
    int i;

    TOVEC2(0, 0, centroid);
    for ( i=0 ; i<n ; i++ ) {
	ADDVEC2(poly[i], centroid, centroid);
    }
    SCALEVEC2(centroid, scale, centroid);
}
