#ifndef	VQ_IFACE_H
#define	VQ_IFACE_H

#define	VQ_FIXED_LINEAR	0x0
#define	VQ_FIXED_TREE	0x1

/* vq interface to outside word */
typedef struct {
    int type;
    int size;
    int nwords;
    int cw_size;
    void *codebook;
} VQ_t;

/*BEGIN:C++TOC*/
extern VQ_t *vqGenTreeCodebook(const unsigned char *data_array, int data_size,
	int dw_size, int max_code_size, int cw_size);
extern VQ_t *vqTreeCodebookToLinearCodebook(const VQ_t *tree_vq);
extern void vqDecodeLinear(VQ_t *vq, int *codearray, int domain_dimens,
	int len[], int clen, int padded, int padded_nbits,
	unsigned char *image);
extern void vqEncode(VQ_t *vq, unsigned char *image, int domain_dimens,
	int len[], int clen, int padded, int padded_nbits,
	int *codearray, int *bitoffset_p);
extern void vqFreeCodebook(VQ_t *vq);
/*END:C++TOC*/

#endif	/* VQ_IFACE_H */
