#ifndef	VEC4_H
#define VEC4_H

/*
 *      vec4.h
 *
 *      Benjamin Zhu
 *      All Rights Reserved
 */
#include <assert.h>
#include "vec3.h"

static float _vec4_hdr_tmp;

#define COPYVEC4(s,d)			\
	((d)[0]=(s)[0], (d)[1]=(s)[1], (d)[2]=(s)[2], (d)[3]=(s)[3])

#define INTERP4(s1,s2,c1,c2,d)  (	\
	(d)[0] = (c1) * (s1)[0] + (c2) * (s2)[0], \
	(d)[1] = (c1) * (s1)[1] + (c2) * (s2)[1], \
	(d)[2] = (c1) * (s1)[2] + (c2) * (s2)[2], \
	(d)[3] = (c1) * (s1)[3] + (c2) * (s2)[3])

#define NEGVEC4(s,d)			\
	((d)[0]=-(s)[0], (d)[1]=-(s)[1], (d)[2]=-(s)[2], (d)[3]=-(s)[3])

#define	TOVEC4(a,b,c,d,v)		\
	((v)[0]=a, (v)[1]=b, (v)[2]=c, (v)[3]=d)

#define DOTVEC4(s1,s2)			\
	((s1)[0]*(s2)[0]+(s1)[1]*(s2)[1]+(s1)[2]*(s2)[2]+(s1)[3]*(s2)[3])

/* macro to transform a homogeneous point */
#define XFORMVEC4(mat,s,d) {		\
	assert((float *)s!=(float *)d);	\
        (d)[0] = DOTVEC4(mat[0], s),	\
        (d)[1] = DOTVEC4(mat[1], s),	\
        (d)[2] = DOTVEC4(mat[2], s),	\
        (d)[3] = DOTVEC4(mat[3], s); }

#define	VEC4_SUBDETERM3(pt0, pt1, pt2, i0, i1, i2)  (	\
	pt0[i0]*(pt1[i1]*pt2[i2] - pt1[i2]*pt2[i1]) +	\
	pt0[i1]*(pt1[i2]*pt2[i0] - pt1[i0]*pt2[i2]) +	\
	pt0[i2]*(pt1[i0]*pt2[i1] - pt1[i1]*pt2[i0]))

/* macro to compute a plane equation from three homogeneous points */
#define	VEC4_TO_PLANE(pt0, pt1, pt2, pl)	(	\
	pl[0] = VEC4_SUBDETERM3((pt0), (pt1), (pt2), 1, 2, 3),	\
	pl[1] = -VEC4_SUBDETERM3((pt0), (pt1), (pt2), 0, 2, 3),	\
	pl[2] = VEC4_SUBDETERM3((pt0), (pt1), (pt2), 0, 1, 3),	\
	pl[3] = -VEC4_SUBDETERM3((pt0), (pt1), (pt2), 0, 1, 2))
	
/*
 * macro to orient a plane so that a given point is always at the
 * + side. when view is incident on the plane, it returns 0;
 * otherwise, it returns 1
 */
#define	ORIENT_PLANE(pl_s, pt, pl_d, eps) (	\
	_vec4_hdr_tmp = DOTVEC4(pl_s, pt),	\
	(_vec4_hdr_tmp >= 0.f) ?		\
	(COPYVEC4(pl_s, pl_d), (_vec4_hdr_tmp > (eps))) : \
	(NEGVEC4(pl_s, pl_d), (_vec4_hdr_tmp < -(eps))))

/*
 * macro to homogenize a 4-D vector into a 3-D vector. it returns
 * 0 if the 4-D vector is a direction, and it returns 1 if the 4-D
 * vector is a position
 */
#define	HOMOVEC4(v4,v3,eps)	(		\
	(ABS((v4)[3]) <= eps) ? (COPYVEC3(v4, v3), 0.f) :	\
	(_vec4_hdr_tmp = 1.f / (v4)[3],	\
	 SCALEVEC3(v4, _vec4_hdr_tmp, v3), (v4)[3]))

#endif	/* ! VEC4_H */

