#ifndef	VEC3_H
#define VEC3_H

/*
 *      vec3.h
 *
 *      Benjamin Zhu
 *      All Rights Reserved
 */
#include <assert.h>

static float _vec3_hdr_tmp1;
static float _vec3_hdr_tmp2;

#define	ADDVEC3(s1,s2,d)		\
	(d)[0] = (s1)[0] + (s2)[0],	\
	(d)[1] = (s1)[1] + (s2)[1],	\
	(d)[2] = (s1)[2] + (s2)[2]

#define	COPYVEC3(s,d)			\
	(d)[0]=(s)[0], (d)[1]=(s)[1], (d)[2]=(s)[2]

#define CROSSVEC3(s1,s2,d)     		\
        (d)[0] = (s1)[1]*(s2)[2] - (s1)[2]*(s2)[1], \
        (d)[1] = (s1)[2]*(s2)[0] - (s1)[0]*(s2)[2], \
        (d)[2] = (s1)[0]*(s2)[1] - (s1)[1]*(s2)[0]

#define DOTVEC3(s1,s2)			\
	((s1)[0]*(s2)[0]+(s1)[1]*(s2)[1]+(s1)[2]*(s2)[2])

#define	INTERP3(s1,s2,c1,c2,d)		\
	(d)[0] = (c1) * (s1)[0] + (c2) * (s2)[0], \
	(d)[1] = (c1) * (s1)[1] + (c2) * (s2)[1], \
	(d)[2] = (c1) * (s1)[2] + (c2) * (s2)[2]

#define	LEN3(v)				\
	sqrt(DOTVEC3(v,v))

#define	MULVEC3(s,m,d)			\
	(d)[0] = (s)[0] * (m)[0],     \
	(d)[1] = (s)[1] * (m)[1],     \
	(d)[2] = (s)[2] * (m)[2]

#define NEGVEC3(s,d)			\
	(d)[0]=-(s)[0], (d)[1]=-(s)[1], (d)[2]=-(s)[2]

#define	SCALEVEC3(s,sc,d) 		\
	(d)[0] = (sc)*(s)[0], (d)[1] = (sc)*(s)[1], (d)[2] = (sc)*(s)[2]

#define	NORMVEC3(s,d) (			\
	_vec3_hdr_tmp1 = LEN3(s),	\
	(_vec3_hdr_tmp1 == 0.f ?	\
	 (_vec3_hdr_tmp2 = 1.f / _vec3_hdr_tmp1,	\
	  SCALEVEC3(s, _vec3_hdr_tmp2, d)),	\
	 COPYVEC3(s, d)),		\
	_vec3_hdr_tmp1)

#define	SUBVEC3(s1,s2,d)		\
	(d)[0] = (s1)[0] - (s2)[0],	\
	(d)[1] = (s1)[1] - (s2)[1],	\
	(d)[2] = (s1)[2] - (s2)[2]

#define	TOVEC3(a,b,c,v)			\
	(v)[0]=(a), (v)[1]=(b), (v)[2]=(c)

#define XFORMVEC3(mat,s,d) {		\
	assert((float *)s!=(float *)d); \
        (d)[0] = DOTVEC3(mat[0], s),	\
        (d)[1] = DOTVEC3(mat[1], s),	\
        (d)[2] = DOTVEC3(mat[2], s); }

#endif	/* ! VEC3_H */

