#ifndef	VEC2_H
#define VEC2_H

/*
 *      vec2.h
 *
 *      Benjamin Zhu
 *      All Rights Reserved
 */
#define	ADDVEC2(s1,s2,d)		\
	(d)[0] = (s1)[0] + (s2)[0], 	\
	(d)[1] = (s1)[1] + (s2)[1]

#define	AREA_PNT2(pt0, pt1, pt2)  (	\
	((pt1)[0]-(pt0)[0]) * ((pt2)[1]-(pt0)[1]) -	\
	((pt1)[1]-(pt0)[1]) * ((pt2)[0]-(pt0)[0]))

#define	AREA_VEC2(v0, v1)		\
	((v0)[0]*(v1)[1] - (v0)[1]*(v1)[0])

#define COPYVEC2(s,d)                   \
	(d)[0]=(s)[0], (d)[1]=(s)[1]

#define	DETERM_VEC2(v0, v1)	AREA_VEC2(v0, v1)

#define	DOTVEC2(v0, v1)			\
	((v0)[0]*(v1)[0] + (v0)[1]*(v1)[1])

#define INTERP2(s1,s2,c1,c2,d)          \
	(d)[0] = (c1) * (s1)[0] + (c2) * (s2)[0], \
	(d)[1] = (c1) * (s1)[1] + (c2) * (s2)[1]

#define	SCALEVEC2(s,sc,d)		\
	(d)[0] = (sc)*(s)[0], (d)[1] = (sc)*(s)[1]

#define	SUBVEC2(s1,s2,d)		\
	(d)[0] = (s1)[0] - (s2)[0], 	\
	(d)[1] = (s1)[1] - (s2)[1]

#define	TOVEC2(a,b,v)			\
	((v)[0] = a, (v)[1] = b)

#define XFORMVEC2(mat,s,d) {            \
	assert((float *)s!=(float *)d); \
	(d)[0] = DOTVEC3(mat[0], s),    \
	(d)[1] = DOTVEC3(mat[1], s); }

#endif	/* ! VEC2_H */

