#ifndef	MAT4_H
#define MAT4_H

/*
 *      mat4.h
 *
 *      Benjamin Zhu
 *      All Rights Reserved
 */

/* types */
typedef float Matrix4[4][4];

/* locals */
static float _mat4_hdr_tmp1;
static float _mat4_hdr_tmp2;

/* macros */
#define	TRANSMAT4(smat, dmat) (		\
	dmat[0][0] = smat[0][0],	\
	dmat[1][1] = smat[1][1],	\
	dmat[2][2] = smat[2][2],	\
	dmat[3][3] = smat[3][3],	\
	_mat4_hdr_tmp1 = smat[0][1],	\
	_mat4_hdr_tmp2 = smat[1][0],	\
	dmat[0][1] = _mat4_hdr_tmp2,	\
	dmat[1][0] = _mat4_hdr_tmp1,	\
	_mat4_hdr_tmp1 = smat[0][2],	\
	_mat4_hdr_tmp2 = smat[2][0],	\
	dmat[0][2] = _mat4_hdr_tmp2,	\
	dmat[2][0] = _mat4_hdr_tmp1,	\
	_mat4_hdr_tmp1 = smat[0][3],	\
	_mat4_hdr_tmp2 = smat[3][0],	\
	dmat[0][3] = _mat4_hdr_tmp2,	\
	dmat[3][0] = _mat4_hdr_tmp1,	\
	_mat4_hdr_tmp1 = smat[1][2],	\
	_mat4_hdr_tmp2 = smat[2][1],	\
	dmat[1][2] = _mat4_hdr_tmp2,	\
	dmat[2][1] = _mat4_hdr_tmp1,	\
	_mat4_hdr_tmp1 = smat[1][3],	\
	_mat4_hdr_tmp2 = smat[3][1],	\
	dmat[1][3] = _mat4_hdr_tmp2,	\
	dmat[3][1] = _mat4_hdr_tmp1,	\
	_mat4_hdr_tmp1 = smat[2][3],	\
	_mat4_hdr_tmp2 = smat[3][2],	\
	dmat[2][3] = _mat4_hdr_tmp2,	\
	dmat[3][2] = _mat4_hdr_tmp1)

#endif	/* ! MAT4_H */

