#ifndef	GEOM_TYPE_H
#define	GEOM_TYPE_H

/* macros */

/* shape definition */
#define	GEOM_SHAPE_MSK			0x3
#define	GEOM_SHAPE_SHFT			2
#define	GEOM_SHAPE_CONVEX		0x0
#define	GEOM_SHAPE_CONCAVE		0x1
#define	GEOM_SHAPE_COMPLEX		0x2
#define	GEOM_SHAPE_GET(flag)		(((flag) & GEOM_SHAPE_MSK) >> GEOM_SHAPE_SHFT)
#define	GEOM_SHAPE_SET(flag,val)	(flag = (flag & ~GEOM_SHAPE_MSK) | ((val) << GEOM_SHAPE_SHFT))

/* orientation definition */
#define	GEOM_ORIENT_MSK			0x3
#define	GEOM_ORIENT_CW			0x0
#define	GEOM_ORIENT_CCW			0x1
#define	GEOM_ORIENT_AREA0		0x2

/* pairwise relation */
#define	GEOM_FIGURE_MSK			0x3
#define	GEOM_FIGURE_PARALLEL		0x0
#define	GEOM_FIGURE_SLANTED		0x1
#define	GEOM_FIGURE_INTERSECTING	0x2
#define	GEOM_FIGURE_COINCIDENT		0x3

/* prototypes */

#endif	/* ! GEOM_TYPE_H */
