#ifndef	GEOM_KD_H
#define	GEOM_KD_H

#include "common.h"

/* types */
typedef struct {
    float (*min_max)[2];
    int (*min_max_idx)[2];
    int dim;
} BoundingBox;

/* macros */
#define	GEOM_BOUNDING_BOX_MIN_MAX(box, i, min, max)	\
	(min = box->min_max[i][0],		\
	 max = box->min_max[i][1])

#define	GEOM_BOUNDING_BOX_MIN_MAX_IDX(box, i, min_idx, max_idx)	\
	(min = box->min_max_idx[i][0],		\
	 max = box->min_max_idx[i][1])

/* prototypes */
extern BoundingBox
    *geomAllocBoundingBox(int /*dim*/);

extern bool_t 
    geomBoundingBoxSeparable(int /*dim*/, float * /*cluster0*/, int /*n0*/,
	float * /*cluster1*/, int /*n1*/, float /*epsilon*/);

extern void
    geomBoundingBox(int /*dim*/, float * /*pt*/, int /*n*/, BoundingBox * /*box*/),
    geomFreeBoundingBox(BoundingBox * /*box*/);

#endif	/* ! GEOM_KD_H */
