#ifndef	GEOM_3D_H
#define	GEOM_3D_H

#include "common.h"
#include "mat3.h"

/* prototypes */
extern int
	geom3dPlaneClipPolygon(float ** /*src_poly*/, int /*n_src_poly*/,
		float /*plane*/[4], bool_t (* /*eval*/)(float *, float [4]),
		void (* /*copy*/)(float *, float *),
		void (* /*clip*/)(float *, float *, float [4], float *),
		float ** /*dst_poly*/);

extern bool_t 
	geom3dPlaneTrivialAcceptable(float (* /*pts*/)[4], int /*npts*/,
		float (* /*planes*/)[4], int /*nplanes*/, float /*eps*/),
	geom3dPlaneTrivialRejectable(float (* /*pts*/)[4], int /*npts*/,
		float (* /*planes*/)[4], int /*nplanes*/, float /*eps*/);

extern void
	geom3dPlaneClipEdgeDefault(float * /*s1p*/, float * /*s2p*/,
		float /*plane*/[4], float * /*dp*/),
	matrix3Inverse(Matrix3 /*s*/, Matrix3 /*d*/);

#endif	/* ! GEOM_3D_H */
