#!/usr/common/bin/perl
#
# glimpl.c.pl
#
# Kekoa Proudfoot 3/31/98, 5/6/98
#

use lib "../perl/modules";

# Bleah, I prefer Include qw(shared.in), but that gives errors until 5.004
use Includes;

use Special qw(glimpl.c.sp);

use Opcodes qw(: @fnames fntolb lbtofn);
use Flags   qw(: %ignore %noencode %lengths %notopengl);
use Headers qw(: fntype fnpnames fnptypes fnparms);
use Special qw(: $fpstruct_add $fnames_add $static_add $funcs_add);
use Special qw(: %writevecs %specialencode);
use Encode  qw(fnpstypes fnpisvecs fnpveclens fnssize fnspad fnsname);

foreach $name (@fnames) {
    push(@names, $name) unless ($ignore{$name} || $notopengl{$name});
}

print("/*\n");
print(" * glimpl.c\n");
print(" *\n");
print(" * Machine generated gl trace implementation\n");
print(" *\n");
print(" */\n");
print("\n");

print("/* Include files */\n");
print("\n");

print("#define WIN32_LEAN_AND_MEAN\n");
print("#include <windows.h>\n");
print("#include <stdio.h>\n");
print("#include <stdlib.h>\n");
print("#include <string.h>\n");
print("\n");
print("#include <GL/gl.h>\n");
print("\n");
print("#include <glt.h>\n");
print("\n");

print("/* Pragmas */\n");
print("\n");

print("#pragma warning (disable:4273)\n");
print("#pragma pack(1)\n");
print("\n");

print("/* Macros */\n");
print("\n");

print("#define OPENGL_LIBRARY \"c:\\\\winnt\\\\system32\\\\opengl32.dll\"\n");
print("\n");

print("#ifndef NDEBUG\n");
print("#define ONCE(cmd) \\\n");
print("    do { \\\n");
print("        static int once = 0; \\\n");
print("        if (!once && ++once) cmd ; \\\n");
print("    } while (0)\n");
print("#else\n");
print("#define ONCE(cmd)\n");
print("#endif\n");
print("\n");

print("#define ROUND(x) (((x)>0.0f)?(int)((x)+0.5f):(int)((x)-0.5f))\n");
print("\n");

print("#define ALIGN(p,a) (-(int)(p)&((a)-1))\n");
print("\n");

print("/* Hack? Wrong place? */\n");
print("static GLT_trace __trace;\n");
print("\n");
print("/* Hack? Wrong place? */\n");
print("static int __count = -1;\n");
print("static int __call_level = 0;\n");

print("\n");

print("/* Hack? Wrong place? */\n");
print("typedef struct {\n");
print("    int row_length;\n");
print("    int skip_rows;\n");
print("    int skip_pixels;\n");
print("    int unpack_alignment;\n");
print("} PS_state;\n");
print("\n");
print("static PS_state __ps_state = { 0, 0, 0, 4 };\n");
print("\n");

print("/* GL function pointer struct */\n");
print("\n");

print("static struct {\n");

foreach $name (@names) {
    next if ($name =~ /EXT$/);
    $type = fntype($name);
    $ptypes = fnptypes($name);
    print("    $type (APIENTRY *$name)($ptypes);\n");
}

print("$fpstruct_add\n");
print("} fptable;\n");
print("\n");
print("static void InitFuncTable( void );\n");
print("static int fptable_init = 0;\n");
print("\n");

print("/* GL function names */\n");
print("\n");

print("static char *fnames[] = {\n");

foreach $name (@names) {
    next if ($name =~ /EXT$/);
    print("    \"$name\",\n");
}

print("$fnames_add\n");
print("};\n");
print("\n");

print("$static_add\n");
print("\n");

print("/* GL functions */\n");
print("\n");

foreach $name (@names) {
    next if ($name =~ /EXT$/);
    $type = fntype($name);
    $parms = fnparms($name);
    $pnames = fnpnames($name);
    $noencode = $noencode{$name};
    $writevecs = $writevecs{$name};
    $specialencode = $specialencode{$name};
    print("$type APIENTRY\n");
    print("$name($parms)\n");
    print("{\n");
    print("    $type retvalue;\n") if ($type ne 'void');
    print("    int call_level = __call_level++;\n");
    print("    if (call_level == 0) {\n");
    if ($noencode && !$specialencode) {
        print("        ONCE(glt_mesg(GLT_EWARN, \"glt: not encoding " .
	      "$name\"));\n");
	;
    }
    elsif ($specialencode) {
	print("$specialencode\n");
    }
    else {
	$label = fntolb($name);
	@pnames = split(', ', $pnames);
	@pstypes = split(':', fnpstypes($name));
	@pisvecs = split(':', fnpisvecs($name));
	@pveclens = split(':', fnpveclens($name));
	$ssize = fnssize($name);
	$spad = fnspad($name);
	$sname = fnsname($name);
	if (!$ssize) {
	    print("        glt_put(&__trace, $label, NULL);\n");
	}
	else {
	    print("        $sname data;\n");
	    while (@pnames) {
		$pname = shift(@pnames);
		$pstype = shift(@pstypes);
		$pisvec = shift(@pisvecs);
		$pveclen = shift(@pveclens);
		if ($pisvec && $pveclen) {
		    if (!$writevecs) {
			for $i (0 .. $pveclen - 1) {
			    print("        data.${pname}[$i] = " .
				  "${pname}[$i];\n");
			}
		    }
		} elsif ($pisvec) { # !$pveclen implied
		    if (!$writevecs) {
			print("        ONCE(glt_mesg(GLT_EWARN, \"glt: " .
			      "encoding zero length vector for $name\"));\n");
			print("        data.n_${pname} = 0; /* for now */\n");
			print("        data.${pname} = ($pstype *)$pname;\n");
		    }
		} else {
		    print("        data.${pname} = $pname;\n");
		}
	    }
	    print("$writevecs\n") if ($writevecs);
	    for $i (0 .. $spad - 1) {
		print("        data.pad[$i] = 0;\n");
	    }
	    print("        glt_put(&__trace, $label, (GLT_data *)&data);\n");
	}
    }
    print("    }\n");
    print("    fptable.$name($pnames);\n") if ($type eq 'void');
    print("    retvalue = fptable.$name($pnames);\n") if ($type ne 'void');
    print("    __call_level = call_level;\n");
    print("    return retvalue;\n") if ($type ne 'void');
    print("}\n");
    print("\n");
}

print("$funcs_add\n");
print("\n");

print("/* Place holder for missing functions */\n");
print("\n");

print("static void\n");
print("__missing_sym(void)\n");
print("{\n");
print("    ONCE(glt_mesg(GLT_WARN, \"glt: missing symbol in libGL.so!\"));\n");
print("}\n");
print("\n");

print("/* Init function */\n");
print("\n");

print("/* Hack! */\n");
print("void __glt_fini(void);\n");
print("\n");

print << 'END_OF_HERE';
static const char *
ErrnoToString( int err )
{
    static char buf[256];
    int rc;

    rc = FormatMessage( FORMAT_MESSAGE_FROM_SYSTEM, NULL, err,
                        MAKELANGID( LANG_NEUTRAL, SUBLANG_DEFAULT ),
                        (LPTSTR) &buf, sizeof(buf)-1, NULL );

    if ( !rc )
        sprintf( buf, "ERROR_UNDEFINED=%d", err );

    return buf;
}

static void
InitFuncTable( void )
{
    HINSTANCE handle;
    int i;
    handle = LoadLibrary(OPENGL_LIBRARY);
    if ( handle == NULL ) {
        int err = GetLastError();
        glt_warn("glt: LoadLibrary( \"%s\" ) failed : %s", OPENGL_LIBRARY,
                 ErrnoToString(err));
        if (err == ERROR_NOACCESS)
            glt_warn("glt: check Q196069 in Microsoft Knowledgebase");
        exit(0);
    }

    for (i = 0; i < sizeof(fnames) / sizeof(fnames[0]); i++) {
        void *ptr = GetProcAddress(handle, fnames[i]);
        if ( ptr )
            ((void (**)(void))&fptable)[i] = ptr;
    }

    fptable_init = 1;
}

END_OF_HERE

print("BOOL WINAPI\n");
print("DllMain(HINSTANCE dllhinstance, DWORD reason, LPVOID reserved)\n");
print("{\n");
print("    char *filename = NULL;\n");
print("    char *value;\n");
print("    int memory = 0;\n");
print("    int i;\n");
print("\n");
print("    if (reason == DLL_PROCESS_DETACH) {\n");
print("        __glt_fini();\n");
print("        return TRUE;\n");
print("    }\n");
print("    if (reason != DLL_PROCESS_ATTACH) {\n");
print("        return TRUE;\n");
print("    }\n");
print("    if ( !fptable_init ) {\n");
print("       for (i = 0; i < sizeof(fptable) / sizeof(fptable.wglChoosePixelFormat); i++)\n");
print("            ((void (**)(void))&fptable)[i] = __missing_sym;\n");
print("    }\n");
print("\n");
print("    if (value = getenv(\"__GLT_OUTPUT\")) filename = value;\n");
print("    if (value = getenv(\"__GLT_COUNT\")) __count = atoi(value);\n");
print("    if (value = getenv(\"__GLT_MEMORY\")) memory = atoi(value);\n");
print("    if (value = getenv(\"__GLT_DEBUG\")) __glt_debug = atoi(value);\n");
print("    /* Hack! DEBUGFILE is a hack for now */\n");
print("    if (value = getenv(\"__GLT_DEBUGFILE\")) {\n");
print("        FILE *errfile = fopen(value, \"w\");\n");
print("        if (errfile)\n");
print("            __glt_errfile = errfile;\n");
print("        else\n");
print("            glt_warn(\"glt: couldn't open debug file %s\", value);\n");
print("    }\n");
print("\n");
print("    glt_mesg(GLT_WARN, \"glt: initializing\");\n");
print("\n");
print("    if (filename)\n");
print("        glt_mesg_va(GLT_ENV, (\"output = %s\", filename));\n");
print("    else\n");
print("        glt_mesg(GLT_ENV, \"output = stdout\");\n");
print("    glt_mesg_va(GLT_ENV, (\"count  = %d\", __count));\n");
print("    glt_mesg_va(GLT_ENV, (\"memory = %d\", memory));\n");
print("    glt_mesg_va(GLT_ENV, (\"debug  = %d\", __glt_debug));\n");

print("\n");
print("    if (memory)\n");
print("        glt_open(&__trace, filename, GLT_WRONLY | GLT_MEM);\n");
print("    else\n");
print("        glt_open(&__trace, filename, GLT_WRONLY | GLT_FILE);\n");
print("\n");
print("    if (__count == 0) _exit(0); /* Hack! to avoid the seg fault */\n");
print("    return TRUE;\n");
print("}\n");
print("\n");

print("/* Cleanup function */\n");
print("\n");

print("void\n");
print("__glt_fini(void)\n");
print("{\n");
print("    glt_mesg(GLT_WARN, \"glt: finishing\");\n");
print("    glt_close(&__trace);\n");
print("    /* Hack? */\n");
print("#ifndef NDEBUG\n");
print("    __glt_printmem();\n");
print("#endif\n");
print("}\n");
