# Special file for glimpl.c.pl

[fpstruct_add]
    XVisualInfo* (*glXChooseVisual)(Display *, int, int *);
    void (*glXCopyContext)(Display *, GLXContext, GLXContext, GLuint);
    GLXContext (*glXCreateContext)(Display *, XVisualInfo *, GLXContext, Bool);
    GLXPixmap (*glXCreateGLXPixmap)(Display *, XVisualInfo *, Pixmap);
    void (*glXDestroyContext)(Display *, GLXContext);
    void (*glXDestroyGLXPixmap)(Display *, GLXPixmap);
    int (*glXGetConfig)(Display *, XVisualInfo *, int, int *);
    GLXContext (*glXGetCurrentContext)(void);
    GLXDrawable (*glXGetCurrentDrawable)(void);
    Bool (*glXIsDirect)(Display *, GLXContext);
    Bool (*glXMakeCurrent)(Display *, GLXDrawable, GLXContext);
    Bool (*glXQueryExtension)(Display *, int *, int *);
    Bool (*glXQueryVersion)(Display *, int *, int *);
    void (*glXSwapBuffers)(Display *, GLXDrawable);
    void (*glXUseXFont)(Font, int, int, int);
    void (*glXWaitGL)(void);
    void (*glXWaitX)(void);
    const char* (*glXQueryExtensionsString)(Display *, int);
    const char* (*glXGetClientString)(Display *, int);
    const char* (*glXQueryServerString)(Display *, int, int);
#ifdef IRIX
    /* SGI extensions */
    GLXContext (*glXCreateContextWithConfigSGIX)(Display *, GLXFBConfigSGIX, int, GLXContext, Bool);
    GLXFBConfigSGIX (*glXGetFBConfigFromVisualSGIX)(Display *, XVisualInfo *);
    int (*glXGetFBConfigAttribSGIX)(Display *, GLXFBConfigSGIX, int, int *);
#endif
    /* Adding pointers to extra functions is okay */
    Status (*XGetGeometry)(Display *, Drawable, Window *, int *, int *, unsigned int *, unsigned int *, unsigned int *, unsigned int *);
[]

[fnames_add]
    "glXChooseVisual",
    "glXCopyContext",
    "glXCreateContext",
    "glXCreateGLXPixmap",
    "glXDestroyContext",
    "glXDestroyGLXPixmap",
    "glXGetConfig",
    "glXGetCurrentContext",
    "glXGetCurrentDrawable",
    "glXIsDirect",
    "glXMakeCurrent",
    "glXQueryExtension",
    "glXQueryVersion",
    "glXSwapBuffers",
    "glXUseXFont",
    "glXWaitGL",
    "glXWaitX",
    "glXQueryExtensionsString",
    "glXGetClientString",
    "glXQueryServerString",
#ifdef IRIX
    /* SGI extensions */
    "glXCreateContextWithConfigSGIX",
    "glXGetFBConfigFromVisualSGIX",
    "glXGetFBConfigAttribSGIX",
#endif
    /* Adding extra function names here is not okay (yet) ... */
    /* If this list had a way to specify the library from which to fetch */
    /* each symbol (or group of symbols), then extra function names here */
    /* would be okay. Groovy. In the mean time, use __map_symbol */
[]

[static_add]
/* Static utility functions */

#define MAX_CONTEXTS 256
#define MAX_DRAWABLES 256

static int __num_contexts = 1; /* zero maps to zero */
static GLXContext __contexts[MAX_CONTEXTS];
static int __num_drawables = 1; /* zero maps to zero */
static GLXDrawable __drawables[MAX_DRAWABLES];

static int
__map_context(GLXContext ctx)
{
    int i;
    for (i = 0; i < __num_contexts; i++)
	if (__contexts[i] == ctx)
	    return i;
    if (__num_contexts == MAX_CONTEXTS)
	return -1; /* Hack! should really report an error here */
    __contexts[__num_contexts] = ctx;
    return __num_contexts++;
}

static int
__map_drawable(GLXDrawable drawable)
{
    int i;
    for (i = 0; i < __num_drawables; i++)
	if (__drawables[i] == drawable)
	    return i;
    if (__num_drawables == MAX_DRAWABLES)
	return -1; /* Hack! should really report an error here */
    __drawables[__num_drawables] = drawable;
    return __num_drawables++;
}

static void *
__map_symbol(char *library, char *symbol)
{
    void *handle;
    void *fhandle;
    if ((handle = dlopen(library, RTLD_LAZY)) == NULL)
	glt_fatal("glt: couldn't open %s", library);
    if (!(fhandle = dlsym(handle, symbol)))
	glt_fatal("glt: couldn't find symbol %s in %s", symbol, library);
    return fhandle;
}

/* Hack? Wrong place? */
typedef struct {
    int enabled;
    int size;
    int type;
    int stride;
    void *pointer;
} VA_pointer;

static VA_pointer __edge_flag_array = { 0, 0, 0, 1, 0 };
static VA_pointer __tex_coord_array = { 0, 4, GL_FLOAT, 16, 0 };
static VA_pointer __color_array = { 0, 4, GL_FLOAT, 16, 0 };
static VA_pointer __index_array = { 0, 0, GL_FLOAT, 4, 0 };
static VA_pointer __normal_array = { 0, 0, GL_FLOAT, 12, 0 };
static VA_pointer __vertex_array = { 0, 4, GL_FLOAT, 16, 0 };

/* Hack? Wrong place? */
#define VA_PTR(ary,ind) (&((char *)(ary).pointer)[ind*(ary).stride])
#define VA_VAL(ptr,typ,ofs) (((typ *)(ptr))[ofs])

static void
__varray_element(int i)
{
    GLT_data data;
    /* Hooray for branch prediction */
    if (__edge_flag_array.enabled) {
	void *ptr = VA_PTR(__edge_flag_array, i);
        data.edge_flag.flag = VA_VAL(ptr, GLboolean, 0);
	data.edge_flag.pad[0] = 0;
	data.edge_flag.pad[1] = 0;
	data.edge_flag.pad[2] = 0;
        glt_put(&__trace, GLT_OP_EDGE_FLAG, &data);
    }
    if (__tex_coord_array.enabled) {
	void *ptr = VA_PTR(__tex_coord_array, i);
	switch (__tex_coord_array.type) {
	case GL_SHORT:
	    switch (__tex_coord_array.size) {
	    case 1:
		data.tex_coord_1s.s = VA_VAL(ptr, GLshort, 0);
		data.tex_coord_1s.pad[0] = 0;
		data.tex_coord_1s.pad[1] = 0;
		glt_put(&__trace, GLT_OP_TEX_COORD_1S, &data);
		break;
	    case 2:
		data.tex_coord_2s.s = VA_VAL(ptr, GLshort, 0);
		data.tex_coord_2s.t = VA_VAL(ptr, GLshort, 1);
		glt_put(&__trace, GLT_OP_TEX_COORD_2S, &data);
		break;
	    case 3:
		data.tex_coord_3s.s = VA_VAL(ptr, GLshort, 0);
		data.tex_coord_3s.t = VA_VAL(ptr, GLshort, 1);
		data.tex_coord_3s.r = VA_VAL(ptr, GLshort, 2);
		data.tex_coord_3s.pad[0] = 0;
		data.tex_coord_3s.pad[1] = 0;
		glt_put(&__trace, GLT_OP_TEX_COORD_3S, &data);
		break;
	    case 4:
		data.tex_coord_4s.s = VA_VAL(ptr, GLshort, 0);
		data.tex_coord_4s.t = VA_VAL(ptr, GLshort, 1);
		data.tex_coord_4s.r = VA_VAL(ptr, GLshort, 2);
		data.tex_coord_4s.q = VA_VAL(ptr, GLshort, 3);
		glt_put(&__trace, GLT_OP_TEX_COORD_4S, &data);
		break;
	    }
	    break;
	case GL_INT:
	    switch (__tex_coord_array.size) {
	    case 1:
		data.tex_coord_1i.s = VA_VAL(ptr, GLint, 0);
		glt_put(&__trace, GLT_OP_TEX_COORD_1I, &data);
		break;
	    case 2:
		data.tex_coord_2i.s = VA_VAL(ptr, GLint, 0);
		data.tex_coord_2i.t = VA_VAL(ptr, GLint, 1);
		glt_put(&__trace, GLT_OP_TEX_COORD_2I, &data);
		break;
	    case 3:
		data.tex_coord_3i.s = VA_VAL(ptr, GLint, 0);
		data.tex_coord_3i.t = VA_VAL(ptr, GLint, 1);
		data.tex_coord_3i.r = VA_VAL(ptr, GLint, 2);
		glt_put(&__trace, GLT_OP_TEX_COORD_3I, &data);
		break;
	    case 4:
		data.tex_coord_4i.s = VA_VAL(ptr, GLint, 0);
		data.tex_coord_4i.t = VA_VAL(ptr, GLint, 1);
		data.tex_coord_4i.r = VA_VAL(ptr, GLint, 2);
		data.tex_coord_4i.q = VA_VAL(ptr, GLint, 3);
		glt_put(&__trace, GLT_OP_TEX_COORD_4I, &data);
		break;
	    }
	    break;
	case GL_FLOAT:
	    switch (__tex_coord_array.size) {
	    case 1:
		data.tex_coord_1f.s = VA_VAL(ptr, GLfloat, 0);
		glt_put(&__trace, GLT_OP_TEX_COORD_1F, &data);
		break;
	    case 2:
		data.tex_coord_2f.s = VA_VAL(ptr, GLfloat, 0);
		data.tex_coord_2f.t = VA_VAL(ptr, GLfloat, 1);
		glt_put(&__trace, GLT_OP_TEX_COORD_2F, &data);
		break;
	    case 3:
		data.tex_coord_3f.s = VA_VAL(ptr, GLfloat, 0);
		data.tex_coord_3f.t = VA_VAL(ptr, GLfloat, 1);
		data.tex_coord_3f.r = VA_VAL(ptr, GLfloat, 2);
		glt_put(&__trace, GLT_OP_TEX_COORD_3F, &data);
		break;
	    case 4:
		data.tex_coord_4f.s = VA_VAL(ptr, GLfloat, 0);
		data.tex_coord_4f.t = VA_VAL(ptr, GLfloat, 1);
		data.tex_coord_4f.r = VA_VAL(ptr, GLfloat, 2);
		data.tex_coord_4f.q = VA_VAL(ptr, GLfloat, 3);
		glt_put(&__trace, GLT_OP_TEX_COORD_4F, &data);
		break;
	    }
	    break;
	case GL_DOUBLE:
	    switch (__tex_coord_array.size) {
	    case 1:
		data.tex_coord_1d.s = VA_VAL(ptr, GLdouble, 0);
		glt_put(&__trace, GLT_OP_TEX_COORD_1D, &data);
		break;
	    case 2:
		data.tex_coord_2d.s = VA_VAL(ptr, GLdouble, 0);
		data.tex_coord_2d.t = VA_VAL(ptr, GLdouble, 1);
		glt_put(&__trace, GLT_OP_TEX_COORD_2D, &data);
		break;
	    case 3:
		data.tex_coord_3d.s = VA_VAL(ptr, GLdouble, 0);
		data.tex_coord_3d.t = VA_VAL(ptr, GLdouble, 1);
		data.tex_coord_3d.r = VA_VAL(ptr, GLdouble, 2);
		glt_put(&__trace, GLT_OP_TEX_COORD_3D, &data);
		break;
	    case 4:
		data.tex_coord_4d.s = VA_VAL(ptr, GLdouble, 0);
		data.tex_coord_4d.t = VA_VAL(ptr, GLdouble, 1);
		data.tex_coord_4d.r = VA_VAL(ptr, GLdouble, 2);
		data.tex_coord_4d.q = VA_VAL(ptr, GLdouble, 3);
		glt_put(&__trace, GLT_OP_TEX_COORD_4D, &data);
		break;
	    }
	    break;
        default:
            break;
	}
    }
    if (__color_array.enabled) {
	void *ptr = VA_PTR(__color_array, i);
	switch (__color_array.type) {
	case GL_BYTE:
	    switch (__color_array.size) {
	    case 3:
		data.color_3b.red = VA_VAL(ptr, GLbyte, 0);
		data.color_3b.green = VA_VAL(ptr, GLbyte, 1);
		data.color_3b.blue = VA_VAL(ptr, GLbyte, 2);
		data.color_3b.pad[0] = 0;
		glt_put(&__trace, GLT_OP_COLOR_3B, &data);
		break;
	    case 4:
		data.color_4b.red = VA_VAL(ptr, GLbyte, 0);
		data.color_4b.green = VA_VAL(ptr, GLbyte, 1);
		data.color_4b.blue = VA_VAL(ptr, GLbyte, 2);
		data.color_4b.alpha = VA_VAL(ptr, GLbyte, 3);
		glt_put(&__trace, GLT_OP_COLOR_4B, &data);
		break;
	    }
	    break;
	case GL_UNSIGNED_BYTE:
	    switch (__color_array.size) {
	    case 3:
		data.color_3ub.red = VA_VAL(ptr, GLubyte, 0);
		data.color_3ub.green = VA_VAL(ptr, GLubyte, 1);
		data.color_3ub.blue = VA_VAL(ptr, GLubyte, 2);
		data.color_3ub.pad[0] = 0;
		glt_put(&__trace, GLT_OP_COLOR_3UB, &data);
		break;
	    case 4:
		data.color_4ub.red = VA_VAL(ptr, GLubyte, 0);
		data.color_4ub.green = VA_VAL(ptr, GLubyte, 1);
		data.color_4ub.blue = VA_VAL(ptr, GLubyte, 2);
		data.color_4ub.alpha = VA_VAL(ptr, GLubyte, 3);
		glt_put(&__trace, GLT_OP_COLOR_4UB, &data);
		break;
	    }
	    break;
	case GL_SHORT:
	    switch (__color_array.size) {
	    case 3:
		data.color_3s.red = VA_VAL(ptr, GLshort, 0);
		data.color_3s.green = VA_VAL(ptr, GLshort, 1);
		data.color_3s.blue = VA_VAL(ptr, GLshort, 2);
		data.color_3s.pad[0] = 0;
		data.color_3s.pad[1] = 0;
		glt_put(&__trace, GLT_OP_COLOR_3S, &data);
		break;
	    case 4:
		data.color_4s.red = VA_VAL(ptr, GLshort, 0);
		data.color_4s.green = VA_VAL(ptr, GLshort, 1);
		data.color_4s.blue = VA_VAL(ptr, GLshort, 2);
		data.color_4s.alpha = VA_VAL(ptr, GLshort, 3);
		glt_put(&__trace, GLT_OP_COLOR_4S, &data);
		break;
	    }
	    break;
	case GL_UNSIGNED_SHORT:
	    switch (__color_array.size) {
	    case 3:
		data.color_3us.red = VA_VAL(ptr, GLushort, 0);
		data.color_3us.green = VA_VAL(ptr, GLushort, 1);
		data.color_3us.blue = VA_VAL(ptr, GLushort, 2);
		data.color_3us.pad[0] = 0;
		data.color_3us.pad[1] = 0;
		glt_put(&__trace, GLT_OP_COLOR_3US, &data);
		break;
	    case 4:
		data.color_4us.red = VA_VAL(ptr, GLushort, 0);
		data.color_4us.green = VA_VAL(ptr, GLushort, 1);
		data.color_4us.blue = VA_VAL(ptr, GLushort, 2);
		data.color_4us.alpha = VA_VAL(ptr, GLushort, 3);
		glt_put(&__trace, GLT_OP_COLOR_4US, &data);
		break;
	    }
	    break;
	case GL_INT:
	    switch (__color_array.size) {
	    case 3:
		data.color_3i.red = VA_VAL(ptr, GLint, 0);
		data.color_3i.green = VA_VAL(ptr, GLint, 1);
		data.color_3i.blue = VA_VAL(ptr, GLint, 2);
		glt_put(&__trace, GLT_OP_COLOR_3I, &data);
		break;
	    case 4:
		data.color_4i.red = VA_VAL(ptr, GLint, 0);
		data.color_4i.green = VA_VAL(ptr, GLint, 1);
		data.color_4i.blue = VA_VAL(ptr, GLint, 2);
		data.color_4i.alpha = VA_VAL(ptr, GLint, 3);
		glt_put(&__trace, GLT_OP_COLOR_4I, &data);
		break;
	    }
	    break;
	case GL_UNSIGNED_INT:
	    switch (__color_array.size) {
	    case 3:
		data.color_3ui.red = VA_VAL(ptr, GLuint, 0);
		data.color_3ui.green = VA_VAL(ptr, GLuint, 1);
		data.color_3ui.blue = VA_VAL(ptr, GLuint, 2);
		glt_put(&__trace, GLT_OP_COLOR_3UI, &data);
		break;
	    case 4:
		data.color_4ui.red = VA_VAL(ptr, GLuint, 0);
		data.color_4ui.green = VA_VAL(ptr, GLuint, 1);
		data.color_4ui.blue = VA_VAL(ptr, GLuint, 2);
		data.color_4ui.alpha = VA_VAL(ptr, GLuint, 3);
		glt_put(&__trace, GLT_OP_COLOR_4UI, &data);
		break;
	    }
	    break;
	case GL_FLOAT:
	    switch (__color_array.size) {
	    case 3:
		data.color_3f.red = VA_VAL(ptr, GLfloat, 0);
		data.color_3f.green = VA_VAL(ptr, GLfloat, 1);
		data.color_3f.blue = VA_VAL(ptr, GLfloat, 2);
		glt_put(&__trace, GLT_OP_COLOR_3F, &data);
		break;
	    case 4:
		data.color_4f.red = VA_VAL(ptr, GLfloat, 0);
		data.color_4f.green = VA_VAL(ptr, GLfloat, 1);
		data.color_4f.blue = VA_VAL(ptr, GLfloat, 2);
		data.color_4f.alpha = VA_VAL(ptr, GLfloat, 3);
		glt_put(&__trace, GLT_OP_COLOR_4F, &data);
		break;
	    }
	    break;
	case GL_DOUBLE:
	    switch (__color_array.size) {
	    case 3:
		data.color_3d.red = VA_VAL(ptr, GLdouble, 0);
		data.color_3d.green = VA_VAL(ptr, GLdouble, 1);
		data.color_3d.blue = VA_VAL(ptr, GLdouble, 2);
		glt_put(&__trace, GLT_OP_COLOR_3D, &data);
		break;
	    case 4:
		data.color_4d.red = VA_VAL(ptr, GLdouble, 0);
		data.color_4d.green = VA_VAL(ptr, GLdouble, 1);
		data.color_4d.blue = VA_VAL(ptr, GLdouble, 2);
		data.color_4d.alpha = VA_VAL(ptr, GLdouble, 3);
		glt_put(&__trace, GLT_OP_COLOR_4D, &data);
		break;
	    }
	    break;
        default:
            break;
	}
    }
    if (__index_array.enabled) {
	void *ptr = VA_PTR(__index_array, i);
	switch (__index_array.type) {
	case GL_UNSIGNED_BYTE:
	    data.indexub.c = VA_VAL(ptr, GLubyte, 0);
	    data.indexub.pad[0] = 0;
	    data.indexub.pad[1] = 0;
	    data.indexub.pad[2] = 0;
	    glt_put(&__trace, GLT_OP_INDEXUB, &data);
	    break;
	case GL_SHORT:
	    data.indexs.c = VA_VAL(ptr, GLshort, 0);
	    data.indexs.pad[0] = 0;
	    data.indexs.pad[1] = 0;
	    glt_put(&__trace, GLT_OP_INDEXS, &data);
	    break;
	case GL_INT:
	    data.indexi.c = VA_VAL(ptr, GLint, 0);
	    glt_put(&__trace, GLT_OP_INDEXI, &data);
	    break;
	case GL_FLOAT:
	    data.indexf.c = VA_VAL(ptr, GLint, 0);
	    glt_put(&__trace, GLT_OP_INDEXF, &data);
	    break;
	case GL_DOUBLE:
	    data.indexd.c = VA_VAL(ptr, GLint, 0);
	    glt_put(&__trace, GLT_OP_INDEXD, &data);
	    break;
        default:
            break;
	}
    }
    if (__normal_array.enabled) {
	void *ptr = VA_PTR(__normal_array, i);
	switch (__normal_array.type) {
	case GL_BYTE:
	    data.normal_3b.nx = VA_VAL(ptr, GLbyte, 0);
	    data.normal_3b.ny = VA_VAL(ptr, GLbyte, 1);
	    data.normal_3b.nz = VA_VAL(ptr, GLbyte, 2);
	    data.normal_3b.pad[0] = 0;
	    glt_put(&__trace, GLT_OP_NORMAL_3B, &data);
	    break;
	case GL_SHORT:
	    data.normal_3s.nx = VA_VAL(ptr, GLshort, 0);
	    data.normal_3s.ny = VA_VAL(ptr, GLshort, 1);
	    data.normal_3s.nz = VA_VAL(ptr, GLshort, 2);
	    data.normal_3s.pad[0] = 0;
	    data.normal_3s.pad[1] = 0;
	    glt_put(&__trace, GLT_OP_NORMAL_3S, &data);
	    break;
	case GL_INT:
	    data.normal_3i.nx = VA_VAL(ptr, GLint, 0);
	    data.normal_3i.ny = VA_VAL(ptr, GLint, 1);
	    data.normal_3i.nz = VA_VAL(ptr, GLint, 2);
	    glt_put(&__trace, GLT_OP_NORMAL_3I, &data);
	    break;
	case GL_FLOAT:
	    data.normal_3f.nx = VA_VAL(ptr, GLfloat, 0);
	    data.normal_3f.ny = VA_VAL(ptr, GLfloat, 1);
	    data.normal_3f.nz = VA_VAL(ptr, GLfloat, 2);
	    glt_put(&__trace, GLT_OP_NORMAL_3F, &data);
	    break;
	case GL_DOUBLE:
	    data.normal_3d.nx = VA_VAL(ptr, GLdouble, 0);
	    data.normal_3d.ny = VA_VAL(ptr, GLdouble, 1);
	    data.normal_3d.nz = VA_VAL(ptr, GLdouble, 2);
	    glt_put(&__trace, GLT_OP_NORMAL_3D, &data);
	    break;
        default:
            break;
	}
    }
    if (__vertex_array.enabled) {
	void *ptr = VA_PTR(__vertex_array, i);
	switch (__vertex_array.type) {
	case GL_SHORT:
	    switch (__vertex_array.size) {
	    case 2:
		data.vertex_2s.x = VA_VAL(ptr, GLshort, 0);
		data.vertex_2s.y = VA_VAL(ptr, GLshort, 1);
		glt_put(&__trace, GLT_OP_VERTEX_2S, &data);
		break;
	    case 3:
		data.vertex_3s.x = VA_VAL(ptr, GLshort, 0);
		data.vertex_3s.y = VA_VAL(ptr, GLshort, 1);
		data.vertex_3s.z = VA_VAL(ptr, GLshort, 2);
		data.vertex_3s.pad[0] = 0;
		data.vertex_3s.pad[1] = 0;
		glt_put(&__trace, GLT_OP_VERTEX_3S, &data);
		break;
	    case 4:
		data.vertex_4s.x = VA_VAL(ptr, GLshort, 0);
		data.vertex_4s.y = VA_VAL(ptr, GLshort, 1);
		data.vertex_4s.z = VA_VAL(ptr, GLshort, 2);
		data.vertex_4s.w = VA_VAL(ptr, GLshort, 3);
		glt_put(&__trace, GLT_OP_VERTEX_4S, &data);
		break;
	    }
            break;
	case GL_INT:
	    switch (__vertex_array.size) {
	    case 2:
		data.vertex_2i.x = VA_VAL(ptr, GLint, 0);
		data.vertex_2i.y = VA_VAL(ptr, GLint, 1);
		glt_put(&__trace, GLT_OP_VERTEX_2I, &data);
		break;
	    case 3:
		data.vertex_3i.x = VA_VAL(ptr, GLint, 0);
		data.vertex_3i.y = VA_VAL(ptr, GLint, 1);
		data.vertex_3i.z = VA_VAL(ptr, GLint, 2);
		glt_put(&__trace, GLT_OP_VERTEX_3I, &data);
		break;
	    case 4:
		data.vertex_4i.x = VA_VAL(ptr, GLint, 0);
		data.vertex_4i.y = VA_VAL(ptr, GLint, 1);
		data.vertex_4i.z = VA_VAL(ptr, GLint, 2);
		data.vertex_4i.w = VA_VAL(ptr, GLint, 3);
		glt_put(&__trace, GLT_OP_VERTEX_4I, &data);
		break;
	    }
            break;
	case GL_FLOAT:
	    switch (__vertex_array.size) {
	    case 2:
		data.vertex_2f.x = VA_VAL(ptr, GLfloat, 0);
		data.vertex_2f.y = VA_VAL(ptr, GLfloat, 1);
		glt_put(&__trace, GLT_OP_VERTEX_2F, &data);
		break;
	    case 3:
		data.vertex_3f.x = VA_VAL(ptr, GLfloat, 0);
		data.vertex_3f.y = VA_VAL(ptr, GLfloat, 1);
		data.vertex_3f.z = VA_VAL(ptr, GLfloat, 2);
		glt_put(&__trace, GLT_OP_VERTEX_3F, &data);
		break;
	    case 4:
		data.vertex_4f.x = VA_VAL(ptr, GLfloat, 0);
		data.vertex_4f.y = VA_VAL(ptr, GLfloat, 1);
		data.vertex_4f.z = VA_VAL(ptr, GLfloat, 2);
		data.vertex_4f.w = VA_VAL(ptr, GLfloat, 3);
		glt_put(&__trace, GLT_OP_VERTEX_4F, &data);
		break;
	    }
            break;
	case GL_DOUBLE:
	    switch (__vertex_array.size) {
	    case 2:
		data.vertex_2d.x = VA_VAL(ptr, GLdouble, 0);
		data.vertex_2d.y = VA_VAL(ptr, GLdouble, 1);
		glt_put(&__trace, GLT_OP_VERTEX_2D, &data);
		break;
	    case 3:
		data.vertex_3d.x = VA_VAL(ptr, GLdouble, 0);
		data.vertex_3d.y = VA_VAL(ptr, GLdouble, 1);
		data.vertex_3d.z = VA_VAL(ptr, GLdouble, 2);
		glt_put(&__trace, GLT_OP_VERTEX_3D, &data);
		break;
	    case 4:
		data.vertex_4d.x = VA_VAL(ptr, GLdouble, 0);
		data.vertex_4d.y = VA_VAL(ptr, GLdouble, 1);
		data.vertex_4d.z = VA_VAL(ptr, GLdouble, 2);
		data.vertex_4d.w = VA_VAL(ptr, GLdouble, 3);
		glt_put(&__trace, GLT_OP_VERTEX_4D, &data);
		break;
	    }
            break;
        default:
            break;
	}
    }
}
[]

[funcs_add]
/* GLX functions */

XVisualInfo *
glXChooseVisual( Display *a, int b, int *c )
{
    return fptable.glXChooseVisual( a, b, c );
}

void
glXCopyContext( Display *a, GLXContext b, GLXContext c, GLuint d )
{
    fptable.glXCopyContext( a, b, c, d );
}

GLXContext
glXCreateContext(Display *dpy, XVisualInfo *vis, GLXContext list, Bool direct)
{
    GLT_create_context data;
    GLXContext ctx;
    ctx = fptable.glXCreateContext(dpy, vis, list, direct);
    data.ctx = __map_context(ctx);
    data.share = __map_context(list);
    /* Perhaps too much, but no worring about adding more later */
    if (vis) {
	fptable.glXGetConfig(dpy, vis, GLX_RGBA, &data.rgba);
	fptable.glXGetConfig(dpy, vis, GLX_RED_SIZE, &data.red);
	fptable.glXGetConfig(dpy, vis, GLX_GREEN_SIZE, &data.green);
	fptable.glXGetConfig(dpy, vis, GLX_BLUE_SIZE, &data.blue);
	fptable.glXGetConfig(dpy, vis, GLX_ALPHA_SIZE, &data.alpha);
	fptable.glXGetConfig(dpy, vis, GLX_BUFFER_SIZE, &data.buffersize);
	fptable.glXGetConfig(dpy, vis, GLX_DOUBLEBUFFER, &data.doublebuffer);
	fptable.glXGetConfig(dpy, vis, GLX_DEPTH_SIZE, &data.depth);
	fptable.glXGetConfig(dpy, vis, GLX_STENCIL_SIZE, &data.stencil);
	fptable.glXGetConfig(dpy, vis, GLX_ACCUM_RED_SIZE, &data.accumred);
	fptable.glXGetConfig(dpy, vis, GLX_ACCUM_GREEN_SIZE, &data.accumgreen);
	fptable.glXGetConfig(dpy, vis, GLX_ACCUM_BLUE_SIZE, &data.accumblue);
	fptable.glXGetConfig(dpy, vis, GLX_ACCUM_ALPHA_SIZE, &data.accumalpha);
	/* What about GLX_STEREO, GLX_LEVEL, etc. ? */
    }
    else {
	/* what here? */
	data.rgba = 0;
	data.red = 0;
	data.green = 0;
	data.blue = 0;
	data.alpha = 0;
	data.buffersize = 0;
	data.doublebuffer = 0;
	data.depth = 0;
	data.stencil = 0;
	data.accumred = 0;
	data.accumgreen = 0;
	data.accumblue = 0;
	data.accumalpha = 0;
    }
    glt_put(&__trace, GLT_OP_CREATE_CONTEXT, (GLT_data *)&data);
    return ctx;
}

GLXPixmap
glXCreateGLXPixmap( Display *a, XVisualInfo *b, Pixmap c )
{
    return fptable.glXCreateGLXPixmap( a, b, c );
}

void
glXDestroyContext(Display *dpy, GLXContext ctx)
{
    GLT_destroy_context data;
    data.ctx = __map_context(ctx);
    glt_put(&__trace, GLT_OP_DESTROY_CONTEXT, (GLT_data *)&data);
    fptable.glXDestroyContext(dpy, ctx);
}

void
glXDestroyGLXPixmap( Display *a, GLXPixmap b )
{
    fptable.glXDestroyGLXPixmap( a, b );
}

int
glXGetConfig( Display *a, XVisualInfo *b, int c, int *d )
{
    return fptable.glXGetConfig( a, b, c, d );
}

GLXContext
glXGetCurrentContext( void )
{
    return fptable.glXGetCurrentContext( );
}

GLXDrawable
glXGetCurrentDrawable( void )
{
    return fptable.glXGetCurrentDrawable( );
}

Bool
glXIsDirect( Display *a, GLXContext b )
{
    return fptable.glXIsDirect( a, b );
}

Bool
glXMakeCurrent(Display *dpy, GLXDrawable drawable, GLXContext ctx)
{
    GLT_make_current data;
    Bool status;
    Window root;
    int x, y;
    unsigned int w = 0, h = 0;
    unsigned int border;
    unsigned int depth;
    /* Hack! */
    if (!fptable.XGetGeometry)
        *(void **)&fptable.XGetGeometry = __map_symbol("libX11.so", "XGetGeometry");
    status = fptable.glXMakeCurrent(dpy, drawable, ctx);
    /* XGetGeometry takes a relatively long time to get w and h */
    if (drawable)
        fptable.XGetGeometry(dpy,drawable,&root,&x,&y,&w,&h,&border,&depth);
    data.win = __map_drawable(drawable);
    data.ctx = __map_context(ctx);
    data.width = w;
    data.height = h;
    data.fail = (status == False);
    glt_put(&__trace, GLT_OP_MAKE_CURRENT, (GLT_data *)&data);
    return status;
}

Bool
glXQueryExtension( Display *a, int *b, int *c )
{
    return fptable.glXQueryExtension( a, b, c );
}

Bool
glXQueryVersion( Display *a, int *b, int *c )
{
    return fptable.glXQueryVersion( a, b, c );
}

#ifdef SHOW_FRAME_RATE
#include <sys/time.h>

#define tv_subtract(e,s) ((e).tv_sec-(s).tv_sec+((e).tv_usec-(s).tv_usec)*1e-6)

static float
timer_reset(struct timeval *timer)
{
    gettimeofday(timer, NULL);

    return 0.0f;
}

static float
timer_read(struct timeval *timer)
{
    struct timeval now;

    gettimeofday(&now, NULL);

    return tv_subtract(now, *timer);
}
#endif

void
glXSwapBuffers(Display *dpy, GLXDrawable drawable)
{
#ifdef SHOW_FRAME_RATE
    static int framecount = -1;
    static struct timeval time;
    if (framecount < 0) {
	timer_reset(&time);
    }
    framecount++;
    if (framecount == 100) {
	glt_warn("glt: frame rate = %.2f", 100.0f / timer_read(&time));
	framecount = 0;
	timer_reset(&time);
    }
#endif
    glt_put(&__trace, GLT_OP_SWAP_BUFFERS, NULL);
    fptable.glXSwapBuffers(dpy, drawable);
    if ((__count > 0) && (--__count == 0))
	exit(0);
}

void
glXUseXFont( Font a, int b, int c, int d )
{
    fptable.glXUseXFont( a, b, c, d );
}

void
glXWaitGL( void )
{
    fptable.glXWaitGL( );
}

void
glXWaitX( void )
{
    fptable.glXWaitX( );
}

const char *
glXQueryExtensionsString( Display *a, int b )
{
    return fptable.glXQueryExtensionsString( a, b );
}

const char *
glXGetClientString( Display *a, int b )
{
    return fptable.glXGetClientString( a, b );
}

const char *
glXQueryServerString( Display *a, int b, int c )
{
    return fptable.glXQueryServerString( a, b, c );
}

#ifdef IRIX

/* SGI extensions */

GLXContext
glXCreateContextWithConfigSGIX(Display *a, GLXFBConfigSGIX b, int c, 
	GLXContext d, Bool e)
{
    return fptable.glXCreateContextWithConfigSGIX(a, b, c, d, e);
}

GLXFBConfigSGIX 
glXGetFBConfigFromVisualSGIX(Display * a, XVisualInfo * b)
{
    return fptable.glXGetFBConfigFromVisualSGIX(a, b);
}

int 
glXGetFBConfigAttribSGIX(Display *a, GLXFBConfigSGIX b, int c, int * d)
{
    return fptable.glXGetFBConfigAttribSGIX(a, b, c, d);
}

#endif

[]

[writevecs glFog[fi]v]
        switch (pname) {
	case GL_FOG_COLOR:
#if 0
	case GL_FOG_OFFSET_VALUE_SGIX:
#endif
	    data.params[0] = params[0];
	    data.params[1] = params[1];
	    data.params[2] = params[2];
	    data.params[3] = params[3];
	    break;
	case GL_FOG_MODE:
	case GL_FOG_DENSITY:
	case GL_FOG_START:
	case GL_FOG_END:
	case GL_FOG_INDEX:
	    data.params[0] = params[0];
	    data.params[1] = 0;
	    data.params[2] = 0;
	    data.params[3] = 0;
	    break;
	default:
	    ONCE(glt_mesg_va(GLT_EWARN, ("glt: unsupported Fog[fi]v pname 0x%04x", pname)));
	    data.params[0] = 0;
	    data.params[1] = 0;
	    data.params[2] = 0;
	    data.params[3] = 0;
	    break;
	}
[]

[writevecs glLight[fi]v]
        switch (pname) {
	case GL_AMBIENT:
	case GL_DIFFUSE:
	case GL_SPECULAR:
	case GL_POSITION:
	    data.params[0] = params[0];
	    data.params[1] = params[1];
	    data.params[2] = params[2];
	    data.params[3] = params[3];
	    break;
	case GL_SPOT_DIRECTION:
	    data.params[0] = params[0];
	    data.params[1] = params[1];
	    data.params[2] = params[2];
	    data.params[3] = 0;
	    break;
	case GL_SPOT_EXPONENT:
	case GL_SPOT_CUTOFF:
	case GL_CONSTANT_ATTENUATION:
	case GL_LINEAR_ATTENUATION:
	case GL_QUADRATIC_ATTENUATION:
	    data.params[0] = params[0];
	    data.params[1] = 0;
	    data.params[2] = 0;
	    data.params[3] = 0;
	    break;
	default:
	    ONCE(glt_mesg_va(GLT_EWARN, ("glt: unsupported Light[fi]v pname 0x%04x", pname)));
	    data.params[0] = 0;
	    data.params[1] = 0;
	    data.params[2] = 0;
	    data.params[3] = 0;
	    break;
	}
[]

[writevecs glLightModel[fi]v]
        switch (pname) {
	case GL_LIGHT_MODEL_AMBIENT:
	    data.params[0] = params[0];
	    data.params[1] = params[1];
	    data.params[2] = params[2];
	    data.params[3] = params[3];
	    break;
	case GL_LIGHT_MODEL_LOCAL_VIEWER:
	case GL_LIGHT_MODEL_TWO_SIDE:
	    data.params[0] = params[0];
	    data.params[1] = 0;
	    data.params[2] = 0;
	    data.params[3] = 0;
	    break;
	default:
	    ONCE(glt_mesg_va(GLT_EWARN, ("glt: unsupported LightModel[fi]v pname 0x%04x", pname)));
	    data.params[0] = 0;
	    data.params[1] = 0;
	    data.params[2] = 0;
	    data.params[3] = 0;
	    break;
	}
[]

[writevecs glMaterial[fi]v]
        switch (pname) {
	case GL_AMBIENT:
	case GL_DIFFUSE:
	case GL_SPECULAR:
	case GL_EMISSION:
	case GL_AMBIENT_AND_DIFFUSE:
	    data.params[0] = params[0];
	    data.params[1] = params[1];
	    data.params[2] = params[2];
	    data.params[3] = params[3];
	    break;
#if 0
	case GL_COLOR_INDICES:
	    data.params[0] = params[0];
	    data.params[1] = params[1];
	    data.params[2] = params[2];
	    data.params[3] = 0;
	    break;
#endif
	case GL_SHININESS:
	    data.params[0] = params[0];
	    data.params[1] = 0;
	    data.params[2] = 0;
	    data.params[3] = 0;
	    break;

	default:
	    ONCE(glt_mesg_va(GLT_EWARN, ("glt: unsupported Material[fi]v pname 0x%04x", pname)));
	    data.params[0] = 0;
	    data.params[1] = 0;
	    data.params[2] = 0;
	    data.params[3] = 0;
	    break;
	}
[]

[writevecs glTexEnv[fi]v]
        switch (pname) {
	case GL_TEXTURE_ENV_COLOR:
#if 0
	case GL_TEXTURE_ENV_BIAS_SGIX:
#endif
	    data.params[0] = params[0];
	    data.params[1] = params[1];
	    data.params[2] = params[2];
	    data.params[3] = params[3];
	    break;
	case GL_TEXTURE_ENV_MODE:
	    data.params[0] = params[0];
	    data.params[1] = 0;
	    data.params[2] = 0;
	    data.params[3] = 0;
	    break;
	default:
	    ONCE(glt_mesg_va(GLT_EWARN, ("glt: unsupported TexEnv[fi]v pname 0x%04x", pname)));
	    data.params[0] = 0;
	    data.params[1] = 0;
	    data.params[2] = 0;
	    data.params[3] = 0;
	    break;
	}
[]

[writevecs glTexParameter[fi]v]
        switch (pname) {
	case GL_TEXTURE_BORDER_COLOR:
#if 0
	case GL_POST_TEXTURE_FILTER_BIAS_SGIX:
	case GL_POST_TEXTURE_FILTER_SCALE_SGIX:
#endif
	    data.params[0] = params[0];
	    data.params[1] = params[1];
	    data.params[2] = params[2];
	    data.params[3] = params[3];
	    break;
#if 0
	case GL_TEXTURE_CLIPMAP_FRAME_SGIX:
	case GL_TEXTURE_CLIPMAP_OFFSET_SGIX:
	    data.params[0] = params[0];
	    data.params[1] = params[1];
	    data.params[2] = 0;
	    data.params[3] = 0;
	    break;
#endif
	case GL_TEXTURE_MIN_FILTER:
	case GL_TEXTURE_MAG_FILTER:
	case GL_TEXTURE_WRAP_S:
	case GL_TEXTURE_WRAP_T:
#if 0
	case GL_TEXTURE_WRAP_R_EXT:
	case GL_TEXTURE_WRAP_Q_SGIS:
	case GL_DETAIL_TEXTURE_LEVEL_SGIS:
	case GL_DETAIL_TEXTURE_MODE_SGIS:
	case GL_TEXTURE_PRIORITY_EXT:
	case GL_TEXTURE_BASE_LEVEL_SGIS:
	case GL_TEXTURE_MAX_LEVEL_SGIS:
	case GL_TEXTURE_MIN_LOD_SGIS:
	case GL_TEXTURE_MAX_LOD_SGIS:
	case GL_DUAL_TEXTURE_SELECT_SGIS:
	case GL_QUAD_TEXTURE_SELECT_SGIS:
	case GL_TEXTURE_CLIPMAP_CENTER_SGIX:
	case GL_TEXTURE_COMPARE_SGIX:
	case GL_TEXTURE_COMPARE_OPERATOR_SGIX:
	case GL_SHADOW_AMBIENT_SGIX:
#endif
	    data.params[0] = params[0];
	    data.params[1] = 0;
	    data.params[2] = 0;
	    data.params[3] = 0;
	    break;
	default:
	    ONCE(glt_mesg_va(GLT_EWARN, ("glt: unsupported TexParameter[fi]v pname 0x%04x", pname)));
	    data.params[0] = 0;
	    data.params[1] = 0;
	    data.params[2] = 0;
	    data.params[3] = 0;
	    break;
	}
[]

[writevecs glCallLists]
        switch (type) {
	case GL_BYTE:
	case GL_UNSIGNED_BYTE:
	    data.n_lists = n * sizeof(GLbyte);
	    break;
	case GL_SHORT:
	case GL_UNSIGNED_SHORT:
	    data.n_lists = n * sizeof(GLshort);
	    break;
	case GL_INT:
	case GL_UNSIGNED_INT:
	    data.n_lists = n * sizeof(GLint);
	    break;
	case GL_FLOAT:
	    data.n_lists = n * sizeof(GLfloat);
	    break;
	case GL_2_BYTES:
	    data.n_lists = n * 2 * sizeof(GLbyte);
	    break;
	case GL_3_BYTES:
	    data.n_lists = n * 3 * sizeof(GLbyte);
	    break;
	case GL_4_BYTES:
	    data.n_lists = n * 4 * sizeof(GLbyte);
	    break;
	default:
	    ONCE(glt_mesg_va(GLT_EWARN, ("glt: unsupported glCallLists type 0x%04x", type)));
	    data.n_lists = 0;
	    break;
	}
data.lists = (GLvoid *)lists;
[]

[writevecs glDeleteTextures(EXT)?]
        data.n_textures = n * sizeof(GLuint);
        data.textures = (GLuint *)textures;
[]

[writevecs glPrioritizeTextures(EXT)?]
        data.n_textures = n * sizeof(GLuint);
        data.textures = (GLuint *)textures;
        data.n_priorities = n * sizeof(GLclampf);
        data.priorities = (GLclampf *)priorities;
[]

[writevecs gl(DrawPixels|Tex(Sub)?Image2D)]
        glt_mesg_va(GLT_PSTORE, ("glt: PIXEL POINTER! w=%d h=%d p=0x%08x", width, height, pixels));
        if (!pixels) {
	    data.n_pixels = 0;
	    data.pixels = NULL;
	}
        else {
	    int L = __ps_state.row_length;
	    int R = __ps_state.skip_rows;
	    int P = __ps_state.skip_pixels;
	    int A = __ps_state.unpack_alignment;
	    int n; /* elements per group */
	    int s; /* bytes per group (not bytes per element) */
	    int l = (L > 0) ? L : width; /* groups per row */
	    int k; /* bytes per row, rounded up to alignment */
	    int w; /* width, in bytes */
	    char *p; /* pixel pointer */
	    switch (format) {
	    case GL_COLOR_INDEX:
	    case GL_STENCIL_INDEX:
	    case GL_DEPTH_COMPONENT:
	    case GL_RED:
	    case GL_GREEN:
	    case GL_BLUE:
	    case GL_ALPHA:
	    case GL_LUMINANCE:
		n = 1;
		break;
	    case GL_LUMINANCE_ALPHA:
		n = 2;
		break;
	    case GL_RGB:
		n = 3;
		break;
	    case GL_RGBA:
	    case GL_ABGR_EXT:
		n = 4;
		break;
	    default:
		ONCE(glt_mesg_va(GLT_PSTORE, ("glt: unsupported gl(DrawPixels|Tex(Sub)?Image2D) format 0x%04x", format)));
		n = 0;
		break;
	    }
	    switch (type) {
	    case GL_BYTE:
	    case GL_UNSIGNED_BYTE:
		s = n * sizeof(GLbyte);
		break;
	    case GL_SHORT:
	    case GL_UNSIGNED_SHORT:
		s = n * sizeof(GLshort);
		break;
	    case GL_INT:
	    case GL_UNSIGNED_INT:
		s = n * sizeof(GLint);
		break;
	    case GL_FLOAT:
		s = n * sizeof(GLfloat);
		break;
	    case GL_UNSIGNED_BYTE_3_3_2_EXT:
		s = (n == 3) ? sizeof(GLbyte) : 0;
		break;
	    case GL_UNSIGNED_SHORT_4_4_4_4_EXT:
	    case GL_UNSIGNED_SHORT_5_5_5_1_EXT:
		s = (n == 4) ? sizeof(GLshort) : 0;
		break;
	    case GL_UNSIGNED_INT_8_8_8_8_EXT:
	    case GL_UNSIGNED_INT_10_10_10_2_EXT:
		s = (n == 4) ? sizeof(GLint) : 0;
		break;
	    case GL_BITMAP:
		ONCE(glt_mesg(GLT_PSTORE, "glt: unsupported gl(DrawPixels|Tex(Sub)?Image2D) type GL_BITMAP"));
		s = 0;
		break;
	    default:
		ONCE(glt_mesg_va(GLT_PSTORE, ("glt: unsupported gl(DrawPixels|Tex(Sub)?Image2D) type 0x%04x", type)));
		s = 0;
		break;
	    }
	    /* Hack? Really correct? */
	    k = s * l;
	    k += ALIGN(k, A);
	    w = width * s;
	    p = &((char *)pixels)[R * k + P * s];
	    data.n_pixels = w * height;
	    glt_mesg_va(GLT_PSTORE, ("glt: L=%d n=%d s=%d l=%d k=%d w=%d n_pixels=%d p=0x%08x", L, n, s, l, k, w, data.n_pixels, p));
	    if (k == w) {
		glt_mesg(GLT_PSTORE, "glt: no pixel copy");
		data.pixels = (GLvoid *)p;
	    }
	    else {
		/* Hack! glt_allocv is temporary */
		char *d = (char *)glt_allocv(&__trace, data.n_pixels);
		int y = 0;
		glt_mesg_va(GLT_PSTORE, ("glt: copying... h=%d k=%d w=%d d=0x%08x",
					 height,k,w,d));
		data.pixels = (GLvoid *)d;
		for (y = 0; y < height; y++, p += k, d += w)
		    memcpy(d, p, w);
	    }
	}
[]

[specialencode glPixelStoref]
        GLT_pixel_storef data;
        switch (pname) {
	case GL_UNPACK_ROW_LENGTH:
	    __ps_state.row_length = ROUND(param);
	    break;
	case GL_UNPACK_SKIP_ROWS:
	    __ps_state.skip_rows = ROUND(param);
	    break;
	case GL_UNPACK_SKIP_PIXELS:
	    __ps_state.skip_pixels = ROUND(param);
	    break;
	case GL_UNPACK_ALIGNMENT:
	    __ps_state.unpack_alignment = ROUND(param);
	    break;
	default:
	    data.pname = pname;
	    data.param = param;
	    glt_put(&__trace, GLT_OP_PIXEL_STOREF, (GLT_data *)&data);
	    break;
	}
        glt_mesg_va(GLT_PSTORE, ("ps_state: %d %d %d %d", __ps_state));
[]

[specialencode glPixelStorei]
        GLT_pixel_storei data;
        switch (pname) {
	case GL_UNPACK_ROW_LENGTH:
	    __ps_state.row_length = param;
	    break;
	case GL_UNPACK_SKIP_ROWS:
	    __ps_state.skip_rows = param;
	    break;
	case GL_UNPACK_SKIP_PIXELS:
	    __ps_state.skip_pixels = param;
	    break;
	case GL_UNPACK_ALIGNMENT:
	    __ps_state.unpack_alignment = param;
	    break;
	default:
	    data.pname = pname;
	    data.param = param;
	    glt_put(&__trace, GLT_OP_PIXEL_STOREI, (GLT_data *)&data);
	    break;
	}
        glt_mesg_va(GLT_PSTORE, ("ps_state: %d %d %d %d", __ps_state));
[]

[specialencode glDisableClientState]
        switch (array) {
	case GL_EDGE_FLAG_ARRAY:
	    __edge_flag_array.enabled = 0;
	    break;
	case GL_TEXTURE_COORD_ARRAY:
	    __tex_coord_array.enabled = 0;
	    break;
	case GL_COLOR_ARRAY:
	    __color_array.enabled = 0;
	    break;
	case GL_INDEX_ARRAY:
	    __index_array.enabled = 0;
	    break;
	case GL_NORMAL_ARRAY:
	    __normal_array.enabled = 0;
	    break;
	case GL_VERTEX_ARRAY:
	    __vertex_array.enabled = 0;
	    break;
        default:
            break;
	}
[]

[specialencode glEnableClientState]
        switch (array) {
	case GL_EDGE_FLAG_ARRAY:
	    __edge_flag_array.enabled = 1;
	    break;
	case GL_TEXTURE_COORD_ARRAY:
	    __tex_coord_array.enabled = 1;
	    break;
	case GL_COLOR_ARRAY:
	    __color_array.enabled = 1;
	    break;
	case GL_INDEX_ARRAY:
	    __index_array.enabled = 1;
	    break;
	case GL_NORMAL_ARRAY:
	    __normal_array.enabled = 1;
	    break;
	case GL_VERTEX_ARRAY:
	    __vertex_array.enabled = 1;
	    break;
        default:
            break;
	}
[]

# EXT versions have count value; we ignore that parameter
[specialencode glEdgeFlagPointer(EXT)?]
        __edge_flag_array.stride = stride ? stride : 1;
        __edge_flag_array.pointer = (void *)pointer;
[]

[specialencode glTexCoordPointer(EXT)?]
        int typesize = 0;
        switch (type) {
	case GL_SHORT: typesize = sizeof(GLshort); break;
	case GL_INT: typesize = sizeof(GLint); break;
	case GL_FLOAT: typesize = sizeof(GLfloat); break;
	case GL_DOUBLE: typesize = sizeof(GLdouble); break;
        default:
            break;
	}
        if (size >= 1 && size <= 4 && typesize) {
	    __tex_coord_array.size = size;
            __tex_coord_array.type = type;
            __tex_coord_array.stride = stride ? stride : size * typesize;
	    __tex_coord_array.pointer = (void *)pointer;
	}
[]

[specialencode glColorPointer(EXT)?]
        int typesize = 0;
        switch (type) {
	case GL_BYTE: typesize = sizeof(GLbyte); break;
	case GL_UNSIGNED_BYTE: typesize = sizeof(GLubyte); break;
	case GL_SHORT: typesize = sizeof(GLshort); break;
	case GL_UNSIGNED_SHORT: typesize = sizeof(GLushort); break;
	case GL_INT: typesize = sizeof(GLint); break;
	case GL_UNSIGNED_INT: typesize = sizeof(GLuint); break;
	case GL_FLOAT: typesize = sizeof(GLfloat); break;
	case GL_DOUBLE: typesize = sizeof(GLdouble); break;
        default:
            break;
	}
        if (size >= 3 && size <= 4 && typesize) {
	    __color_array.size = size;
            __color_array.type = type;
            __color_array.stride = stride ? stride : size * typesize;
	    __color_array.pointer = (void *)pointer;
	}
[]

[specialencode glIndexPointer(EXT)?]
        int typesize = 0;
        switch (type) {
	case GL_UNSIGNED_BYTE: typesize = sizeof(GLubyte); break;
	case GL_SHORT: typesize = sizeof(GLshort); break;
	case GL_INT: typesize = sizeof(GLint); break;
	case GL_FLOAT: typesize = sizeof(GLfloat); break;
	case GL_DOUBLE: typesize = sizeof(GLdouble); break;
        default:
            break;
	}
        if (typesize) {
	    __index_array.type = type;
            __index_array.stride = stride ? stride : typesize;
	    __index_array.pointer = (void *)pointer;
	}
[]

[specialencode glNormalPointer(EXT)?]
        int typesize = 0;
        switch (type) {
	case GL_BYTE: typesize = sizeof(GLbyte); break;
	case GL_SHORT: typesize = sizeof(GLshort); break;
	case GL_INT: typesize = sizeof(GLint); break;
	case GL_FLOAT: typesize = sizeof(GLfloat); break;
	case GL_DOUBLE: typesize = sizeof(GLdouble); break;
        default:
            break;
	}
        if (typesize) {
	    __normal_array.type = type;
	    __normal_array.stride = stride ? stride : 3 * typesize;
	    __normal_array.pointer = (void *)pointer;
	}
[]

[specialencode glVertexPointer(EXT)?]
        int typesize = 0;
        switch (type) {
	case GL_SHORT: typesize = sizeof(GLshort); break;
	case GL_INT: typesize = sizeof(GLint); break;
	case GL_FLOAT: typesize = sizeof(GLfloat); break;
	case GL_DOUBLE: typesize = sizeof(GLdouble); break;
        default:
            break;
      	}
        if (size >= 2 && size <= 4 && typesize) {
	    __vertex_array.size = size;
            __vertex_array.type = type;
            __vertex_array.stride = stride ? stride : size * typesize;
	    __vertex_array.pointer = (void *)pointer;
	}
[]

[specialencode glInterleavedArrays]
        __edge_flag_array.enabled = 0;
        __tex_coord_array.enabled = 0;
        __color_array.enabled = 0;
        __index_array.enabled = 0;
        __normal_array.enabled = 0;
        __vertex_array.enabled = 1;
        switch (format) {
	case GL_V2F:
	    if (!stride)
		stride = 2 * sizeof(GLfloat);
            __vertex_array.size = 2;
	    __vertex_array.type = GL_FLOAT;
            __vertex_array.stride = stride;
            __vertex_array.pointer = (void *)pointer;
	    break;
	case GL_V3F:
	    if (!stride)
		stride = 3 * sizeof(GLfloat);
            __vertex_array.size = 3;
	    __vertex_array.type = GL_FLOAT;
            __vertex_array.stride = stride;
            __vertex_array.pointer = (void *)pointer;
	    break;
	case GL_C4UB_V2F:
	    if (!stride)
		stride = 4 * sizeof(GLubyte) + 2 * sizeof(GLfloat);
	    __color_array.enabled = 1;
            __color_array.size = 4;
            __color_array.type = GL_UNSIGNED_BYTE;
            __color_array.stride = stride;
            __color_array.pointer = (void *)pointer;
            __vertex_array.size = 2;
            __vertex_array.type = GL_FLOAT;
            __vertex_array.stride = stride;
            __vertex_array.pointer = &((char *)pointer)[4 * sizeof(GLubyte)];
	    break;
	case GL_C4UB_V3F:
	    if (!stride)
		stride = 4 * sizeof(GLubyte) + 3 * sizeof(GLfloat);
	    __color_array.enabled = 1;
            __color_array.size = 4;
            __color_array.type = GL_UNSIGNED_BYTE;
            __color_array.stride = stride;
            __color_array.pointer = (void *)pointer;
            __vertex_array.size = 3;
            __vertex_array.type = GL_FLOAT;
            __vertex_array.stride = stride;
            __vertex_array.pointer = &((char *)pointer)[4 * sizeof(GLubyte)];
	    break;
	case GL_C3F_V3F:
	    if (!stride)
		stride = 6 * sizeof(GLfloat);
	    __color_array.enabled = 1;
            __color_array.size = 3;
            __color_array.type = GL_FLOAT;
            __color_array.stride = stride;
            __color_array.pointer = (void *)pointer;
            __vertex_array.size = 3;
            __vertex_array.type = GL_FLOAT;
            __vertex_array.stride = stride;
            __vertex_array.pointer = &((char *)pointer)[3 * sizeof(GLfloat)];
	    break;
	case GL_N3F_V3F:
	    if (!stride)
		stride = 6 * sizeof(GLfloat);
	    __normal_array.enabled = 1;
            __normal_array.type = GL_FLOAT;
            __normal_array.stride = stride;
            __normal_array.pointer = (void *)pointer;
            __vertex_array.size = 3;
            __vertex_array.type = GL_FLOAT;
            __vertex_array.stride = stride;
            __vertex_array.pointer = &((char *)pointer)[3 * sizeof(GLfloat)];
	    break;
	case GL_C4F_N3F_V3F:
	    if (!stride)
		stride = 10 * sizeof(GLfloat);
	    __color_array.enabled = 1;
            __color_array.size = 4;
            __color_array.type = GL_FLOAT;
            __color_array.stride = stride;
            __color_array.pointer = (void *)pointer;
	    __normal_array.enabled = 1;
            __normal_array.type = GL_FLOAT;
            __normal_array.stride = stride;
            __normal_array.pointer = &((char *)pointer)[4 * sizeof(GLfloat)];
	    __vertex_array.size = 3;
	    __vertex_array.type = GL_FLOAT;
            __vertex_array.stride = stride;
            __vertex_array.pointer = &((char *)pointer)[7 * sizeof(GLfloat)];
	    break;	    
	case GL_T2F_V3F:
	    if (!stride)
		stride = 5 * sizeof(GLfloat);
	    __tex_coord_array.enabled = 1;
            __tex_coord_array.size = 2;
            __tex_coord_array.type = GL_FLOAT;
            __tex_coord_array.stride = stride;
            __tex_coord_array.pointer = (void *)pointer;
            __vertex_array.size = 3;
            __vertex_array.type = GL_FLOAT;
            __vertex_array.stride = stride;
            __vertex_array.pointer = &((char *)pointer)[2 * sizeof(GLfloat)];
	    break;
	case GL_T4F_V4F:
	    if (!stride)
		stride = 8 * sizeof(GLfloat);
	    __tex_coord_array.enabled = 1;
            __tex_coord_array.size = 4;
            __tex_coord_array.type = GL_FLOAT;
            __tex_coord_array.stride = stride;
            __tex_coord_array.pointer = (void *)pointer;
            __vertex_array.size = 4;
            __vertex_array.type = GL_FLOAT;
	    __vertex_array.stride = stride;
            __vertex_array.pointer = &((char *)pointer)[4 * sizeof(GLfloat)];
	    break;
	case GL_T2F_C4UB_V3F:
	    if (!stride)
		stride = 4 * sizeof(GLubyte) + 5 * sizeof(GLfloat);
	    __tex_coord_array.enabled = 1;
            __tex_coord_array.size = 2;
            __tex_coord_array.type = GL_FLOAT;
            __tex_coord_array.stride = stride;
            __tex_coord_array.pointer = (void *)pointer;
	    __color_array.enabled = 1;
            __color_array.size = 4;
            __color_array.type = GL_UNSIGNED_BYTE;
            __color_array.stride = stride;
            __color_array.pointer = &((char *)pointer)[2 * sizeof(GLfloat)];
            __vertex_array.size = 3;
            __vertex_array.type = GL_FLOAT;
            __vertex_array.stride = stride;
            __vertex_array.pointer =
		&((char *)pointer)[4 * sizeof(GLubyte) + 2 * sizeof(GLfloat)];
	    break;
	case GL_T2F_C3F_V3F:
	    if (!stride)
		stride = 8 * sizeof(GLfloat);
	    __tex_coord_array.enabled = 1;
            __tex_coord_array.size = 2;
            __tex_coord_array.type = GL_FLOAT;
            __tex_coord_array.stride = stride;
            __tex_coord_array.pointer = (void *)pointer;
	    __color_array.enabled = 1;
            __color_array.size = 3;
            __color_array.type = GL_FLOAT;
            __color_array.stride = stride;
            __color_array.pointer = &((char *)pointer)[2 * sizeof(GLfloat)];
            __vertex_array.size = 3;
            __vertex_array.type = GL_FLOAT;
            __vertex_array.stride = stride;
            __vertex_array.pointer = &((char *)pointer)[5 * sizeof(GLfloat)];
	    break;	    
	case GL_T2F_N3F_V3F:
	    if (!stride)
		stride = 8 * sizeof(GLfloat);
	    __tex_coord_array.enabled = 1;
            __tex_coord_array.size = 2;
            __tex_coord_array.type = GL_FLOAT;
            __tex_coord_array.stride = stride;
            __tex_coord_array.pointer = (void *)pointer;
	    __normal_array.enabled = 1;
            __normal_array.type = GL_FLOAT;
            __normal_array.stride = stride;
            __normal_array.pointer = &((char *)pointer)[2 * sizeof(GLfloat)];
            __vertex_array.size = 3;
            __vertex_array.type = GL_FLOAT;
            __vertex_array.stride = stride;
            __vertex_array.pointer = &((char *)pointer)[5 * sizeof(GLfloat)];
	    break;	    
	case GL_T2F_C4F_N3F_V3F:
	    if (!stride)
		stride = 12 * sizeof(GLfloat);
	    __tex_coord_array.enabled = 1;
            __tex_coord_array.size = 2;
            __tex_coord_array.type = GL_FLOAT;
            __tex_coord_array.stride = stride;
            __tex_coord_array.pointer = (void *)pointer;
	    __color_array.enabled = 1;
            __color_array.size = 4;
            __color_array.type = GL_FLOAT;
            __color_array.stride = stride;
            __color_array.pointer = &((char *)pointer)[2 * sizeof(GLfloat)];
	    __normal_array.enabled = 1;
            __normal_array.type = GL_FLOAT;
            __normal_array.stride = stride;
            __normal_array.pointer = &((char *)pointer)[6 * sizeof(GLfloat)];
            __vertex_array.size = 3;
            __vertex_array.type = GL_FLOAT;
            __vertex_array.stride = stride;
            __vertex_array.pointer = &((char *)pointer)[9 * sizeof(GLfloat)];
	    break;	    
	case GL_T4F_C4F_N3F_V4F:
	    if (!stride)
		stride = 15 * sizeof(GLfloat);
	    __tex_coord_array.enabled = 1;
            __tex_coord_array.size = 4;
            __tex_coord_array.type = GL_FLOAT;
            __tex_coord_array.stride = stride;
            __tex_coord_array.pointer = (void *)pointer;
	    __color_array.enabled = 1;
            __color_array.size = 4;
            __color_array.type = GL_FLOAT;
            __color_array.stride = stride;
            __color_array.pointer = &((char *)pointer)[4 * sizeof(GLfloat)];
	    __normal_array.enabled = 1;
            __normal_array.type = GL_FLOAT;
            __normal_array.stride = stride;
            __normal_array.pointer = &((char *)pointer)[8 * sizeof(GLfloat)];
            __vertex_array.size = 4;
            __vertex_array.type = GL_FLOAT;
            __vertex_array.stride = stride;
            __vertex_array.pointer = &((char *)pointer)[11 * sizeof(GLfloat)];
	    break;	    
        default:
            break;
	}
[]

[specialencode glArrayElement(EXT)?]
        __varray_element(i);
[]

[specialencode glDrawArrays(EXT)?]
        GLT_data data;
        int i;
        switch (mode) {
	case GL_POINTS:
	case GL_LINES:
	case GL_LINE_LOOP:
	case GL_LINE_STRIP:
	case GL_TRIANGLES:
	case GL_TRIANGLE_STRIP:
	case GL_TRIANGLE_FAN:
	case GL_QUADS:
	case GL_QUAD_STRIP:
	case GL_POLYGON:
	    data.begin.mode = mode;
	    glt_put(&__trace, GLT_OP_BEGIN, &data);
	    for (i = first; i < first + count; i++)
		__varray_element(i);
	    glt_put(&__trace, GLT_OP_END, NULL);
            break;
        default:
            break;
	}
[]

[specialencode glDrawElements]
        GLT_data data;
        int i;
        switch (mode) {
	case GL_POINTS:
	case GL_LINES:
	case GL_LINE_LOOP:
	case GL_LINE_STRIP:
	case GL_TRIANGLES:
	case GL_TRIANGLE_STRIP:
	case GL_TRIANGLE_FAN:
	case GL_QUADS:
	case GL_QUAD_STRIP:
	case GL_POLYGON:
	    switch (type) {
	    case GL_UNSIGNED_BYTE:
		data.begin.mode = mode;
		glt_put(&__trace, GLT_OP_BEGIN, &data);
		for (i = 0; i < count; i++)
		    __varray_element(((GLubyte *)indices)[i]);
		glt_put(&__trace, GLT_OP_END, NULL);
		break;
	    case GL_UNSIGNED_SHORT:
		data.begin.mode = mode;
		glt_put(&__trace, GLT_OP_BEGIN, &data);
		for (i = 0; i < count; i++)
		    __varray_element(((GLushort *)indices)[i]);
		glt_put(&__trace, GLT_OP_END, NULL);
		break;
	    case GL_UNSIGNED_INT:
		data.begin.mode = mode;
		glt_put(&__trace, GLT_OP_BEGIN, &data);
		for (i = 0; i < count; i++)
		    __varray_element(((GLuint *)indices)[i]);
		glt_put(&__trace, GLT_OP_END, NULL);
		break;
            default:
                break;
	    }
        default:
            break;
	}
[]
