#!/usr/common/bin/perl
#
# glimpl.c.pl
#
# Kekoa Proudfoot 3/31/98, 5/6/98
#

use lib "../perl/modules";

# Bleah, I prefer Include qw(shared.in), but that gives errors until 5.004
use Includes;

use Special qw(glimpl.c.sp);

use Opcodes qw(: @fnames fntolb lbtofn);
use Flags   qw(: %ignore %noencode %lengths %notopengl);
use Headers qw(: fntype fnpnames fnptypes fnparms);
use Special qw(: $fpstruct_add $fnames_add $static_add $funcs_add);
use Special qw(: %writevecs %specialencode);
use Encode  qw(fnpstypes fnpisvecs fnpveclens fnssize fnspad fnsname);

foreach $name (@fnames) {
    push(@names, $name) unless ($ignore{$name} || $notopengl{$name});
}

print("/*\n");
print(" * glimpl.c\n");
print(" *\n");
print(" * Machine generated gl trace implementation\n");
print(" *\n");
print(" */\n");
print("\n");

print("/* Include files */\n");
print("\n");

print("#include <stdio.h>\n");
print("#include <stdlib.h>\n");
print("#include <string.h>\n");
print("#include <dlfcn.h>\n");
print("\n");
print("#include <GL/gl.h>\n");
print("#include <GL/glx.h>\n");
print("\n");
print("#include <glt.h>\n");
print("\n");

%extra_defines = ( 
		  'GL_UNSIGNED_BYTE_3_3_2_EXT'     => '0x8032',
  		  'GL_UNSIGNED_BYTE_3_3_2'         => '0x8032',
 		  'GL_UNSIGNED_BYTE_3_3_2_EXT'     => '0x8032',
 		  'GL_UNSIGNED_SHORT_4_4_4_4'      => '0x8033',
 		  'GL_UNSIGNED_SHORT_4_4_4_4_EXT'  => '0x8033',
 		  'GL_UNSIGNED_SHORT_5_5_5_1'      => '0x8034',
 		  'GL_UNSIGNED_SHORT_5_5_5_1_EXT'  => '0x8034',
 		  'GL_UNSIGNED_INT_8_8_8_8'        => '0x8035',
 		  'GL_UNSIGNED_INT_8_8_8_8_EXT'    => '0x8035',
 		  'GL_UNSIGNED_INT_10_10_10_2'     => '0x8036',
 		  'GL_UNSIGNED_INT_10_10_10_2_EXT' => '0x8036'
		 );

foreach $name ( keys %extra_defines ) {
    print("#ifndef ${name}\n");
    print("#define ${name} $extra_defines{$name}\n");
    print("#endif\n");
}
print("\n");

print("/* Macros */\n");
print("\n");

print("#ifndef NDEBUG\n");
print("#define ONCE(cmd) \\\n");
print("    do { \\\n");
print("        static int once = 0; \\\n");
print("        if (!once && ++once) cmd ; \\\n");
print("    } while (0)\n");
print("#else\n");
print("#define ONCE(cmd)\n");
print("#endif\n");
print("\n");

print("#define ROUND(x) (((x)>0.0f)?(int)((x)+0.5f):(int)((x)-0.5f))\n");
print("\n");

print("#define ALIGN(p,a) (-(int)(p)&((a)-1))\n");
print("\n");

print("/* Hack? Wrong place? */\n");
print("static GLT_trace __trace;\n");
print("\n");
print("/* Hack? Wrong place? */\n");
print("static int __count = -1;\n");
print("static int __call_level = 0;\n");

print("\n");

print("/* Hack? Wrong place? */\n");
print("typedef struct {\n");
print("    int row_length;\n");
print("    int skip_rows;\n");
print("    int skip_pixels;\n");
print("    int unpack_alignment;\n");
print("} PS_state;\n");
print("\n");
print("static PS_state __ps_state = { 0, 0, 0, 4 };\n");
print("\n");

print("/* GL function pointer struct */\n");
print("\n");

print("static struct {\n");

foreach $name (@names) {
    $type = fntype($name);
    $ptypes = fnptypes($name);
    print("    $type (*$name)($ptypes);\n");
}

print("$fpstruct_add\n");
print("} fptable;\n");
print("\n");

print("/* GL function names */\n");
print("\n");

print("static char *fnames[] = {\n");

foreach $name (@names) {
    print("    \"$name\",\n");
}

print("$fnames_add\n");
print("};\n");
print("\n");

print("$static_add\n");
print("\n");

print("/* GL functions */\n");
print("\n");

foreach $name (@names) {
    $type = fntype($name);
    $parms = fnparms($name);
    $pnames = fnpnames($name);
    $noencode = $noencode{$name};
    $writevecs = $writevecs{$name};
    $specialencode = $specialencode{$name};
    print("$type\n");
    print("$name($parms)\n");
    print("{\n");
    print("    $type retvalue;\n") if ($type ne 'void');
    print("    int call_level = __call_level++;\n");
    print("    if (call_level == 0) {\n");
    if ($noencode && !$specialencode) {
        print("        ONCE(glt_mesg(GLT_EWARN, \"glt: not encoding " .
	      "$name\"));\n");
    }
    elsif ($specialencode) {
	print("$specialencode\n");
    }
    else {
	$label = fntolb($name);
	@pnames = split(', ', $pnames);
	@pstypes = split(':', fnpstypes($name));
	@pisvecs = split(':', fnpisvecs($name));
	@pveclens = split(':', fnpveclens($name));
	$ssize = fnssize($name);
	$spad = fnspad($name);
	$sname = fnsname($name);
	if (!$ssize) {
	    print("        glt_put(&__trace, $label, NULL);\n");
	}
	else {
	    print("        $sname data;\n");
	    while (@pnames) {
		$pname = shift(@pnames);
		$pstype = shift(@pstypes);
		$pisvec = shift(@pisvecs);
		$pveclen = shift(@pveclens);
		if ($pisvec && $pveclen) {
		    if (!$writevecs) {
			for $i (0 .. $pveclen - 1) {
			    print("        data.${pname}[$i] = " .
				  "${pname}[$i];\n");
			}
		    }
		} elsif ($pisvec) { # !$pveclen implied
		    if (!$writevecs) {
			print("        ONCE(glt_mesg(GLT_EWARN, \"glt: " .
			      "encoding zero length vector for $name\"));\n");
			print("        data.n_${pname} = 0; /* for now */\n");
			print("        data.${pname} = ($pstype *)$pname;\n");
		    }
		} else {
		    print("        data.${pname} = $pname;\n");
		}
	    }
	    print("$writevecs\n") if ($writevecs);
	    for $i (0 .. $spad - 1) {
		print("        data.pad[$i] = 0;\n");
	    }
	    print("        glt_put(&__trace, $label, (GLT_data *)&data);\n");
	}
    }
    print("    }\n");
    print("    fptable.$name($pnames);\n") if ($type eq 'void');
    print("    retvalue = fptable.$name($pnames);\n") if ($type ne 'void');
    print("    __call_level = call_level;\n");
    print("    return retvalue;\n") if ($type ne 'void');
    print("}\n");
    print("\n");
}

print("$funcs_add\n");
print("\n");

print("/* Place holder for missing functions */\n");
print("\n");

print("static void\n");
print("__missing_sym(void)\n");
print("{\n");
print("    ONCE(glt_mesg(GLT_WARN, \"glt: missing symbol in libGL.so!\"));\n");
print("}\n");
print("\n");

print("/* Init function */\n");
print("\n");

print("#ifdef IRIX\n");
print("#if _MIPS_SIM == _ABI64\n");
print("#define LIBGL_SYS \"/usr/lib64/libGL.so\"\n");
print("#elif _MIPS_SIM == _ABIN32\n");
print("#define LIBGL_SYS \"/usr/lib32/libGL.so\"\n");
print("#else\n");
print("#define LIBGL_SYS \"/usr/lib/libGL.so\"\n");
print("#endif\n");
print("#endif\n");
print("\n");

print("#ifdef LINUX\n");
print("#define LIBGL_SYS \"/usr/lib/libGL.so\"\n");
print("#endif\n");
print("\n");

print("static int __good_init = 0;\n");
print("\n");

print("void\n");
print("__glt_init(void)\n");
print("{\n");
print("    char *filename = NULL;\n");
print("    char *value;\n");
print("    void *handle;\n");
print("    int memory = 0;\n");
print("    int unbuf = 0;\n");
print("    int i;\n");
print("    int flags;\n");
print("\n");
print("    /* Bleah! Calling exit anywhere in here causes a seg fault! */\n");
print("\n");
print("    if ((handle = dlopen(LIBGL_SYS, RTLD_LAZY)) == NULL) {\n");
print("        extern void _exit( int );\n");
print("        glt_warn(\"glt: couldn't open \" LIBGL_SYS);\n");
print("        _exit(0); /* Hack! to avoid the seg fault */\n");
print("    }\n");
print("\n");
print("    for (i = 0; i < sizeof(fnames) / sizeof(fnames[0]); i++)\n");
print("        if (!(((void **)&fptable)[i] = dlsym(handle, fnames[i])))\n");
print("            ((void (**)(void))&fptable)[i] = __missing_sym;\n");
print("\n");
print("    if ((value = getenv(\"__GLT_OUTPUT\"))) filename = value;\n");
print("    if ((value = getenv(\"__GLT_COUNT\"))) __count = atoi(value);\n");
print("    if ((value = getenv(\"__GLT_MEMORY\"))) memory = atoi(value);\n");
print("    if ((value = getenv(\"__GLT_DEBUG\"))) __glt_debug = atoi(value);\n");
print("    if ((value = getenv(\"__GLT_UNBUF\"))) unbuf = atoi(value);\n");
print("    /* Hack? But the trace file supports this */\n");
print("    if ((value = getenv(\"__GLT_DEBUGFILE\"))) {\n");
print("        FILE *errfile = fopen(value, \"w\");\n");
print("        if (errfile)\n");
print("            __glt_errfile = errfile;\n");
print("        else\n");
print("            glt_warn(\"glt: couldn't open debug file %s\", value);\n");
print("    }\n");
print("\n");
print("    glt_mesg(GLT_WARN, \"glt: initializing\");\n");
print("\n");
print("    if (filename)\n");
print("        glt_mesg_va(GLT_ENV, (\"output = %s\", filename));\n");
print("    else\n");
print("        glt_mesg(GLT_ENV, \"output = stdout\");\n");
print("    glt_mesg_va(GLT_ENV, (\"count  = %d\", __count));\n");
print("    glt_mesg_va(GLT_ENV, (\"memory = %d\", memory));\n");
print("    glt_mesg_va(GLT_ENV, (\"debug  = %d\", __glt_debug));\n");
print("    glt_mesg_va(GLT_ENV, (\"unbuf  = %d\", unbuf));\n");
print("\n");
print("    flags  = GLT_WRONLY;\n");
print("    flags |= (memory ? GLT_MEM : GLT_FILE);\n");
print("    flags |= (unbuf ? GLT_UNBUF : GLT_BUFFER);\n");
print("\n");
print("    glt_open(&__trace, filename, flags);\n");
print("\n");
print("    if (__count == 0) {\n");
print("        extern void _exit(int);\n");
print("        _exit(0); /* Hack! to avoid the seg fault */\n");
print("    }\n");
print("\n");
print("    __good_init = 1;\n");
print("}\n");
print("\n");

print("/* Cleanup function */\n");
print("\n");

print("void\n");
print("__glt_fini(void)\n");
print("{\n");
print("    glt_mesg(GLT_WARN, \"glt: finishing\");\n");
print("    if (__good_init)\n");
print("        glt_close(&__trace);\n");
print("    /* Hack? */\n");
print("#ifndef NDEBUG\n");
print("    __glt_printmem();\n");
print("#endif\n");
print("}\n");
print("\n");

print("#ifdef LINUX\n");
print("void (*__glt_init_ptr)(void) __attribute__((section(\".ctors\"))) = __glt_init;\n");
print("void (*__glt_fini_ptr)(void) __attribute__((section(\".dtors\"))) = __glt_fini;\n");
print("#endif\n");
